/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import java.util.Locale;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONCameraObject;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;

public class CameraSystem {
    public static boolean runningCustomCameras;
    private static boolean nightVisionEnabled;
    private static float currentFOV;
    private static float currentMouseSensitivity;
    public static String customCameraOverlay;
    private static final Point3D cameraOffset;
    private static final RotationMatrix riderOrientation;
    private static final JSONPotionEffect NIGHT_VISION_CAMERA_POTION;

    public static boolean adjustCamera(IWrapperPlayer player, Point3D cameraAdjustedPosition, RotationMatrix cameraRotation, float partialTicks) {
        JSONCameraObject camera;
        AEntityF_Multipart cameraProvider;
        AEntityB_Existing ridingEntity = player.getEntityRiding();
        PartSeat sittingSeat = ridingEntity instanceof PartSeat ? (PartSeat)ridingEntity : null;
        EntityPlayerGun playerGunEntity = EntityPlayerGun.playerClientGuns.get(player.getID());
        AEntityF_Multipart aEntityF_Multipart = cameraProvider = sittingSeat != null ? sittingSeat : playerGunEntity;
        if (currentFOV != 0.0f) {
            InterfaceManager.clientInterface.setFOV(currentFOV);
            currentFOV = 0.0f;
        }
        if (currentMouseSensitivity != 0.0f) {
            InterfaceManager.clientInterface.setMouseSensitivity(currentMouseSensitivity);
            currentMouseSensitivity = 0.0f;
        }
        if (nightVisionEnabled) {
            player.removePotionEffect(NIGHT_VISION_CAMERA_POTION);
            nightVisionEnabled = false;
        }
        customCameraOverlay = null;
        runningCustomCameras = false;
        if (InterfaceManager.clientInterface.inFirstPerson() && cameraProvider != null && (camera = cameraProvider.activeCamera) != null) {
            AnimationSwitchbox switchbox = cameraProvider.activeCameraSwitchbox;
            String string = customCameraOverlay = camera.overlay != null ? camera.overlay + ".png" : null;
            if (camera.fovOverride != 0.0f) {
                if (currentFOV == 0.0f) {
                    currentFOV = InterfaceManager.clientInterface.getFOV();
                }
                InterfaceManager.clientInterface.setFOV(camera.fovOverride);
            }
            if (camera.mouseSensitivityOverride != 0.0f) {
                if (currentMouseSensitivity == 0.0f) {
                    currentMouseSensitivity = InterfaceManager.clientInterface.getMouseSensitivity();
                }
                InterfaceManager.clientInterface.setMouseSensitivity(camera.mouseSensitivityOverride);
            }
            cameraAdjustedPosition.set(camera.pos);
            if (switchbox != null) {
                switchbox.runSwitchbox(partialTicks, false);
                cameraAdjustedPosition.transform(switchbox.netMatrix);
            }
            cameraProvider.activeCameraEntity.getInterpolatedOrientation(cameraRotation, partialTicks);
            cameraAdjustedPosition.rotate(cameraRotation);
            if (switchbox != null) {
                cameraRotation.multiply(switchbox.rotation);
            }
            if (camera.rot != null) {
                cameraRotation.multiply(camera.rot);
            }
            cameraOffset.set(cameraProvider.activeCameraEntity.prevPosition).interpolate(cameraProvider.activeCameraEntity.position, partialTicks);
            cameraAdjustedPosition.add(cameraOffset);
            if (camera.nightVision) {
                player.addPotionEffect(NIGHT_VISION_CAMERA_POTION);
                nightVisionEnabled = true;
            }
            runningCustomCameras = true;
            return true;
        }
        if (sittingSeat != null) {
            cameraAdjustedPosition.set(sittingSeat.prevRiderCameraPosition).interpolate(sittingSeat.riderCameraPosition, partialTicks);
            sittingSeat.getInterpolatedOrientation(cameraRotation, partialTicks);
            sittingSeat.getRiderInterpolatedOrientation(riderOrientation, partialTicks);
            cameraRotation.multiply(riderOrientation);
            return true;
        }
        return false;
    }

    static {
        cameraOffset = new Point3D();
        riderOrientation = new RotationMatrix();
        NIGHT_VISION_CAMERA_POTION = new JSONPotionEffect();
        CameraSystem.NIGHT_VISION_CAMERA_POTION.duration = 300;
        CameraSystem.NIGHT_VISION_CAMERA_POTION.name = JSONPotionEffect.PotionDefaults.NIGHT_VISION.name().toLowerCase(Locale.ROOT);
    }
}

