/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.components;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.packets.components.APacketEntity;

public abstract class APacketEntityInteract<MainEntityType extends AEntityA_Base, InteractingEntityType extends IWrapperEntity>
extends APacketEntity<MainEntityType> {
    private final UUID entityID;

    public APacketEntityInteract(MainEntityType entity, InteractingEntityType interactor) {
        super((AEntityA_Base)entity);
        this.entityID = interactor.getID();
    }

    public APacketEntityInteract(ByteBuf buf) {
        super(buf);
        this.entityID = APacketEntityInteract.readUUIDFromBuffer(buf);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        APacketEntityInteract.writeUUIDToBuffer(this.entityID, buf);
    }

    @Override
    public boolean handle(AWrapperWorld world, MainEntityType entity) {
        IWrapperEntity interactor = world.getExternalEntity(this.entityID);
        return interactor != null && this.handle(world, entity, interactor);
    }

    protected abstract boolean handle(AWrapperWorld var1, MainEntityType var2, InteractingEntityType var3);
}

