/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.components;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketBase;

public abstract class APacketEntity<EntityType extends AEntityA_Base>
extends APacketBase {
    private final UUID uniqueUUID;

    public APacketEntity(AEntityA_Base entity) {
        super(null);
        this.uniqueUUID = entity.uniqueUUID;
    }

    public APacketEntity(ByteBuf buf) {
        super(buf);
        this.uniqueUUID = APacketEntity.readUUIDFromBuffer(buf);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        APacketEntity.writeUUIDToBuffer(this.uniqueUUID, buf);
    }

    @Override
    public void handle(AWrapperWorld world) {
        Object entity = world.getEntity(this.uniqueUUID);
        if (entity != null && this.handle(world, entity) && !world.isClient()) {
            InterfaceManager.packetInterface.sendToAllClients(this);
            if (entity instanceof ATileEntityBase) {
                world.markTileEntityChanged(((ATileEntityBase)entity).position);
            }
        }
    }

    protected static int clampAngle(int min, int max, int value) {
        return value < min ? min : Math.min(value, max);
    }

    protected abstract boolean handle(AWrapperWorld var1, EntityType var2);
}

