/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.components;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitBlock;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitCollision;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitEntity;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitExternalEntity;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitGeneric;
import minecrafttransportsimulator.packets.instances.PacketEntityCameraChange;
import minecrafttransportsimulator.packets.instances.PacketEntityColorChange;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketEntityInstrumentChange;
import minecrafttransportsimulator.packets.instances.PacketEntityInteract;
import minecrafttransportsimulator.packets.instances.PacketEntityRiderChange;
import minecrafttransportsimulator.packets.instances.PacketEntityTextChange;
import minecrafttransportsimulator.packets.instances.PacketEntityTowingChange;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketFluidTankChange;
import minecrafttransportsimulator.packets.instances.PacketFurnaceFuelAdd;
import minecrafttransportsimulator.packets.instances.PacketFurnaceTimeSet;
import minecrafttransportsimulator.packets.instances.PacketGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketInventoryContainerChange;
import minecrafttransportsimulator.packets.instances.PacketItemInteractable;
import minecrafttransportsimulator.packets.instances.PacketPackImport;
import minecrafttransportsimulator.packets.instances.PacketPartChange_Add;
import minecrafttransportsimulator.packets.instances.PacketPartChange_Remove;
import minecrafttransportsimulator.packets.instances.PacketPartChange_Transfer;
import minecrafttransportsimulator.packets.instances.PacketPartEffector;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.packets.instances.PacketPartGroundDevice;
import minecrafttransportsimulator.packets.instances.PacketPartGun;
import minecrafttransportsimulator.packets.instances.PacketPartInteractable;
import minecrafttransportsimulator.packets.instances.PacketPartInteractableInteract;
import minecrafttransportsimulator.packets.instances.PacketPartSeat;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketPlayerCraftItem;
import minecrafttransportsimulator.packets.instances.PacketPlayerItemTransfer;
import minecrafttransportsimulator.packets.instances.PacketRadioStateChange;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpConnection;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpDispense;
import minecrafttransportsimulator.packets.instances.PacketTileEntityLoaderConnection;
import minecrafttransportsimulator.packets.instances.PacketTileEntityPoleChange;
import minecrafttransportsimulator.packets.instances.PacketTileEntityPoleCollisionUpdate;
import minecrafttransportsimulator.packets.instances.PacketTileEntityRoadChange;
import minecrafttransportsimulator.packets.instances.PacketTileEntityRoadCollisionUpdate;
import minecrafttransportsimulator.packets.instances.PacketTileEntityRoadConnectionUpdate;
import minecrafttransportsimulator.packets.instances.PacketTileEntitySignalControllerChange;
import minecrafttransportsimulator.packets.instances.PacketVehicleBeaconChange;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlNotification;
import minecrafttransportsimulator.packets.instances.PacketVehicleServerMovement;
import minecrafttransportsimulator.packets.instances.PacketWorldSavedDataRequest;
import minecrafttransportsimulator.packets.instances.PacketWorldSavedDataUpdate;
import minecrafttransportsimulator.packloading.PackParser;

public abstract class APacketBase {
    public APacketBase(ByteBuf buf) {
    }

    public boolean runOnMainThread() {
        return true;
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeByte((int)InterfaceManager.packetInterface.getPacketIndex(this));
    }

    public abstract void handle(AWrapperWorld var1);

    protected static void writeStringToBuffer(String string, ByteBuf buf) {
        byte[] stringAsBytes = string.getBytes(StandardCharsets.UTF_8);
        if (stringAsBytes.length > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Tried to write a string of: " + stringAsBytes.length + " bytes to a packet.  Max string byte size is: " + Short.MAX_VALUE);
        }
        buf.writeShort(stringAsBytes.length);
        buf.writeBytes(stringAsBytes);
    }

    protected static String readStringFromBuffer(ByteBuf buf) {
        short stringLength = buf.readShort();
        String returnString = buf.toString(buf.readerIndex(), (int)stringLength, StandardCharsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + stringLength);
        return returnString;
    }

    protected static void writeUUIDToBuffer(UUID uniqueUUID, ByteBuf buf) {
        buf.writeLong(uniqueUUID.getMostSignificantBits());
        buf.writeLong(uniqueUUID.getLeastSignificantBits());
    }

    protected static UUID readUUIDFromBuffer(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    protected static void writeItemToBuffer(AItemPack<?> item, ByteBuf buf) {
        APacketBase.writeStringToBuffer(((AJSONItem)item.definition).packID, buf);
        APacketBase.writeStringToBuffer(((AJSONItem)item.definition).systemName, buf);
        APacketBase.writeStringToBuffer(item instanceof AItemSubTyped ? ((AItemSubTyped)item).subDefinition.subName : "", buf);
    }

    protected static <T extends AItemPack<?>> T readItemFromBuffer(ByteBuf buf) {
        return (T)PackParser.getItem(APacketBase.readStringFromBuffer(buf), APacketBase.readStringFromBuffer(buf), APacketBase.readStringFromBuffer(buf));
    }

    protected static void writePoint3dToBuffer(Point3D point, ByteBuf buf) {
        buf.writeDouble(point.x);
        buf.writeDouble(point.y);
        buf.writeDouble(point.z);
    }

    protected static Point3D readPoint3dFromBuffer(ByteBuf buf) {
        return new Point3D(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    protected static void writePoint3dCompactToBuffer(Point3D point, ByteBuf buf) {
        buf.writeInt((int)point.x);
        buf.writeInt((int)point.y);
        buf.writeInt((int)point.z);
    }

    protected static Point3D readPoint3dCompactFromBuffer(ByteBuf buf) {
        return new Point3D(buf.readInt(), buf.readInt(), buf.readInt());
    }

    protected static void writeDataToBuffer(IWrapperNBT data, ByteBuf buf) {
        InterfaceManager.packetInterface.writeDataToBuffer(data, buf);
    }

    protected static IWrapperNBT readDataFromBuffer(ByteBuf buf) {
        return InterfaceManager.packetInterface.readDataFromBuffer(buf);
    }

    public static void initPackets(byte packetIndex) {
        byte by = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by, PacketPackImport.class);
        byte by2 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by2, PacketEntityCameraChange.class);
        byte by3 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by3, PacketEntityColorChange.class);
        byte by4 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by4, PacketEntityInstrumentChange.class);
        byte by5 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by5, PacketEntityRiderChange.class);
        byte by6 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by6, PacketEntityTextChange.class);
        byte by7 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by7, PacketEntityTowingChange.class);
        byte by8 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by8, PacketEntityVariableIncrement.class);
        byte by9 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by9, PacketEntityVariableSet.class);
        byte by10 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by10, PacketEntityVariableToggle.class);
        byte by11 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by11, PacketEntityInteract.class);
        byte by12 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by12, PacketEntityBulletHitGeneric.class);
        byte by13 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by13, PacketEntityBulletHitCollision.class);
        byte by14 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by14, PacketEntityBulletHitEntity.class);
        byte by15 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by15, PacketEntityBulletHitExternalEntity.class);
        byte by16 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by16, PacketEntityBulletHitBlock.class);
        byte by17 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by17, PacketFluidTankChange.class);
        byte by18 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by18, PacketInventoryContainerChange.class);
        byte by19 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by19, PacketItemInteractable.class);
        byte by20 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by20, PacketFurnaceFuelAdd.class);
        byte by21 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by21, PacketFurnaceTimeSet.class);
        byte by22 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by22, PacketGUIRequest.class);
        byte by23 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by23, PacketEntityGUIRequest.class);
        byte by24 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by24, PacketPartChange_Add.class);
        byte by25 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by25, PacketPartChange_Remove.class);
        byte by26 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by26, PacketPartChange_Transfer.class);
        byte by27 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by27, PacketPartGun.class);
        byte by28 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by28, PacketPartEffector.class);
        byte by29 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by29, PacketPartEngine.class);
        byte by30 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by30, PacketPartGroundDevice.class);
        byte by31 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by31, PacketPartInteractable.class);
        byte by32 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by32, PacketPartInteractableInteract.class);
        byte by33 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by33, PacketPartSeat.class);
        byte by34 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by34, PacketPlayerChatMessage.class);
        byte by35 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by35, PacketPlayerCraftItem.class);
        byte by36 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by36, PacketPlayerItemTransfer.class);
        byte by37 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by37, PacketRadioStateChange.class);
        byte by38 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by38, PacketTileEntityLoaderConnection.class);
        byte by39 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by39, PacketTileEntityFuelPumpConnection.class);
        byte by40 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by40, PacketTileEntityFuelPumpDispense.class);
        byte by41 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by41, PacketTileEntityRoadCollisionUpdate.class);
        byte by42 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by42, PacketTileEntityPoleChange.class);
        byte by43 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by43, PacketTileEntityPoleCollisionUpdate.class);
        byte by44 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by44, PacketTileEntityRoadChange.class);
        byte by45 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by45, PacketTileEntityRoadConnectionUpdate.class);
        byte by46 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by46, PacketTileEntitySignalControllerChange.class);
        byte by47 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by47, PacketVehicleBeaconChange.class);
        byte by48 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by48, PacketVehicleControlNotification.class);
        byte by49 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by49, PacketVehicleServerMovement.class);
        byte by50 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by50, PacketWorldSavedDataRequest.class);
        byte by51 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by51, PacketWorldSavedDataUpdate.class);
    }
}

