/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.items.instances.ItemPartEngine;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class PartEngine
extends APart {
    public static String ELECTRICITY_FUEL = "electricity";
    public boolean backfired;
    public boolean badShift;
    public boolean running;
    public boolean magnetoOn;
    public boolean electricStarterEngaged;
    public boolean handStarterEngaged;
    public byte forwardsGears;
    public byte reverseGears;
    public byte currentGear;
    public int upshiftCountdown;
    public int downshiftCountdown;
    public int internalFuel;
    public double hours;
    public double rpm;
    public double temp;
    public double pressure;
    public float propellerGearboxRatio;
    public double fuelFlow;
    public double rocketFuelUsed;
    public PartEngine linkedEngine;
    private float currentMaxRPM;
    private float currentMaxSafeRPM;
    private float currentRevlimitRPM;
    private float currentRevlimitBounce;
    private float currentRevResistance;
    private float currentIdleRPM;
    private float currentStartRPM;
    private float currentStallRPM;
    private float currentStarterPower;
    private float currentFuelConsumption;
    private float currentHeatingCoefficient;
    private float currentCoolingCoefficient;
    private float currentSuperchargerFuelConsumption;
    private float currentSuperchargerEfficiency;
    private float currentGearRatio;
    private float currentForceShift;
    public float currentIsAutomatic;
    private float currentWearFactor;
    private float currentWinddownRate;
    private boolean autoStarterEngaged;
    private int starterLevel;
    private int shiftCooldown;
    private double lowestWheelVelocity;
    private double desiredWheelVelocity;
    private double engineAxialVelocity;
    private float wheelFriction;
    private double ambientTemp;
    private double coolingFactor;
    private double engineTargetRPM;
    private double engineRotation;
    private double prevEngineRotation;
    private double driveshaftRotation;
    private double prevDriveshaftRotation;
    private final List<PartGroundDevice> linkedWheels = new ArrayList<PartGroundDevice>();
    private final List<PartGroundDevice> drivenWheels = new ArrayList<PartGroundDevice>();
    private final List<PartPropeller> linkedPropellers = new ArrayList<PartPropeller>();
    private final Point3D engineAxisVector = new Point3D();
    private final Point3D engineForce = new Point3D();
    private double engineForceValue;
    public static final String MAGNETO_VARIABLE = "engine_magneto";
    public static final String ELECTRIC_STARTER_VARIABLE = "engine_starter";
    public static final String HAND_STARTER_VARIABLE = "engine_starter_hand";
    public static final String UP_SHIFT_VARIABLE = "engine_shift_up";
    public static final String DOWN_SHIFT_VARIABLE = "engine_shift_down";
    public static final String NEUTRAL_SHIFT_VARIABLE = "engine_shift_neutral";
    public static final String GEAR_SHIFT_VARIABLE = "engine_shift_request";
    public static final String GEAR_VARIABLE = "engine_gear";
    public static final String HOURS_VARIABLE = "hours";
    public static final float COLD_TEMP = 30.0f;
    public static final float OVERHEAT_TEMP_1 = 115.556f;
    public static final float OVERHEAT_TEMP_2 = 121.111f;
    public static final float FAILURE_TEMP = 132.222f;
    public static final float LOW_OIL_PRESSURE = 40.0f;
    public static final float MAX_SHIFT_SPEED = 0.35f;

    public PartEngine(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartEngine item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        if (data != null) {
            this.running = data.getBoolean("running");
            this.hours = data.getDouble(HOURS_VARIABLE);
            this.rpm = data.getDouble("rpm");
            this.temp = data.getDouble("temp");
            this.pressure = data.getDouble("pressure");
            this.rocketFuelUsed = data.getDouble("rocketFuelUsed");
        }
        for (float gear : ((JSONPart)this.definition).engine.gearRatios) {
            if (gear < 0.0f) {
                this.reverseGears = (byte)(this.reverseGears + 1);
                continue;
            }
            if (!(gear > 0.0f)) continue;
            this.forwardsGears = (byte)(this.forwardsGears + 1);
        }
        if ((double)((JSONPart)this.definition).engine.gearRatios.size() <= this.getVariable(GEAR_VARIABLE) + (double)this.reverseGears) {
            this.setVariable(GEAR_VARIABLE, this.currentGear + this.reverseGears - 1);
        }
        if (this.vehicleOn != null && !this.vehicleOn.fuelTank.getFluid().isEmpty()) {
            switch (((JSONPart)this.definition).engine.type) {
                case MAGIC: {
                    break;
                }
                case ELECTRIC: {
                    if (this.vehicleOn.fuelTank.getFluid().equals(ELECTRICITY_FUEL)) break;
                    this.vehicleOn.fuelTank.drain(this.vehicleOn.fuelTank.getFluid(), this.vehicleOn.fuelTank.getFluidLevel(), true);
                    break;
                }
                default: {
                    if (!ConfigSystem.settings.fuel.fuels.containsKey(((JSONPart)this.definition).engine.fuelType)) {
                        throw new IllegalArgumentException("Engine:" + ((JSONPart)this.definition).packID + ":" + ((JSONPart)this.definition).systemName + " wanted fuel configs for fuel of type:" + ((JSONPart)this.definition).engine.fuelType + ", but these do not exist in the config file.  Fuels currently in the file are:" + ConfigSystem.settings.fuel.fuels.keySet() + "If you are on a server, this means the server and client configs are not the same.  If this is a modpack, TELL THE AUTHOR IT IS BROKEN!");
                    }
                    if (ConfigSystem.settings.fuel.fuels.get(((JSONPart)this.definition).engine.fuelType).containsKey(this.vehicleOn.fuelTank.getFluid())) break;
                    this.vehicleOn.fuelTank.drain(this.vehicleOn.fuelTank.getFluid(), this.vehicleOn.fuelTank.getFluidLevel(), true);
                }
            }
        }
        if (this.vehicleOn != null && ((JSONVehicle)this.vehicleOn.definition).motorized.isAircraft) {
            this.setVariable(GEAR_VARIABLE, 1.0);
        }
    }

    @Override
    public void attack(Damage damage) {
        super.attack(damage);
        if (!damage.isWater) {
            if (((JSONPart)this.definition).engine.disableAutomaticStarter && damage.entityResponsible instanceof IWrapperPlayer && ((IWrapperPlayer)damage.entityResponsible).getHeldStack().isEmpty() && !this.masterEntity.allParts.contains(damage.entityResponsible.getEntityRiding())) {
                if (!this.magnetoOn) {
                    this.setVariable(MAGNETO_VARIABLE, 1.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle(this, MAGNETO_VARIABLE));
                }
                this.handStartEngine();
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.HS_ON));
                return;
            }
            if (this.vehicleOn == null || !this.vehicleOn.isCreative) {
                double hoursApplied = damage.amount * (Double)ConfigSystem.settings.general.engineHoursFactor.value;
                if (damage.isExplosion) {
                    hoursApplied *= 10.0;
                }
                this.hours += hoursApplied;
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, hoursApplied));
            }
        } else if (((JSONPart)this.definition).engine.type == JSONPart.EngineType.NORMAL) {
            this.stallEngine(PacketPartEngine.Signal.DROWN);
            InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.DROWN));
        }
    }

    @Override
    public void update() {
        super.update();
        this.backfired = false;
        this.badShift = false;
        this.magnetoOn = this.isVariableActive(MAGNETO_VARIABLE);
        this.electricStarterEngaged = this.isVariableActive(ELECTRIC_STARTER_VARIABLE);
        this.handStarterEngaged = this.isVariableActive(HAND_STARTER_VARIABLE);
        this.currentGear = (byte)this.getVariable(GEAR_VARIABLE);
        if (this.running && !this.magnetoOn) {
            this.running = false;
            if (((JSONPart)this.definition).engine.type == JSONPart.EngineType.NORMAL) {
                this.internalFuel = 200;
            }
        }
        this.fuelFlow = 0.0;
        if (this.upshiftCountdown > 0) {
            --this.upshiftCountdown;
        }
        if (this.downshiftCountdown > 0) {
            --this.downshiftCountdown;
        }
        if (this.vehicleOn != null) {
            if (this.linkedEngine != null) {
                if (!this.linkedEngine.position.isDistanceToCloserThan(this.position, 16.0)) {
                    this.linkedEngine.linkedEngine = null;
                    this.linkedEngine = null;
                    if (this.world.isClient()) {
                        for (IWrapperPlayer player : this.world.getPlayersWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                            player.displayChatMessage(LanguageSystem.INTERACT_JUMPERCABLE_LINKDROPPED, new Object[0]);
                        }
                    }
                } else if (this.vehicleOn.electricPower + 0.5 < this.linkedEngine.vehicleOn.electricPower) {
                    this.linkedEngine.vehicleOn.electricPower -= (double)0.005f;
                    this.vehicleOn.electricPower += (double)0.005f;
                } else if (this.vehicleOn.electricPower > this.linkedEngine.vehicleOn.electricPower + 0.5) {
                    this.vehicleOn.electricPower -= (double)0.005f;
                    this.linkedEngine.vehicleOn.electricPower += (double)0.005f;
                } else {
                    this.linkedEngine.linkedEngine = null;
                    this.linkedEngine = null;
                    if (this.world.isClient()) {
                        for (IWrapperPlayer player : this.world.getPlayersWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                            player.displayChatMessage(LanguageSystem.INTERACT_JUMPERCABLE_POWEREQUAL, new Object[0]);
                        }
                    }
                }
            }
            this.ambientTemp = (double)(25.0f * this.world.getTemperature(this.position) + 5.0f) * (Double)ConfigSystem.settings.general.engineBiomeTempFactor.value;
            this.coolingFactor = 0.001 * (double)this.currentCoolingCoefficient - (double)(this.currentSuperchargerEfficiency / 1000.0f) * (this.rpm / 2000.0) + this.vehicleOn.velocity / 1000.0 * (double)this.currentCoolingCoefficient;
            this.temp -= (this.temp - this.ambientTemp) * this.coolingFactor;
            if (this.electricStarterEngaged) {
                if (this.starterLevel == 0) {
                    if (this.vehicleOn.electricPower > 1.0) {
                        this.starterLevel += 4;
                    } else if (!this.world.isClient()) {
                        this.setVariable(ELECTRIC_STARTER_VARIABLE, 0.0);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle(this, ELECTRIC_STARTER_VARIABLE));
                    }
                }
                if (this.starterLevel > 0) {
                    if (!this.vehicleOn.isCreative) {
                        this.vehicleOn.electricUsage += (double)0.05f;
                    }
                    if (!this.vehicleOn.isCreative) {
                        this.fuelFlow += this.vehicleOn.fuelTank.drain(this.vehicleOn.fuelTank.getFluid(), (double)this.getTotalFuelConsumption() * (Double)ConfigSystem.settings.general.fuelUsageFactor.value, !this.world.isClient());
                    }
                }
                if (this.autoStarterEngaged && !this.world.isClient() && this.running) {
                    this.setVariable(ELECTRIC_STARTER_VARIABLE, 0.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle(this, ELECTRIC_STARTER_VARIABLE));
                }
            } else if (this.handStarterEngaged) {
                if (this.starterLevel == 0) {
                    this.setVariable(HAND_STARTER_VARIABLE, 0.0);
                }
            } else {
                this.starterLevel = 0;
                this.autoStarterEngaged = false;
            }
            if (this.starterLevel > 0) {
                --this.starterLevel;
                this.rpm = this.rpm < (double)(this.currentStartRPM * 2.0f) ? Math.min(this.rpm + (double)this.currentStarterPower, (double)(this.currentStartRPM * 2.0f)) : Math.max(this.rpm - (double)this.currentStarterPower, (double)(this.currentStartRPM * 2.0f));
            }
            if (!this.vehicleOn.isCreative && this.rpm > (double)this.currentMaxSafeRPM) {
                this.hours += (this.rpm - (double)this.currentMaxSafeRPM) / (double)this.currentMaxSafeRPM * this.getTotalWearFactor();
            }
            if (!this.world.isClient()) {
                if (this.isVariableActive(NEUTRAL_SHIFT_VARIABLE)) {
                    this.toggleVariable(NEUTRAL_SHIFT_VARIABLE);
                    this.shiftNeutral();
                }
                if (this.isVariableActive(UP_SHIFT_VARIABLE)) {
                    this.toggleVariable(UP_SHIFT_VARIABLE);
                    this.shiftUp();
                } else if (this.isVariableActive(DOWN_SHIFT_VARIABLE)) {
                    this.toggleVariable(DOWN_SHIFT_VARIABLE);
                    this.shiftDown();
                } else if (this.isVariableActive(GEAR_SHIFT_VARIABLE)) {
                    double shiftValue = this.getVariable(GEAR_SHIFT_VARIABLE);
                    if (shiftValue < 10.0) {
                        while ((double)this.currentGear < shiftValue && this.shiftUp()) {
                        }
                    } else if (shiftValue == 10.0) {
                        if (this.currentGear == 0) {
                            this.shiftDown();
                        }
                    } else if (shiftValue == 11.0) {
                        this.shiftNeutral();
                    }
                }
            }
            if (((JSONVehicle)this.vehicleOn.definition).motorized.isBlimp && !this.linkedPropellers.isEmpty()) {
                if (this.vehicleOn.reverseThrust && this.currentGear > 0) {
                    this.currentGear = (byte)-1;
                } else if (!this.vehicleOn.reverseThrust && this.currentGear < 0) {
                    this.currentGear = 1;
                }
            }
            this.drivenWheels.clear();
            for (PartGroundDevice wheel : this.linkedWheels) {
                if (wheel.isSpare || !wheel.isActive || !((JSONPart)wheel.definition).ground.isWheel && !((JSONPart)wheel.definition).ground.isTread) continue;
                this.drivenWheels.add(wheel);
                wheel.drivenLastTick = true;
            }
            if (this.running) {
                if (!this.vehicleOn.isCreative) {
                    this.hours += 0.001 * this.getTotalWearFactor();
                }
                if (!this.world.isClient()) {
                    if (!this.isActive) {
                        this.stallEngine(PacketPartEngine.Signal.INACTIVE);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.INACTIVE));
                    } else if (this.vehicleOn.outOfHealth) {
                        this.stallEngine(PacketPartEngine.Signal.DEAD_VEHICLE);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.DEAD_VEHICLE));
                    } else if (((Set)ConfigSystem.settings.general.engineDimensionWhitelist.value).isEmpty() ? ((Set)ConfigSystem.settings.general.engineDimensionBlacklist.value).contains(this.world.getName()) : !((Set)ConfigSystem.settings.general.engineDimensionWhitelist.value).contains(this.world.getName())) {
                        this.stallEngine(PacketPartEngine.Signal.INVALID_DIMENSION);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.INVALID_DIMENSION));
                    }
                }
                if (this.currentIsAutomatic != 0.0f && !this.world.isClient() && this.currentGear != 0) {
                    if (this.shiftCooldown == 0) {
                        if (this.currentGear > 0 ? this.currentGear < this.forwardsGears : -this.currentGear < this.reverseGears) {
                            double d = ((JSONPart)this.definition).engine.upShiftRPM != null ? (double)((JSONPart)this.definition).engine.upShiftRPM.get(this.currentGear + this.reverseGears).intValue() : (double)this.currentMaxSafeRPM * 0.9;
                            if (this.rpm > d * 0.5 * (1.0 + this.vehicleOn.throttle)) {
                                if (this.currentGear > 0) {
                                    this.shiftUp();
                                } else {
                                    this.shiftDown();
                                }
                            }
                        }
                        if (this.currentGear > 1 || this.currentGear < -1) {
                            double d = ((JSONPart)this.definition).engine.downShiftRPM != null ? (double)((JSONPart)this.definition).engine.downShiftRPM.get(this.currentGear + this.reverseGears).intValue() * 0.5 * (1.0 + this.vehicleOn.throttle) : (double)this.currentMaxSafeRPM * 0.9 * 0.25 * (1.0 + this.vehicleOn.throttle);
                            if (this.rpm < d) {
                                if (this.currentGear > 0) {
                                    this.shiftDown();
                                } else {
                                    this.shiftUp();
                                }
                            }
                        }
                    } else {
                        --this.shiftCooldown;
                    }
                }
                if (this.temp > (double)115.556f && !this.vehicleOn.isCreative) {
                    this.hours += 0.001 * (this.temp - (double)115.556f) * this.getTotalWearFactor();
                    if (this.temp > (double)132.222f && !this.world.isClient()) {
                        this.explodeEngine();
                    }
                }
            }
            switch (((JSONPart)this.definition).engine.type) {
                case NORMAL: {
                    if (this.running) {
                        this.vehicleOn.electricUsage -= 0.05 * this.rpm / (double)this.currentMaxRPM;
                        if (!this.vehicleOn.isCreative && !this.vehicleOn.fuelTank.getFluid().isEmpty()) {
                            this.fuelFlow += this.vehicleOn.fuelTank.drain(this.vehicleOn.fuelTank.getFluid(), (double)this.getTotalFuelConsumption() * (Double)ConfigSystem.settings.general.fuelUsageFactor.value / ConfigSystem.settings.fuel.fuels.get(((JSONPart)this.definition).engine.fuelType).get(this.vehicleOn.fuelTank.getFluid()) * this.rpm / (double)this.currentMaxRPM, !this.world.isClient());
                        }
                        this.temp += Math.max(0.0, (7.0 * this.rpm / (double)this.currentMaxRPM - this.temp / 60.0) / 20.0) * (double)this.currentHeatingCoefficient * (Double)ConfigSystem.settings.general.engineSpeedTempFactor.value;
                        this.pressure = Math.min(90.0 - this.temp / 10.0, this.pressure + this.rpm / (double)this.currentIdleRPM - 0.5 * (this.pressure / 40.0));
                        if (this.pressure < 40.0 && !this.vehicleOn.isCreative) {
                            this.temp += Math.max(0.0, 20.0 * this.rpm / (double)this.currentMaxRPM / 20.0);
                            this.hours += 0.01 * this.getTotalWearFactor();
                        }
                        if (this.hours >= 500.0 && !this.world.isClient() && Math.random() < this.hours / 3.0 / (500.0 + (10000.0 - this.hours)) * ((double)this.currentMaxSafeRPM / (this.rpm + (double)this.currentMaxSafeRPM / 1.5))) {
                            this.backfireEngine();
                            InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.BACKFIRE));
                        }
                        if (this.world.isClient()) break;
                        if (this.isInLiquid()) {
                            this.stallEngine(PacketPartEngine.Signal.DROWN);
                            InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.DROWN));
                            break;
                        }
                        if (!this.vehicleOn.isCreative && (Double)ConfigSystem.settings.general.fuelUsageFactor.value != 0.0 && this.vehicleOn.fuelTank.getFluidLevel() == 0.0) {
                            this.stallEngine(PacketPartEngine.Signal.FUEL_OUT);
                            InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.FUEL_OUT));
                            break;
                        }
                        if (!(this.rpm < (double)this.currentStallRPM)) break;
                        this.stallEngine(PacketPartEngine.Signal.TOO_SLOW);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.TOO_SLOW));
                        break;
                    }
                    if (this.internalFuel > 0) {
                        --this.internalFuel;
                        if (this.rpm < 500.0) {
                            this.internalFuel = 0;
                        }
                    }
                    if (!(this.rpm >= (double)this.currentStartRPM) || this.world.isClient() || this.vehicleOn.outOfHealth || !this.vehicleOn.isCreative && (Double)ConfigSystem.settings.general.fuelUsageFactor.value != 0.0 && !(this.vehicleOn.fuelTank.getFluidLevel() > 0.0) || this.isInLiquid() || !this.magnetoOn) break;
                    this.startEngine();
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.START));
                    break;
                }
                case ROCKET: {
                    if (this.running) {
                        this.rocketFuelUsed += (double)this.getTotalFuelConsumption();
                        if (!(this.rocketFuelUsed >= (double)((JSONPart)this.definition).engine.rocketFuel)) break;
                        this.running = false;
                        break;
                    }
                    if (!this.magnetoOn || !(this.rocketFuelUsed < (double)((JSONPart)this.definition).engine.rocketFuel)) break;
                    this.running = true;
                    break;
                }
                case ELECTRIC: {
                    if (this.running) {
                        this.vehicleOn.electricUsage -= 0.05 * this.rpm / (double)this.currentMaxRPM;
                        if (!this.vehicleOn.isCreative && !this.vehicleOn.fuelTank.getFluid().isEmpty()) {
                            this.fuelFlow += this.vehicleOn.fuelTank.drain(this.vehicleOn.fuelTank.getFluid(), (double)this.getTotalFuelConsumption() * (Double)ConfigSystem.settings.general.fuelUsageFactor.value * this.rpm / (double)this.currentMaxRPM, !this.world.isClient());
                        }
                        if (this.world.isClient() || this.vehicleOn.isCreative || (Double)ConfigSystem.settings.general.fuelUsageFactor.value == 0.0 || this.vehicleOn.fuelTank.getFluidLevel() != 0.0) break;
                        this.stallEngine(PacketPartEngine.Signal.FUEL_OUT);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.FUEL_OUT));
                        break;
                    }
                    if (this.world.isClient() || this.vehicleOn.outOfHealth || !this.isActive || !this.vehicleOn.isCreative && (Double)ConfigSystem.settings.general.fuelUsageFactor.value != 0.0 && !(this.vehicleOn.fuelTank.getFluidLevel() > 0.0) || !this.magnetoOn) break;
                    this.startEngine();
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.START));
                    break;
                }
                case MAGIC: {
                    if (this.running) {
                        this.vehicleOn.electricUsage -= 0.05 * this.rpm / (double)this.currentMaxRPM;
                        break;
                    }
                    if (this.world.isClient() || this.vehicleOn.outOfHealth || !this.isActive || !this.magnetoOn) break;
                    this.startEngine();
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.START));
                }
            }
            if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f && !this.drivenWheels.isEmpty()) {
                this.lowestWheelVelocity = 999.0;
                this.desiredWheelVelocity = -999.0;
                this.wheelFriction = 0.0f;
                this.engineTargetRPM = !this.electricStarterEngaged ? this.vehicleOn.throttle * (double)(this.currentMaxRPM - this.currentIdleRPM) / (1.0 + this.hours / 1500.0) + (double)this.currentIdleRPM : (double)this.currentStartRPM;
                for (PartGroundDevice wheel : this.drivenWheels) {
                    if (!this.vehicleOn.groundDeviceCollective.groundedGroundDevices.contains(wheel)) continue;
                    this.wheelFriction += wheel.currentMotiveFriction;
                    this.lowestWheelVelocity = Math.min(wheel.angularVelocity, this.lowestWheelVelocity);
                    this.desiredWheelVelocity = Math.max(wheel.getDesiredAngularVelocity(), this.desiredWheelVelocity);
                }
                if (this.currentGearRatio != 0.0f && this.starterLevel == 0) {
                    if (this.wheelFriction > 0.0f) {
                        double desiredRPM = this.lowestWheelVelocity * 1200.0 * (double)this.currentGearRatio * (double)this.vehicleOn.currentAxleRatio;
                        this.rpm += (desiredRPM - this.rpm) / (double)this.currentRevResistance;
                        if (this.rpm < (double)this.currentIdleRPM - (double)(this.currentIdleRPM - this.currentStallRPM) * 0.5 && this.running) {
                            this.rpm = (double)this.currentIdleRPM - (double)(this.currentIdleRPM - this.currentStallRPM) * 0.5;
                        }
                    } else {
                        for (PartGroundDevice wheel : this.drivenWheels) {
                            wheel.angularVelocity = this.rpm / (double)this.currentGearRatio / (double)this.vehicleOn.currentAxleRatio / 1200.0;
                        }
                    }
                }
            }
            this.propellerGearboxRatio = Math.signum(this.currentGearRatio) * (((JSONPart)this.definition).engine.propellerRatio != 0.0f ? ((JSONPart)this.definition).engine.propellerRatio : Math.abs(this.currentGearRatio));
            for (PartPropeller attachedPropeller : this.linkedPropellers) {
                if (attachedPropeller.ticksExisted == 0L || this.wheelFriction != 0.0f || this.currentGearRatio == 0.0f) continue;
                boolean isPropellerInLiquid = attachedPropeller.isInLiquid();
                double propellerForcePenalty = Math.max(0.0f, (float)(((JSONPart)attachedPropeller.definition).propeller.diameter - 75) / (50.0f * (this.currentFuelConsumption + this.currentSuperchargerFuelConsumption * this.currentSuperchargerEfficiency) - 15.0f));
                double propellerFeedback = -Math.abs(attachedPropeller.airstreamLinearVelocity - attachedPropeller.desiredLinearVelocity) * (isPropellerInLiquid ? 6.5 : 2.0);
                if (this.running) {
                    propellerFeedback -= propellerForcePenalty * 50.0;
                    this.engineTargetRPM = this.vehicleOn.throttle * (double)(this.currentMaxRPM - this.currentIdleRPM) / (1.0 + this.hours / 1500.0) + (double)this.currentIdleRPM;
                    double engineRPMDifference = this.engineTargetRPM - this.rpm;
                    if (this.rpm + engineRPMDifference / (double)this.currentRevResistance > (double)this.currentStallRPM && this.rpm + engineRPMDifference / (double)this.currentRevResistance + propellerFeedback < (double)this.currentStallRPM) {
                        this.rpm = this.currentStallRPM;
                        continue;
                    }
                    this.rpm += engineRPMDifference / (double)this.currentRevResistance + propellerFeedback;
                    continue;
                }
                if (this.electricStarterEngaged || this.handStarterEngaged) continue;
                this.rpm += (propellerFeedback - 1.0) * (double)Math.abs(this.propellerGearboxRatio);
                if (!(this.rpm < 0.0)) continue;
                this.rpm = 0.0;
            }
            if (this.wheelFriction == 0.0f && this.linkedPropellers.isEmpty() || this.currentGearRatio == 0.0f) {
                if (this.running) {
                    this.engineTargetRPM = this.rocketFuelUsed < (double)((JSONPart)this.definition).engine.rocketFuel ? (double)this.currentMaxRPM : this.vehicleOn.throttle * (double)(this.currentMaxRPM - this.currentIdleRPM) / (1.0 + this.hours / 1500.0) + (double)this.currentIdleRPM;
                    this.rpm += (this.engineTargetRPM - this.rpm) / (double)(this.currentRevResistance * 3.0f);
                    if (this.currentRevlimitRPM == -1.0f) {
                        if (this.rpm > (double)this.currentMaxSafeRPM) {
                            this.rpm -= Math.abs(this.engineTargetRPM - this.rpm) / 60.0;
                        }
                    } else if (this.rpm > (double)this.currentRevlimitRPM) {
                        this.rpm -= Math.abs(this.engineTargetRPM - this.rpm) / (double)this.currentRevlimitBounce;
                    }
                } else if (!this.electricStarterEngaged && !this.handStarterEngaged) {
                    this.rpm = Math.max(this.rpm - (double)this.currentWinddownRate, 0.0);
                }
            }
            if (((JSONPart)this.definition).engine.jetPowerFactor > 0.0f) {
                this.engineAxisVector.set(0.0, 0.0, 1.0).rotate(this.orientation);
                this.engineAxialVelocity = this.vehicleOn.motion.dotProduct(this.engineAxisVector, false);
                if (!this.world.isClient() && this.rpm >= 5000.0) {
                    this.boundingBox.widthRadius += 0.25;
                    this.boundingBox.heightRadius += 0.25;
                    this.boundingBox.depthRadius += 0.25;
                    this.boundingBox.globalCenter.add(this.vehicleOn.headingVector);
                    IWrapperEntity controller = this.vehicleOn.getController();
                    LanguageSystem.LanguageEntry language = controller != null ? LanguageSystem.DEATH_JETINTAKE_PLAYER : LanguageSystem.DEATH_JETINTAKE_NULL;
                    Damage jetIntake = new Damage((double)((JSONPart)this.definition).engine.jetPowerFactor * (Double)ConfigSystem.settings.damage.jetDamageFactor.value * this.rpm / 1000.0, this.boundingBox, this, controller, language);
                    this.world.attackEntities(jetIntake, null, false);
                    this.boundingBox.globalCenter.subtract(this.vehicleOn.headingVector);
                    this.boundingBox.globalCenter.subtract(this.vehicleOn.headingVector);
                    language = controller != null ? LanguageSystem.DEATH_JETEXHAUST_PLAYER : LanguageSystem.DEATH_JETEXHAUST_NULL;
                    Damage jetExhaust = new Damage((double)((JSONPart)this.definition).engine.jetPowerFactor * (Double)ConfigSystem.settings.damage.jetDamageFactor.value * this.rpm / 2000.0, this.boundingBox, this, controller, language).setFire();
                    this.world.attackEntities(jetExhaust, null, false);
                    this.boundingBox.globalCenter.add(this.vehicleOn.headingVector);
                    this.boundingBox.widthRadius -= 0.25;
                    this.boundingBox.heightRadius -= 0.25;
                    this.boundingBox.depthRadius -= 0.25;
                }
            }
            this.prevEngineRotation = this.engineRotation;
            this.engineRotation += 360.0 * this.rpm / 1200.0;
            if (this.engineRotation > 3600000.0) {
                this.engineRotation -= 3600000.0;
                this.prevEngineRotation -= 3600000.0;
            } else if (this.engineRotation < -3600000.0) {
                this.engineRotation += 3600000.0;
                this.prevEngineRotation += 3600000.0;
            }
            this.prevDriveshaftRotation = this.driveshaftRotation;
            double driveshaftDesiredSpeed = -999.0;
            for (PartGroundDevice wheel : this.drivenWheels) {
                driveshaftDesiredSpeed = Math.max(wheel.angularVelocity, driveshaftDesiredSpeed);
            }
            if (driveshaftDesiredSpeed != -999.0) {
                this.driveshaftRotation += 360.0 * driveshaftDesiredSpeed * this.vehicleOn.speedFactor;
            } else if (this.propellerGearboxRatio != 0.0f) {
                this.driveshaftRotation += 360.0 * this.rpm / 1200.0 / (double)this.propellerGearboxRatio;
            }
            if (this.driveshaftRotation > 3600000.0) {
                this.driveshaftRotation -= 3600000.0;
                this.prevDriveshaftRotation -= 3600000.0;
            } else if (this.driveshaftRotation < -3600000.0) {
                this.driveshaftRotation += 3600000.0;
                this.prevDriveshaftRotation += 3600000.0;
            }
        }
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        this.linkedWheels.clear();
        this.addLinkedPartsToList(this.linkedWheels, PartGroundDevice.class);
        ArrayList fakeWheels = new ArrayList();
        this.linkedWheels.forEach(wheel -> {
            if (wheel.fakePart != null) {
                fakeWheels.add(wheel.fakePart);
            }
        });
        this.linkedWheels.addAll(fakeWheels);
        this.linkedPropellers.clear();
        this.parts.forEach(part -> {
            if (part instanceof PartPropeller) {
                this.linkedPropellers.add((PartPropeller)part);
            }
        });
        this.addLinkedPartsToList(this.linkedPropellers, PartPropeller.class);
    }

    @Override
    protected void updateVariableModifiers() {
        this.currentMaxRPM = ((JSONPart)this.definition).engine.maxRPM;
        this.currentMaxSafeRPM = ((JSONPart)this.definition).engine.maxSafeRPM;
        this.currentRevlimitRPM = ((JSONPart)this.definition).engine.revlimitRPM;
        this.currentRevlimitBounce = ((JSONPart)this.definition).engine.revlimitBounce;
        this.currentRevResistance = ((JSONPart)this.definition).engine.revResistance;
        this.currentIdleRPM = ((JSONPart)this.definition).engine.idleRPM;
        this.currentStartRPM = ((JSONPart)this.definition).engine.startRPM;
        this.currentStallRPM = ((JSONPart)this.definition).engine.stallRPM;
        this.currentStarterPower = ((JSONPart)this.definition).engine.starterPower;
        this.currentFuelConsumption = ((JSONPart)this.definition).engine.fuelConsumption;
        this.currentHeatingCoefficient = ((JSONPart)this.definition).engine.heatingCoefficient;
        this.currentCoolingCoefficient = ((JSONPart)this.definition).engine.coolingCoefficient;
        this.currentSuperchargerFuelConsumption = ((JSONPart)this.definition).engine.superchargerFuelConsumption;
        this.currentSuperchargerEfficiency = ((JSONPart)this.definition).engine.superchargerEfficiency;
        this.currentGearRatio = ((JSONPart)this.definition).engine.gearRatios.get(this.currentGear + this.reverseGears).floatValue();
        this.currentForceShift = ((JSONPart)this.definition).engine.forceShift ? 1.0f : 0.0f;
        this.currentIsAutomatic = ((JSONPart)this.definition).engine.isAutomatic ? 1.0f : 0.0f;
        this.currentWearFactor = ((JSONPart)this.definition).engine.engineWearFactor;
        this.currentWinddownRate = ((JSONPart)this.definition).engine.engineWinddownRate;
        if (((JSONPart)this.definition).variableModifiers != null) {
            block42: for (JSONVariableModifier modifier : ((JSONPart)this.definition).variableModifiers) {
                switch (modifier.variable) {
                    case "maxRPM": {
                        this.currentMaxRPM = this.adjustVariable(modifier, this.currentMaxRPM);
                        continue block42;
                    }
                    case "maxSafeRPM": {
                        this.currentMaxSafeRPM = this.adjustVariable(modifier, this.currentMaxSafeRPM);
                        continue block42;
                    }
                    case "revlimitRPM": {
                        this.currentRevlimitRPM = this.adjustVariable(modifier, this.currentRevlimitRPM);
                        continue block42;
                    }
                    case "revlimitBounce": {
                        this.currentRevlimitBounce = this.adjustVariable(modifier, this.currentRevlimitBounce);
                        continue block42;
                    }
                    case "revResistance": {
                        this.currentRevResistance = this.adjustVariable(modifier, this.currentRevResistance);
                        continue block42;
                    }
                    case "idleRPM": {
                        this.currentIdleRPM = this.adjustVariable(modifier, this.currentIdleRPM);
                        continue block42;
                    }
                    case "startRPM": {
                        this.currentStartRPM = this.adjustVariable(modifier, this.currentStartRPM);
                        continue block42;
                    }
                    case "stallRPM": {
                        this.currentStallRPM = this.adjustVariable(modifier, this.currentStallRPM);
                        continue block42;
                    }
                    case "starterPower": {
                        this.currentStarterPower = this.adjustVariable(modifier, this.currentStarterPower);
                        continue block42;
                    }
                    case "fuelConsumption": {
                        this.currentFuelConsumption = this.adjustVariable(modifier, this.currentFuelConsumption);
                        continue block42;
                    }
                    case "heatingCoefficient": {
                        this.currentHeatingCoefficient = this.adjustVariable(modifier, this.currentHeatingCoefficient);
                        continue block42;
                    }
                    case "coolingCoefficient": {
                        this.currentCoolingCoefficient = this.adjustVariable(modifier, this.currentCoolingCoefficient);
                        continue block42;
                    }
                    case "superchargerFuelConsumption": {
                        this.currentSuperchargerFuelConsumption = this.adjustVariable(modifier, this.currentSuperchargerFuelConsumption);
                        continue block42;
                    }
                    case "superchargerEfficiency": {
                        this.currentSuperchargerEfficiency = this.adjustVariable(modifier, this.currentSuperchargerEfficiency);
                        continue block42;
                    }
                    case "currentGearRatio": {
                        this.currentGearRatio = this.adjustVariable(modifier, this.currentGearRatio);
                        continue block42;
                    }
                    case "forceShift": {
                        this.currentForceShift = this.adjustVariable(modifier, this.currentForceShift);
                        continue block42;
                    }
                    case "isAutomatic": {
                        this.currentIsAutomatic = this.adjustVariable(modifier, this.currentIsAutomatic);
                        continue block42;
                    }
                    case "engineWearFactor": {
                        this.currentWearFactor = this.adjustVariable(modifier, this.currentWearFactor);
                        continue block42;
                    }
                    case "engineWinddownRate": {
                        this.currentWinddownRate = this.adjustVariable(modifier, this.currentWinddownRate);
                        continue block42;
                    }
                }
                this.setVariable(modifier.variable, this.adjustVariable(modifier, (float)this.getVariable(modifier.variable)));
            }
        }
    }

    @Override
    public boolean isInLiquid() {
        return this.world.isBlockLiquid(this.position.copy().add(0.0, this.placementDefinition.intakeOffset, 0.0));
    }

    @Override
    public void remove() {
        super.remove();
        this.running = false;
        if (this.vehicleOn != null) {
            for (PartGroundDevice wheel : this.drivenWheels) {
                wheel.skipAngularCalcs = false;
            }
        }
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "engine_isautomatic": {
                return this.currentIsAutomatic != 0.0f ? 1.0 : 0.0;
            }
            case "engine_rotation": {
                return this.getEngineRotation(partialTicks);
            }
            case "engine_sin": {
                return Math.sin(Math.toRadians(this.getEngineRotation(partialTicks)));
            }
            case "engine_cos": {
                return Math.cos(Math.toRadians(this.getEngineRotation(partialTicks)));
            }
            case "engine_driveshaft_rotation": {
                return this.getDriveshaftRotation(partialTicks);
            }
            case "engine_driveshaft_sin": {
                return Math.sin(Math.toRadians(this.getDriveshaftRotation(partialTicks)));
            }
            case "engine_driveshaft_cos": {
                return Math.cos(Math.toRadians(this.getDriveshaftRotation(partialTicks)));
            }
            case "engine_rpm": {
                return this.rpm;
            }
            case "engine_rpm_safe": {
                return this.currentMaxSafeRPM;
            }
            case "engine_rpm_max": {
                return this.currentMaxRPM;
            }
            case "engine_rpm_revlimit": {
                return this.currentRevlimitRPM;
            }
            case "engine_rpm_percent": {
                return this.rpm / (double)this.currentMaxRPM;
            }
            case "engine_rpm_percent_safe": {
                return this.rpm / (double)this.currentMaxSafeRPM;
            }
            case "engine_rpm_percent_revlimit": {
                return this.currentRevlimitRPM != -1.0f ? this.rpm / (double)this.currentRevlimitRPM : this.rpm / (double)this.currentMaxSafeRPM;
            }
            case "engine_rpm_target": {
                return this.engineTargetRPM;
            }
            case "engine_rpm_idle": {
                return this.currentIdleRPM;
            }
            case "engine_rpm_start": {
                return this.currentStartRPM;
            }
            case "engine_rpm_stall": {
                return this.currentStallRPM;
            }
            case "engine_starter_power": {
                return this.currentStarterPower;
            }
            case "engine_fuel_consumption": {
                return this.currentFuelConsumption;
            }
            case "engine_supercharger_fuel_consumption": {
                return this.currentSuperchargerFuelConsumption;
            }
            case "engine_supercharger_efficiency": {
                return this.currentSuperchargerEfficiency;
            }
            case "engine_fuel_flow": {
                return this.fuelFlow * 20.0 * 60.0 / 1000.0;
            }
            case "engine_fuel_remaining": {
                return ((double)((JSONPart)this.definition).engine.rocketFuel - this.rocketFuelUsed) / (double)((JSONPart)this.definition).engine.rocketFuel;
            }
            case "engine_temp": {
                return this.temp;
            }
            case "engine_temp_ambient": {
                return this.ambientTemp;
            }
            case "engine_pressure": {
                return this.pressure;
            }
            case "engine_gear": {
                return this.currentGear;
            }
            case "engine_gearshift": {
                return this.getGearshiftRotation();
            }
            case "engine_gearshift_hvertical": {
                return this.getGearshiftPosition_Vertical();
            }
            case "engine_gearshift_hhorizontal": {
                return this.getGearshiftPosition_Horizontal();
            }
            case "engine_clutch_upshift": {
                return this.upshiftCountdown > 0 ? 1.0 : 0.0;
            }
            case "engine_clutch_downshift": {
                return this.downshiftCountdown > 0 ? 1.0 : 0.0;
            }
            case "engine_badshift": {
                return this.badShift ? 1.0 : 0.0;
            }
            case "engine_reversed": {
                return this.currentGear < 0 ? 1.0 : 0.0;
            }
            case "engine_running": {
                return this.running ? 1.0 : 0.0;
            }
            case "engine_powered": {
                return this.running || this.internalFuel > 0 ? 1.0 : 0.0;
            }
            case "engine_backfired": {
                return this.backfired ? 1.0 : 0.0;
            }
            case "engine_jumper_cable": {
                return this.linkedEngine != null ? 1.0 : 0.0;
            }
            case "engine_hours": {
                return this.hours;
            }
        }
        if (variable.startsWith("engine_sin_")) {
            int offset = Integer.parseInt(variable.substring("engine_sin_".length()));
            return Math.sin(Math.toRadians(this.getEngineRotation(partialTicks) + (double)offset));
        }
        if (variable.startsWith("engine_cos_")) {
            int offset = Integer.parseInt(variable.substring("engine_cos_".length()));
            return Math.cos(Math.toRadians(this.getEngineRotation(partialTicks) + (double)offset));
        }
        if (variable.startsWith("engine_driveshaft_sin_")) {
            int offset = Integer.parseInt(variable.substring("engine_driveshaft_sin_".length()));
            return Math.sin(Math.toRadians(this.getDriveshaftRotation(partialTicks) + (double)offset));
        }
        if (variable.startsWith("engine_driveshaft_cos_")) {
            int offset = Integer.parseInt(variable.substring("engine_driveshaft_cos_".length()));
            return Math.cos(Math.toRadians(this.getDriveshaftRotation(partialTicks) + (double)offset));
        }
        if (variable.startsWith("engine_piston_")) {
            double shaftRotation;
            double sector;
            int camMultiplier = 1;
            if (variable.endsWith("_crank")) {
                variable = variable.substring(0, variable.length() - "_crank".length());
            }
            if (variable.endsWith("_cam")) {
                camMultiplier = 2;
                variable = variable.substring(0, variable.length() - "_cam".length());
            }
            String[] parsedVariable = variable.substring("engine_piston_".length()).split("_");
            int pistonNumber = Integer.parseInt(parsedVariable[0]);
            int totalPistons = Integer.parseInt(parsedVariable[1]);
            int offset = 0;
            if (parsedVariable.length >= 3) {
                offset = camMultiplier * Integer.parseInt(parsedVariable[2]);
            }
            if (pistonNumber > totalPistons || totalPistons == 1) {
                pistonNumber = 1;
                totalPistons = 2;
            }
            return 0.0 + (sector = 360.0 * (double)camMultiplier / (double)totalPistons) * (double)(pistonNumber - 1) <= (shaftRotation = (double)(Math.floorMod(Math.round(10.0 * ((double)offset + this.getEngineRotation(partialTicks))), Math.round(3600.0 * (double)camMultiplier)) / 10L)) && shaftRotation < sector + sector * (double)(pistonNumber - 1) ? 1.0 : 0.0;
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    public void startEngine() {
        this.running = true;
        if (((JSONPart)this.definition).engine.type == JSONPart.EngineType.NORMAL) {
            this.pressure = 60.0;
        }
    }

    public void handStartEngine() {
        this.setVariable(HAND_STARTER_VARIABLE, 1.0);
        this.starterLevel += 4;
    }

    public void autoStartEngine() {
        if (!this.running && (this.vehicleOn.isCreative || (Double)ConfigSystem.settings.general.fuelUsageFactor.value == 0.0 || this.vehicleOn.fuelTank.getFluidLevel() > 0.0)) {
            this.setVariable(MAGNETO_VARIABLE, 1.0);
            if (((JSONPart)this.definition).engine.type == JSONPart.EngineType.NORMAL) {
                this.autoStarterEngaged = true;
                this.setVariable(ELECTRIC_STARTER_VARIABLE, 1.0);
            }
        }
    }

    public void stallEngine(PacketPartEngine.Signal signal) {
        this.running = false;
        if (this.world.isClient() && signal != PacketPartEngine.Signal.DROWN && signal != PacketPartEngine.Signal.INVALID_DIMENSION && ((JSONPart)this.definition).engine.type != JSONPart.EngineType.ELECTRIC) {
            this.internalFuel = 100;
        }
    }

    public void backfireEngine() {
        this.backfired = true;
        this.rpm -= this.currentMaxRPM < 15000.0f ? (double)Math.round(0.05 * this.rpm + (this.hours * 0.05 - 25.0)) : (double)Math.round(0.1 * this.rpm + (this.hours * 0.1 - 50.0));
    }

    public void badShiftEngine() {
        this.badShift = true;
    }

    protected void explodeEngine() {
        if (((Boolean)ConfigSystem.settings.damage.explosions.value).booleanValue()) {
            this.world.spawnExplosion(this.position, 1.0, true);
        } else {
            this.world.spawnExplosion(this.position, 0.0, false);
        }
        this.remove();
    }

    public float getGearshiftRotation() {
        return this.currentIsAutomatic != 0.0f ? (float)Math.min(1, this.currentGear) * 15.0f : (float)(this.currentGear * 5);
    }

    public float getGearshiftPosition_Vertical() {
        if (this.currentGear < 0) {
            return ((JSONPart)this.definition).engine.gearRatios.size() % 2 == 0 ? 15.0f : -15.0f;
        }
        if (this.currentGear == 0) {
            return 0.0f;
        }
        return this.currentGear % 2 == 0 ? -15.0f : 15.0f;
    }

    public float getGearshiftPosition_Horizontal() {
        float columnAngleDelta;
        int columns = ((JSONPart)this.definition).engine.gearRatios.size() / 2;
        int firstColumnAngle = columns / 2 * -5;
        float f = columnAngleDelta = columns != 1 ? (float)(-firstColumnAngle * 2 / (columns - 1)) : 0.0f;
        if (this.currentGear < 0) {
            return -firstColumnAngle;
        }
        if (this.currentGear == 0) {
            return 0.0f;
        }
        return (float)firstColumnAngle + (float)((this.currentGear - 1) / 2) * columnAngleDelta;
    }

    public boolean shiftUp() {
        boolean doShift = false;
        if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f) {
            byte nextGear;
            if (this.currentGear == this.forwardsGears) {
                return false;
            }
            if (this.currentGear == 0) {
                nextGear = 1;
                doShift = this.world.isClient() || this.vehicleOn.axialVelocity < (double)0.35f || this.wheelFriction == 0.0f || !this.vehicleOn.goingInReverse || this.currentForceShift != 0.0f;
            } else {
                nextGear = (byte)(this.currentGear + 1);
                doShift = true;
            }
            if (doShift) {
                this.currentGear = nextGear;
                this.setVariable(GEAR_VARIABLE, this.currentGear);
                this.shiftCooldown = ((JSONPart)this.definition).engine.shiftSpeed;
                this.upshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
                if (!this.world.isClient()) {
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.SHIFT_UP));
                }
            } else {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.BAD_SHIFT));
            }
        }
        return doShift;
    }

    public boolean shiftDown() {
        boolean doShift = false;
        if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f) {
            int nextGear;
            if (this.currentGear < 0 && -this.currentGear == this.reverseGears) {
                return false;
            }
            if (this.currentGear == 0) {
                nextGear = -1;
                doShift = this.world.isClient() || this.vehicleOn.axialVelocity < (double)0.35f || this.wheelFriction == 0.0f || this.vehicleOn.goingInReverse || this.currentForceShift != 0.0f;
            } else {
                nextGear = (byte)(this.currentGear - 1);
                doShift = true;
            }
            if (doShift) {
                this.currentGear = (byte)nextGear;
                this.setVariable(GEAR_VARIABLE, this.currentGear);
                this.shiftCooldown = ((JSONPart)this.definition).engine.shiftSpeed;
                this.downshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
                if (!this.world.isClient()) {
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.SHIFT_DOWN));
                }
            } else {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.BAD_SHIFT));
            }
        }
        return doShift;
    }

    public void shiftNeutral() {
        if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f && this.currentGear != 0) {
            if (this.currentGear > 0) {
                this.downshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
            } else {
                this.upshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
            }
            this.shiftCooldown = ((JSONPart)this.definition).engine.shiftSpeed;
            this.currentGear = 0;
            this.setVariable(GEAR_VARIABLE, this.currentGear);
            if (!this.world.isClient()) {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.SHIFT_NEUTRAL));
            }
        }
    }

    public float getTotalFuelConsumption() {
        return this.currentFuelConsumption + this.currentSuperchargerFuelConsumption;
    }

    public double getTotalWearFactor() {
        if (this.currentSuperchargerEfficiency > 1.0f) {
            return (double)(this.currentWearFactor * this.currentSuperchargerEfficiency) * (Double)ConfigSystem.settings.general.engineHoursFactor.value;
        }
        return (double)this.currentWearFactor * (Double)ConfigSystem.settings.general.engineHoursFactor.value;
    }

    public double getEngineRotation(float partialTicks) {
        return partialTicks != 0.0f ? this.prevEngineRotation + (this.engineRotation - this.prevEngineRotation) * (double)partialTicks : this.engineRotation;
    }

    public double getDriveshaftRotation(float partialTicks) {
        return partialTicks != 0.0f ? this.prevDriveshaftRotation + (this.driveshaftRotation - this.prevDriveshaftRotation) * (double)partialTicks : this.driveshaftRotation;
    }

    public double addToForceOutput(Point3D force, Point3D torque) {
        this.engineForce.set(0.0, 0.0, 0.0);
        this.engineForceValue = 0.0;
        if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f && this.wheelFriction != 0.0f) {
            double wheelForce;
            if (this.running || this.electricStarterEngaged) {
                wheelForce = this.rpm > (double)this.currentRevlimitRPM && this.currentRevlimitRPM != -1.0f ? -this.rpm / (double)this.currentMaxRPM * (double)Math.signum(this.currentGear) * 60.0 : (this.engineTargetRPM - this.rpm) / (double)this.currentMaxRPM * (double)this.currentGearRatio * (double)this.vehicleOn.currentAxleRatio * (double)(this.currentFuelConsumption + this.currentSuperchargerFuelConsumption * this.currentSuperchargerEfficiency) * (double)0.6f * 30.0;
                if (wheelForce != 0.0) {
                    if (Math.abs(wheelForce / 300.0) > (double)this.wheelFriction || Math.abs(this.lowestWheelVelocity) - Math.abs(this.desiredWheelVelocity) > 0.1 && Math.abs(this.lowestWheelVelocity) - Math.abs(this.desiredWheelVelocity) < Math.abs(wheelForce / 300.0)) {
                        wheelForce *= this.vehicleOn.currentMass / 100000.0 * (double)this.wheelFriction / Math.abs(wheelForce / 300.0);
                        for (PartGroundDevice wheel : this.drivenWheels) {
                            wheel.angularVelocity = wheelForce >= 0.0 ? Math.min(this.engineTargetRPM / 1200.0 / (double)this.currentGearRatio / (double)this.vehicleOn.currentAxleRatio, wheel.angularVelocity + 0.01) : Math.max(this.engineTargetRPM / 1200.0 / (double)this.currentGearRatio / (double)this.vehicleOn.currentAxleRatio, wheel.angularVelocity - 0.01);
                            wheel.skipAngularCalcs = true;
                        }
                    } else {
                        for (PartGroundDevice wheel : this.drivenWheels) {
                            wheel.skipAngularCalcs = false;
                            if (this.vehicleOn.groundDeviceCollective.groundedGroundDevices.contains(wheel)) continue;
                            wheel.angularVelocity = this.lowestWheelVelocity;
                        }
                    }
                } else if (this.currentGearRatio == 0.0f) {
                    for (PartGroundDevice wheel : this.drivenWheels) {
                        wheel.skipAngularCalcs = false;
                    }
                }
                if ((wheelForce < 0.0 && this.currentGearRatio > 0.0f || wheelForce > 0.0 && this.currentGearRatio < 0.0f) && this.vehicleOn.velocity < 0.25) {
                    wheelForce = 0.0;
                }
            } else {
                wheelForce = -this.rpm / (double)this.currentMaxRPM * (double)Math.signum(this.currentGear) * 30.0;
            }
            this.engineForceValue += wheelForce;
            this.engineForce.set(0.0, 0.0, wheelForce).rotate(this.vehicleOn.orientation);
            force.add(this.engineForce);
        }
        if (((JSONPart)this.definition).engine.jetPowerFactor > 0.0f && this.running) {
            double safeRPMFactor = this.rpm / (double)this.currentMaxSafeRPM;
            double coreContribution = Math.max(10.0 * this.vehicleOn.airDensity * (double)this.currentFuelConsumption * safeRPMFactor - (double)((JSONPart)this.definition).engine.bypassRatio, 0.0);
            double fanVelocityFactor = (6.35 * this.rpm / 60.0 / 20.0 - this.engineAxialVelocity) / 200.0;
            double fanContribution = 10.0 * this.vehicleOn.airDensity * safeRPMFactor * fanVelocityFactor * (double)((JSONPart)this.definition).engine.bypassRatio;
            double thrust = (this.vehicleOn.reverseThrust ? -(coreContribution + fanContribution) : coreContribution + fanContribution) * (double)((JSONPart)this.definition).engine.jetPowerFactor;
            this.engineForceValue += thrust;
            this.engineForce.set(this.engineAxisVector).scale(thrust);
            force.add(this.engineForce);
            this.engineForce.reOrigin(this.vehicleOn.orientation);
            torque.add(this.localOffset.crossProduct(this.engineForce));
        }
        return this.engineForceValue;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setBoolean("running", this.running);
        data.setDouble(HOURS_VARIABLE, this.hours);
        data.setDouble("rpm", this.rpm);
        data.setDouble("temp", this.temp);
        data.setDouble("pressure", this.pressure);
        data.setDouble("rocketFuelUsed", this.rocketFuelUsed);
        return data;
    }
}

