/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityG_Towable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

abstract class AEntityVehicleC_Colliding
extends AEntityG_Towable<JSONVehicle> {
    public double currentMass;
    public double axialVelocity;
    public final Point3D headingVector = new Point3D();
    public final double speedFactor;

    public AEntityVehicleC_Colliding(AWrapperWorld world, IWrapperPlayer placingPlayer, ItemVehicle item, IWrapperNBT data) {
        super(world, placingPlayer, item, data);
        this.speedFactor = (((JSONVehicle)this.definition).motorized.isAircraft ? (Double)ConfigSystem.settings.general.aircraftSpeedFactor.value : (Double)ConfigSystem.settings.general.carSpeedFactor.value) * (Double)((Map)ConfigSystem.settings.general.packSpeedFactors.value).get(((JSONVehicle)this.definition).packID);
        double vehicleScale = (Double)((Map)ConfigSystem.settings.general.packVehicleScales.value).get(((JSONVehicle)this.definition).packID);
        this.scale.set(vehicleScale, vehicleScale, vehicleScale);
    }

    @Override
    public void update() {
        super.update();
        this.world.beginProfiling("VehicleC_Level", true);
        this.world.beginProfiling("SetVectors", true);
        this.headingVector.set(0.0, 0.0, 1.0);
        this.headingVector.rotate(this.orientation);
        this.axialVelocity = Math.abs(this.motion.dotProduct(this.headingVector, false));
        this.world.beginProfiling("SetMass", false);
        this.currentMass = this.getMass();
        if (this.velocity > 0.5 && this.ticksExisted % 20L == 0L) {
            this.world.beginProfiling("CloseDoors", false);
            this.variables.keySet().removeIf(s -> s.startsWith("door"));
        }
        this.world.endProfiling();
        this.world.endProfiling();
    }

    @Override
    public void destroy(BoundingBox box) {
        ArrayList<IWrapperItemStack> drops = new ArrayList<IWrapperItemStack>();
        IWrapperEntity controller = this.getController();
        Damage controllerCrashDamage = new Damage((Double)ConfigSystem.settings.damage.crashDamageFactor.value * this.velocity * 20.0, null, this, null, LanguageSystem.DEATH_CRASH_NULL);
        LanguageSystem.LanguageEntry language = controller != null ? LanguageSystem.DEATH_CRASH_PLAYER : LanguageSystem.DEATH_CRASH_NULL;
        Damage passengerCrashDamage = new Damage((Double)ConfigSystem.settings.damage.crashDamageFactor.value * this.velocity * 20.0, null, this, controller, language);
        for (APart part : this.allParts) {
            if (part.rider == null) continue;
            if (part.rider == controller) {
                part.rider.attack(controllerCrashDamage);
                continue;
            }
            part.rider.attack(passengerCrashDamage);
        }
        for (APart part : this.parts) {
            if (part.isPermanent) continue;
            drops.add(part.getStack());
        }
        super.destroy(box);
        drops.forEach(stack -> this.world.spawnItemStack((IWrapperItemStack)stack, box.globalCenter));
    }

    @Override
    public double getMass() {
        return super.getMass() + (double)((JSONVehicle)this.definition).motorized.emptyMass;
    }

    @Override
    public int getWorldLightValue() {
        this.position.y += 1.0;
        int higherLight = InterfaceManager.renderingInterface.getLightingAtPosition(this.position);
        this.position.y -= 1.0;
        return higherLight;
    }
}

