/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;

public abstract class AEntityC_Renderable
extends AEntityB_Existing {
    private static final Point3D interpolatedPositionHolder = new Point3D();
    private static final RotationMatrix interpolatedOrientationHolder = new RotationMatrix();
    private static final Point3D interpolatedScaleHolder = new Point3D();
    private static final TransformationMatrix translatedMatrix = new TransformationMatrix();
    private static final TransformationMatrix rotatedMatrix = new TransformationMatrix();
    public final Point3D scale = new Point3D(1.0, 1.0, 1.0);
    public final Point3D prevScale = new Point3D(1.0, 1.0, 1.0);
    public int worldLightValue;

    public AEntityC_Renderable(AWrapperWorld world, IWrapperPlayer placingPlayer, IWrapperNBT data) {
        super(world, placingPlayer, data);
    }

    public AEntityC_Renderable(AWrapperWorld world, Point3D position, Point3D motion, Point3D angles) {
        super(world, position, motion, angles);
    }

    @Override
    public void update() {
        super.update();
        this.prevScale.set(this.scale);
        if (this.world.isClient()) {
            this.worldLightValue = this.getWorldLightValue();
        }
    }

    public int getWorldLightValue() {
        return InterfaceManager.renderingInterface.getLightingAtPosition(this.position);
    }

    public final void render(boolean blendingEnabled, float partialTicks) {
        if (!this.disableRendering()) {
            this.world.beginProfiling("RenderSetup", true);
            if (this.requiresDeltaUpdates()) {
                this.getInterpolatedOrientation(interpolatedOrientationHolder, partialTicks);
            } else {
                interpolatedOrientationHolder.set(this.orientation);
            }
            translatedMatrix.resetTransforms();
            if (this.requiresDeltaUpdates()) {
                interpolatedPositionHolder.set(this.prevPosition).interpolate(this.position, partialTicks).subtract(this.position);
                translatedMatrix.setTranslation(interpolatedPositionHolder);
            }
            rotatedMatrix.set(translatedMatrix);
            rotatedMatrix.applyRotation(interpolatedOrientationHolder);
            interpolatedScaleHolder.set(this.scale).subtract(this.prevScale).scale(partialTicks).add(this.prevScale);
            rotatedMatrix.applyScaling(interpolatedScaleHolder);
            this.world.endProfiling();
            this.renderModel(rotatedMatrix, blendingEnabled, partialTicks);
            if (blendingEnabled) {
                this.renderHolographicBoxes(translatedMatrix);
            }
            if (!blendingEnabled && InterfaceManager.renderingInterface.shouldRenderBoundingBoxes()) {
                this.world.beginProfiling("BoundingBoxes", true);
                this.renderBoundingBoxes(translatedMatrix);
                this.world.endProfiling();
            }
            this.world.beginProfiling("Sounds", true);
            this.updateSounds(partialTicks);
            this.world.endProfiling();
        }
    }

    protected boolean disableRendering() {
        return this.ticksExisted == 0L;
    }

    protected abstract void renderModel(TransformationMatrix var1, boolean var2, float var3);

    protected void renderHolographicBoxes(TransformationMatrix transform) {
    }

    public void renderBoundingBoxes(TransformationMatrix transform) {
        this.boundingBox.renderWireframe(this, transform, null, null);
    }
}

