/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;

public class RoadLaneConnection {
    public final Point3D tileLocation;
    public final int laneNumber;
    public final int curveNumber;
    public final double curveNetAngle;
    public final boolean connectedToStart;

    public RoadLaneConnection(RoadLane lane, BezierCurve curve, boolean connectedToStart) {
        this.tileLocation = lane.road.position;
        this.laneNumber = lane.laneNumber;
        this.curveNumber = lane.curves.indexOf(curve);
        Point3D vector = new Point3D(0.0, 0.0, 1.0);
        RotationMatrix helperRotator = new RotationMatrix();
        if (connectedToStart) {
            helperRotator.set(curve.endRotation).rotateY(180.0);
            vector.rotate(helperRotator).reOrigin(curve.startRotation);
        } else {
            helperRotator.set(curve.startRotation).rotateY(180.0);
            vector.rotate(helperRotator).reOrigin(curve.endRotation);
        }
        this.curveNetAngle = vector.getAngles((boolean)false).y;
        this.connectedToStart = connectedToStart;
    }

    public RoadLaneConnection(Point3D tileLocation, int laneNumber, int curveNumber, double curveNetAngle, boolean connectedToStart) {
        this.tileLocation = tileLocation;
        this.laneNumber = laneNumber;
        this.curveNumber = curveNumber;
        this.curveNetAngle = curveNetAngle;
        this.connectedToStart = connectedToStart;
    }

    public RoadLaneConnection(IWrapperNBT data) {
        this.tileLocation = data.getPoint3dCompact("tileLocation");
        this.laneNumber = data.getInteger("laneNumber");
        this.curveNumber = data.getInteger("curveNumber");
        this.curveNetAngle = (float)data.getDouble("curveNetAngle");
        this.connectedToStart = data.getBoolean("connectedToStart");
    }

    public void save(IWrapperNBT data) {
        data.setPoint3dCompact("tileLocation", this.tileLocation);
        data.setInteger("laneNumber", this.laneNumber);
        data.setInteger("curveNumber", this.curveNumber);
        data.setDouble("curveNetAngle", this.curveNetAngle);
        data.setBoolean("connectedToStart", this.connectedToStart);
    }
}

