/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;

public class TransformationMatrix
extends RotationMatrix {
    public double m03;
    public double m13;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public TransformationMatrix() {
        this.resetTransforms();
    }

    public TransformationMatrix(TransformationMatrix other) {
        this();
        this.set(other);
    }

    public TransformationMatrix set(TransformationMatrix other) {
        this.m00 = other.m00;
        this.m01 = other.m01;
        this.m02 = other.m02;
        this.m03 = other.m03;
        this.m10 = other.m10;
        this.m11 = other.m11;
        this.m12 = other.m12;
        this.m13 = other.m13;
        this.m20 = other.m20;
        this.m21 = other.m21;
        this.m22 = other.m22;
        this.m23 = other.m23;
        this.m30 = other.m30;
        this.m31 = other.m31;
        this.m32 = other.m32;
        this.m33 = other.m33;
        return this;
    }

    public TransformationMatrix multiply(TransformationMatrix other) {
        double t00 = this.m00 * other.m00 + this.m01 * other.m10 + this.m02 * other.m20 + this.m03 * other.m30;
        double t01 = this.m00 * other.m01 + this.m01 * other.m11 + this.m02 * other.m21 + this.m03 * other.m31;
        double t02 = this.m00 * other.m02 + this.m01 * other.m12 + this.m02 * other.m22 + this.m03 * other.m32;
        double t03 = this.m00 * other.m03 + this.m01 * other.m13 + this.m02 * other.m23 + this.m03 * other.m33;
        double t10 = this.m10 * other.m00 + this.m11 * other.m10 + this.m12 * other.m20 + this.m13 * other.m30;
        double t11 = this.m10 * other.m01 + this.m11 * other.m11 + this.m12 * other.m21 + this.m13 * other.m31;
        double t12 = this.m10 * other.m02 + this.m11 * other.m12 + this.m12 * other.m22 + this.m13 * other.m32;
        double t13 = this.m10 * other.m03 + this.m11 * other.m13 + this.m12 * other.m23 + this.m13 * other.m33;
        double t20 = this.m20 * other.m00 + this.m21 * other.m10 + this.m22 * other.m20 + this.m23 * other.m30;
        double t21 = this.m20 * other.m01 + this.m21 * other.m11 + this.m22 * other.m21 + this.m23 * other.m31;
        double t22 = this.m20 * other.m02 + this.m21 * other.m12 + this.m22 * other.m22 + this.m23 * other.m32;
        double t23 = this.m20 * other.m03 + this.m21 * other.m13 + this.m22 * other.m23 + this.m23 * other.m33;
        double t30 = this.m30 * other.m00 + this.m31 * other.m10 + this.m32 * other.m20 + this.m33 * other.m30;
        double t31 = this.m30 * other.m01 + this.m31 * other.m11 + this.m32 * other.m21 + this.m33 * other.m31;
        double t32 = this.m30 * other.m02 + this.m31 * other.m12 + this.m32 * other.m22 + this.m33 * other.m32;
        double t33 = this.m30 * other.m03 + this.m31 * other.m13 + this.m32 * other.m23 + this.m33 * other.m33;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m03 = t03;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m13 = t13;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
        this.m23 = t23;
        this.m30 = t30;
        this.m31 = t31;
        this.m32 = t32;
        this.m33 = t33;
        return this;
    }

    public TransformationMatrix resetTransforms() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
        return this;
    }

    public TransformationMatrix applyTranslation(double x, double y, double z) {
        this.m03 += this.m00 * x + this.m01 * y + this.m02 * z;
        this.m13 += this.m10 * x + this.m11 * y + this.m12 * z;
        this.m23 += this.m20 * x + this.m21 * y + this.m22 * z;
        return this;
    }

    public TransformationMatrix applyTranslation(Point3D translation) {
        this.applyTranslation(translation.x, translation.y, translation.z);
        return this;
    }

    public TransformationMatrix applyInvertedTranslation(Point3D translation) {
        this.applyTranslation(-translation.x, -translation.y, -translation.z);
        return this;
    }

    public TransformationMatrix setTranslation(double x, double y, double z) {
        this.m03 = x;
        this.m13 = y;
        this.m23 = z;
        return this;
    }

    public TransformationMatrix setTranslation(Point3D translation) {
        this.m03 = translation.x;
        this.m13 = translation.y;
        this.m23 = translation.z;
        return this;
    }

    public TransformationMatrix applyRotation(RotationMatrix rotation) {
        this.multiply(rotation);
        return this;
    }

    public TransformationMatrix setRotation(RotationMatrix rotation) {
        this.set(rotation);
        return this;
    }

    public TransformationMatrix applyScaling(double x, double y, double z) {
        this.m00 *= x;
        this.m01 *= y;
        this.m02 *= z;
        this.m10 *= x;
        this.m11 *= y;
        this.m12 *= z;
        this.m20 *= x;
        this.m21 *= y;
        this.m22 *= z;
        this.m30 *= x;
        this.m31 *= y;
        this.m32 *= z;
        return this;
    }

    public TransformationMatrix applyScaling(Point3D scaling) {
        return this.applyScaling(scaling.x, scaling.y, scaling.z);
    }

    public Point3D transform(Point3D point) {
        double tx = this.m00 * point.x + this.m01 * point.y + this.m02 * point.z + this.m03;
        double ty = this.m10 * point.x + this.m11 * point.y + this.m12 * point.z + this.m13;
        point.z = this.m20 * point.x + this.m21 * point.y + this.m22 * point.z + this.m23;
        point.x = tx;
        point.y = ty;
        return point;
    }
}

