/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;

public class Point3D {
    public double x;
    public double y;
    public double z;

    public Point3D() {
        this(0.0, 0.0, 0.0);
    }

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object object) {
        if (object instanceof Point3D) {
            Point3D otherPoint = (Point3D)object;
            return (float)this.x == (float)otherPoint.x && (float)this.y == (float)otherPoint.y && (float)this.z == (float)otherPoint.z;
        }
        return false;
    }

    public String toString() {
        return "[X:" + this.x + ", Y:" + this.y + ", Z:" + this.z + "]";
    }

    public Point3D set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Point3D set(Point3D point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
        return this;
    }

    public Point3D add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Point3D add(Point3D point) {
        this.x += point.x;
        this.y += point.y;
        this.z += point.z;
        return this;
    }

    public Point3D addScaled(Point3D point, double scale) {
        this.x += point.x * scale;
        this.y += point.y * scale;
        this.z += point.z * scale;
        return this;
    }

    public Point3D subtract(Point3D point) {
        this.x -= point.x;
        this.y -= point.y;
        this.z -= point.z;
        return this;
    }

    public Point3D multiply(Point3D point) {
        this.x *= point.x;
        this.y *= point.y;
        this.z *= point.z;
        return this;
    }

    public Point3D scale(double scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    public Point3D clamp(double clamp) {
        if (this.x > clamp) {
            this.x = clamp;
        } else if (this.x < -clamp) {
            this.x = -clamp;
        }
        if (this.y > clamp) {
            this.y = clamp;
        } else if (this.y < -clamp) {
            this.y = -clamp;
        }
        if (this.z > clamp) {
            this.z = clamp;
        } else if (this.z < -clamp) {
            this.z = -clamp;
        }
        return this;
    }

    public Point3D interpolate(Point3D point, double factor) {
        this.x += (point.x - this.x) * factor;
        this.y += (point.y - this.y) * factor;
        this.z += (point.z - this.z) * factor;
        return this;
    }

    public Point3D invert() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public double distanceTo(Point3D point) {
        double deltaX = point.x - this.x;
        double deltaY = point.y - this.y;
        double deltaZ = point.z - this.z;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public boolean isDistanceToCloserThan(Point3D point, double distance) {
        double deltaX = point.x - this.x;
        double deltaY = point.y - this.y;
        double deltaZ = point.z - this.z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ < distance * distance;
    }

    public boolean isFirstCloserThanSecond(Point3D first, Point3D second) {
        double deltaX = first.x - this.x;
        double deltaY = first.y - this.y;
        double deltaZ = first.z - this.z;
        double firstDistance = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        return firstDistance < (deltaX = second.x - this.x) * deltaX + (deltaY = second.y - this.y) * deltaY + (deltaZ = second.z - this.z) * deltaZ;
    }

    public double dotProduct(Point3D point, boolean normalized) {
        if (normalized) {
            double dotProduct = this.x * point.x + this.y * point.y + this.z * point.z;
            if (dotProduct > 1.0) {
                return 1.0;
            }
            if (dotProduct < -1.0) {
                return -1.0;
            }
            return dotProduct;
        }
        return this.x * point.x + this.y * point.y + this.z * point.z;
    }

    public Point3D crossProduct(Point3D point) {
        return new Point3D(this.y * point.z - this.z * point.y, this.z * point.x - this.x * point.z, this.x * point.y - this.y * point.x);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Point3D normalize() {
        double length = this.length();
        if (length > 1.0E-8) {
            this.x /= length;
            this.y /= length;
            this.z /= length;
        }
        return this;
    }

    public double getClampedYDelta(double otherY) {
        double deltaYaw;
        for (deltaYaw = this.y - otherY; deltaYaw > 180.0; deltaYaw -= 360.0) {
        }
        while (deltaYaw < -180.0) {
            deltaYaw += 360.0;
        }
        return deltaYaw;
    }

    public Point3D getAngles(boolean normalize) {
        if (normalize) {
            this.normalize();
        }
        double theta = Math.asin(this.y);
        double phi = Math.atan2(this.x, this.z);
        this.set(-Math.toDegrees(theta), Math.toDegrees(phi), 0.0);
        return this;
    }

    public Point3D computeVectorAngles(RotationMatrix start, RotationMatrix end) {
        return this.set(0.0, 0.0, 1.0).rotate(start).reOrigin(end).getAngles(false);
    }

    public Point3D clamp180() {
        while (this.x > 180.0) {
            this.x -= 360.0;
        }
        while (this.x < -180.0) {
            this.x += 360.0;
        }
        while (this.y > 180.0) {
            this.y -= 360.0;
        }
        while (this.y < -180.0) {
            this.y += 360.0;
        }
        while (this.z > 180.0) {
            this.z -= 360.0;
        }
        while (this.z < -180.0) {
            this.z += 360.0;
        }
        return this;
    }

    public Point3D copy() {
        return new Point3D(this.x, this.y, this.z);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public Point3D getIntermediateWithXValue(Point3D endPoint, double targetX) {
        Point3D delta = endPoint.copy().subtract(this);
        if (delta.x * delta.x < 1.0E-7) {
            return null;
        }
        double factor = (targetX - this.x) / delta.x;
        return factor >= 0.0 && factor <= 1.0 ? delta.scale(factor).add(this) : null;
    }

    public Point3D getIntermediateWithYValue(Point3D endPoint, double targetY) {
        Point3D delta = endPoint.copy().subtract(this);
        if (delta.y * delta.y < 1.0E-7) {
            return null;
        }
        double factor = (targetY - this.y) / delta.y;
        return factor >= 0.0 && factor <= 1.0 ? delta.scale(factor).add(this) : null;
    }

    public Point3D getIntermediateWithZValue(Point3D endPoint, double targetZ) {
        Point3D delta = endPoint.copy().subtract(this);
        if (delta.z * delta.z < 1.0E-7) {
            return null;
        }
        double factor = (targetZ - this.z) / delta.z;
        return factor >= 0.0 && factor <= 1.0 ? delta.scale(factor).add(this) : null;
    }

    public Point3D rotate(RotationMatrix matrix) {
        return matrix.rotate(this);
    }

    public Point3D reOrigin(RotationMatrix matrix) {
        return matrix.reOrigin(this);
    }

    public Point3D transform(TransformationMatrix matrix) {
        return matrix.transform(this);
    }
}

