/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mcinterface1122.ABuilderEntityBase;
import mcinterface1122.BuilderBlock;
import mcinterface1122.BuilderEntityExisting;
import mcinterface1122.BuilderEntityLinkedSeat;
import mcinterface1122.BuilderTileEntity;
import mcinterface1122.WrapperEntity;
import mcinterface1122.WrapperItemStack;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperPlayer;
import minecrafttransportsimulator.baseclasses.BlockHitResult;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketWorldSavedDataRequest;
import minecrafttransportsimulator.packets.instances.PacketWorldSavedDataUpdate;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class WrapperWorld
extends AWrapperWorld {
    private static final Map<World, WrapperWorld> worldWrappers = new HashMap<World, WrapperWorld>();
    private final Map<UUID, BuilderEntityExisting> playerServerGunBuilders = new HashMap<UUID, BuilderEntityExisting>();
    private final Map<UUID, Integer> ticksSincePlayerJoin = new HashMap<UUID, Integer>();
    private final List<AxisAlignedBB> mutableCollidingAABBs = new ArrayList<AxisAlignedBB>();
    private final Set<BlockPos> knownAirBlocks = new HashSet<BlockPos>();
    protected final World world;
    private final IWrapperNBT savedData;
    private static HashMap<Material, ABlockBase.BlockMaterial> materialMap = new HashMap();

    public static WrapperWorld getWrapperFor(World world) {
        if (world != null) {
            WrapperWorld wrapper = worldWrappers.get(world);
            if (wrapper == null || world != wrapper.world) {
                wrapper = new WrapperWorld(world);
                worldWrappers.put(world, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    private WrapperWorld(World world) {
        this.world = world;
        if (world.field_72995_K) {
            this.savedData = InterfaceManager.coreInterface.getNewNBTWrapper();
            InterfaceManager.packetInterface.sendToServer(new PacketWorldSavedDataRequest(InterfaceManager.clientInterface.getClientPlayer()));
        } else {
            try {
                this.savedData = this.getDataFile().exists() ? new WrapperNBT(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(this.getDataFile().toPath(), new OpenOption[0]))) : InterfaceManager.coreInterface.getNewNBTWrapper();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Could not load saved data from disk!  This will result in data loss if we continue!");
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isClient() {
        return this.world.field_72995_K;
    }

    @Override
    public long getTime() {
        return this.world.func_72820_D() % 24000L;
    }

    @Override
    public String getName() {
        return this.world.field_73011_w.func_186058_p().func_186065_b();
    }

    @Override
    public long getMaxHeight() {
        return this.world.func_72800_K();
    }

    @Override
    public void beginProfiling(String name, boolean subProfile) {
        if (subProfile) {
            this.world.field_72984_F.func_76320_a(name);
        } else {
            this.world.field_72984_F.func_76318_c(name);
        }
    }

    @Override
    public void endProfiling() {
        this.world.field_72984_F.func_76319_b();
    }

    @Override
    public IWrapperNBT getData(String name) {
        if (name.isEmpty()) {
            return this.savedData;
        }
        return this.savedData.getData(name);
    }

    @Override
    public void setData(String name, IWrapperNBT value) {
        this.savedData.setData(name, value);
        if (!this.isClient()) {
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)((WrapperNBT)this.savedData).tag, (OutputStream)Files.newOutputStream(this.getDataFile().toPath(), new OpenOption[0]));
                InterfaceManager.packetInterface.sendToAllClients(new PacketWorldSavedDataUpdate(name, value));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Could not save data to disk!  This will result in data loss if we continue!");
            }
        }
    }

    @Override
    public File getDataFile() {
        return new File(this.world.func_72860_G().func_75765_b(), "mtsdata.dat");
    }

    @Override
    public WrapperEntity getExternalEntity(UUID entityID) {
        for (Entity entity : this.world.field_72996_f) {
            if (!entity.func_110124_au().equals(entityID)) continue;
            return WrapperEntity.getWrapperFor(entity);
        }
        return null;
    }

    @Override
    public List<IWrapperEntity> getEntitiesWithin(BoundingBox box) {
        ArrayList<IWrapperEntity> entities = new ArrayList<IWrapperEntity>();
        for (Entity entity : this.world.func_72872_a(Entity.class, WrapperWorld.convert(box))) {
            if (!(entity instanceof EntityLivingBase)) continue;
            entities.add(WrapperEntity.getWrapperFor(entity));
        }
        return entities;
    }

    @Override
    public List<IWrapperPlayer> getPlayersWithin(BoundingBox box) {
        ArrayList<IWrapperPlayer> players = new ArrayList<IWrapperPlayer>();
        for (EntityPlayer player : this.world.func_72872_a(EntityPlayer.class, WrapperWorld.convert(box))) {
            players.add(WrapperPlayer.getWrapperFor(player));
        }
        return players;
    }

    @Override
    public List<IWrapperEntity> getEntitiesHostile(IWrapperEntity lookingEntity, double radius) {
        ArrayList<IWrapperEntity> entities = new ArrayList<IWrapperEntity>();
        Entity mcLooker = ((WrapperEntity)lookingEntity).entity;
        for (Entity entity : this.world.func_72839_b(mcLooker, mcLooker.func_174813_aQ().func_186662_g(radius))) {
            if (!(entity instanceof IMob) || entity.field_70128_L || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).field_70725_aQ != 0) continue;
            entities.add(WrapperEntity.getWrapperFor(entity));
        }
        return entities;
    }

    @Override
    public void spawnEntity(AEntityB_Existing entity) {
        this.spawnEntityInternal(entity);
    }

    protected BuilderEntityExisting spawnEntityInternal(AEntityB_Existing entity) {
        BuilderEntityExisting builder = new BuilderEntityExisting(((WrapperWorld)entity.world).world);
        builder.loadedFromSavedNBT = true;
        builder.func_70080_a(entity.position.x, entity.position.y, entity.position.z, 0.0f, 0.0f);
        builder.entity = entity;
        this.world.func_72838_d((Entity)builder);
        this.addEntity(entity);
        return builder;
    }

    @Override
    public List<IWrapperEntity> attackEntities(Damage damage, Point3D motion, boolean generateList) {
        AxisAlignedBB mcBox = WrapperWorld.convert(damage.box);
        if (motion != null) {
            mcBox = mcBox.func_72321_a(motion.x, motion.y, motion.z);
        }
        List collidedEntities = this.world.func_72872_a(Entity.class, mcBox);
        Vec3d start = null;
        Vec3d end = null;
        ArrayList<IWrapperEntity> hitEntities = new ArrayList<IWrapperEntity>();
        if (motion != null) {
            Point3D startPoint = damage.box.globalCenter;
            Point3D endPoint = damage.box.globalCenter.copy().add(motion);
            start = new Vec3d(startPoint.x, startPoint.y, startPoint.z);
            end = new Vec3d(endPoint.x, endPoint.y, endPoint.z);
        }
        for (Entity mcEntityCollided : collidedEntities) {
            Entity mcRidingEntity;
            if (mcEntityCollided instanceof ABuilderEntityBase) continue;
            if (damage.damgeSource != null && (mcRidingEntity = mcEntityCollided.func_184187_bx()) instanceof BuilderEntityLinkedSeat) {
                AEntityB_Existing internalRidingEntity = ((BuilderEntityLinkedSeat)mcRidingEntity).entity;
                if (damage.damgeSource == internalRidingEntity) continue;
                if (internalRidingEntity instanceof APart) {
                    APart ridingPart = (APart)internalRidingEntity;
                    if (ridingPart.masterEntity.allParts.contains(damage.damgeSource)) continue;
                }
            }
            if (motion != null && mcEntityCollided.func_174813_aQ().func_72327_a(start, end) == null) continue;
            hitEntities.add(WrapperEntity.getWrapperFor(mcEntityCollided));
        }
        if (generateList) {
            return hitEntities;
        }
        for (IWrapperEntity entity : hitEntities) {
            entity.attack(damage);
        }
        return null;
    }

    @Override
    public void loadEntities(BoundingBox box, AEntityE_Interactable<?> entityToLoad) {
        block0: for (Entity entity : this.world.func_72872_a(Entity.class, WrapperWorld.convert(box))) {
            if (entity.func_184218_aH() || !(entity instanceof INpc) && !(entity instanceof EntityCreature) || entity instanceof IMob) continue;
            if (entityToLoad instanceof EntityVehicleF_Physics) {
                for (APart part : ((EntityVehicleF_Physics)entityToLoad).allParts) {
                    if (!(part instanceof PartSeat) || part.rider != null || part.placementDefinition.isController) continue;
                    part.setRider(new WrapperEntity(entity), true);
                    continue block0;
                }
                continue;
            }
            if (entityToLoad.rider != null) continue;
            entityToLoad.setRider(new WrapperEntity(entity), true);
            break;
        }
    }

    @Override
    public void populateItemStackEntities(Map<IWrapperEntity, IWrapperItemStack> map, BoundingBox box) {
        for (EntityItem mcEntity : this.world.func_72872_a(EntityItem.class, WrapperWorld.convert(box))) {
            WrapperEntity entity = WrapperEntity.getWrapperFor((Entity)mcEntity);
            if (map.containsKey(entity)) continue;
            map.put(entity, new WrapperItemStack(mcEntity.func_92059_d()));
        }
    }

    @Override
    public void removeItemStackEntity(IWrapperEntity entity) {
        ((WrapperEntity)entity).entity.func_70106_y();
    }

    @Override
    public boolean chunkLoaded(Point3D position) {
        return this.world.func_175667_e(new BlockPos(position.x, position.y, position.z));
    }

    @Override
    public ABlockBase getBlock(Point3D position) {
        Block block = this.world.func_180495_p(new BlockPos(position.x, position.y, position.z)).func_177230_c();
        return block instanceof BuilderBlock ? ((BuilderBlock)block).block : null;
    }

    @Override
    public float getBlockHardness(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        float hardness = this.world.func_180495_p(pos).func_185887_b(this.world, pos);
        if (hardness < 0.0f) {
            hardness = Float.MAX_VALUE;
        }
        return hardness;
    }

    @Override
    public float getBlockSlipperiness(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        IBlockState state = this.world.func_180495_p(pos);
        return state.func_177230_c().getSlipperiness(state, (IBlockAccess)this.world, pos, null);
    }

    @Override
    public ABlockBase.BlockMaterial getBlockMaterial(Point3D position) {
        BlockPos pos;
        if (materialMap.isEmpty()) {
            materialMap.put(Material.field_151571_B, ABlockBase.BlockMaterial.CLAY);
            materialMap.put(Material.field_151578_c, ABlockBase.BlockMaterial.DIRT);
            materialMap.put(Material.field_151592_s, ABlockBase.BlockMaterial.GLASS);
            materialMap.put(Material.field_151577_b, ABlockBase.BlockMaterial.GRASS);
            materialMap.put(Material.field_151588_w, ABlockBase.BlockMaterial.ICE);
            materialMap.put(Material.field_151598_x, ABlockBase.BlockMaterial.ICE);
            materialMap.put(Material.field_151587_i, ABlockBase.BlockMaterial.LAVA);
            materialMap.put(Material.field_151584_j, ABlockBase.BlockMaterial.LEAVES);
            materialMap.put(Material.field_151574_g, ABlockBase.BlockMaterial.METAL);
            materialMap.put(Material.field_151595_p, ABlockBase.BlockMaterial.SAND);
            materialMap.put(Material.field_151597_y, ABlockBase.BlockMaterial.SNOW);
            materialMap.put(Material.field_151596_z, ABlockBase.BlockMaterial.SNOW);
            materialMap.put(Material.field_151576_e, ABlockBase.BlockMaterial.STONE);
            materialMap.put(Material.field_151586_h, ABlockBase.BlockMaterial.WATER);
            materialMap.put(Material.field_151575_d, ABlockBase.BlockMaterial.WOOD);
            materialMap.put(Material.field_151580_n, ABlockBase.BlockMaterial.WOOL);
        }
        if (this.world.func_175623_d(pos = new BlockPos(position.x, position.y, position.z))) {
            return null;
        }
        ABlockBase.BlockMaterial material = materialMap.get(this.world.func_180495_p(pos).func_185904_a());
        if (material == null) {
            return ABlockBase.BlockMaterial.NORMAL;
        }
        if (material == ABlockBase.BlockMaterial.SAND && this.world.func_180495_p(pos).func_177230_c() == Blocks.field_150351_n) {
            return ABlockBase.BlockMaterial.GRAVEL;
        }
        return material;
    }

    @Override
    public List<IWrapperItemStack> getBlockDrops(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        IBlockState state = this.world.func_180495_p(pos);
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)this.world, pos, state, 0);
        ArrayList<IWrapperItemStack> convertedList = new ArrayList<IWrapperItemStack>();
        for (ItemStack stack : drops) {
            convertedList.add(new WrapperItemStack(stack.func_77946_l()));
        }
        return convertedList;
    }

    @Override
    public BlockHitResult getBlockHit(Point3D position, Point3D delta) {
        BlockPos blockPos;
        Vec3d start = new Vec3d(position.x, position.y, position.z);
        RayTraceResult trace = this.world.func_147447_a(start, start.func_72441_c(delta.x, delta.y, delta.z), false, true, false);
        if (trace != null && (blockPos = trace.func_178782_a()) != null) {
            return new BlockHitResult(new Point3D(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), new Point3D(trace.field_72307_f.field_72450_a, trace.field_72307_f.field_72448_b, trace.field_72307_f.field_72449_c), ABlockBase.Axis.valueOf(trace.field_178784_b.name()));
        }
        return null;
    }

    @Override
    public boolean isBlockSolid(Point3D position, ABlockBase.Axis axis) {
        if (axis.blockBased) {
            BlockPos pos = new BlockPos(position.x, position.y, position.z);
            IBlockState state = this.world.func_180495_p(pos);
            Block offsetMCBlock = state.func_177230_c();
            EnumFacing facing = EnumFacing.valueOf((String)axis.name());
            return offsetMCBlock != null && !offsetMCBlock.equals(Blocks.field_180401_cv) && state.isSideSolid((IBlockAccess)this.world, pos, facing);
        }
        return false;
    }

    @Override
    public boolean isBlockLiquid(Point3D position) {
        return this.world.func_180495_p(new BlockPos(position.x, position.y, position.z)).func_185904_a().func_76224_d();
    }

    @Override
    public boolean isBlockBelowBottomSlab(Point3D position) {
        IBlockState state = this.world.func_180495_p(new BlockPos(position.x, position.y - 1.0, position.z));
        Block block = state.func_177230_c();
        return block instanceof BlockSlab && !((BlockSlab)block).func_176552_j() && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM;
    }

    @Override
    public boolean isBlockAboveTopSlab(Point3D position) {
        IBlockState state = this.world.func_180495_p(new BlockPos(position.x, position.y + 1.0, position.z));
        Block block = state.func_177230_c();
        return block instanceof BlockSlab && !((BlockSlab)block).func_176552_j() && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
    }

    @Override
    public double getHeight(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        boolean bottomSlab = false;
        while (pos.func_177956_o() > 0) {
            if (!this.world.func_175623_d(pos)) {
                IBlockState state = this.world.func_180495_p(pos);
                Block block = state.func_177230_c();
                bottomSlab = block instanceof BlockSlab && !((BlockSlab)block).func_176552_j() && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM;
                pos = pos.func_177984_a();
                break;
            }
            pos = pos.func_177977_b();
        }
        return bottomSlab ? position.y - ((double)pos.func_177956_o() - 0.5) : position.y - (double)pos.func_177956_o();
    }

    @Override
    public void updateBoundingBoxCollisions(BoundingBox box, Point3D collisionMotion, boolean ignoreIfGreater) {
        AxisAlignedBB mcBox = WrapperWorld.convert(box);
        box.collidingBlockPositions.clear();
        this.mutableCollidingAABBs.clear();
        int i = (int)Math.floor(mcBox.field_72340_a);
        while ((double)i < Math.ceil(mcBox.field_72336_d)) {
            int j = (int)Math.floor(mcBox.field_72338_b);
            while ((double)j < Math.ceil(mcBox.field_72337_e)) {
                int k = (int)Math.floor(mcBox.field_72339_c);
                while ((double)k < Math.ceil(mcBox.field_72334_f)) {
                    BlockPos pos = new BlockPos(i, j, k);
                    if (this.world.func_175667_e(pos)) {
                        IBlockState state = this.world.func_180495_p(pos);
                        if (state.func_177230_c().func_176209_a(state, false) && state.func_185890_d((IBlockAccess)this.world, pos) != null && state.func_185904_a() != Material.field_151584_j) {
                            int oldCollidingBlockCount = this.mutableCollidingAABBs.size();
                            state.func_185908_a(this.world, pos, mcBox, this.mutableCollidingAABBs, null, false);
                            if (this.mutableCollidingAABBs.size() > oldCollidingBlockCount) {
                                box.collidingBlockPositions.add(new Point3D(i, j, k));
                            }
                        }
                        if (box.collidesWithLiquids && state.func_185904_a().func_76224_d()) {
                            this.mutableCollidingAABBs.add(state.func_185900_c((IBlockAccess)this.world, pos).func_186670_a(pos));
                            box.collidingBlockPositions.add(new Point3D(i, j, k));
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        box.currentCollisionDepth.set(0.0, 0.0, 0.0);
        for (AxisAlignedBB colBox : this.mutableCollidingAABBs) {
            double boxCollisionDepth;
            if (collisionMotion.x > 0.0) {
                double boxCollisionDepth2 = mcBox.field_72336_d - colBox.field_72340_a;
                if (box.currentCollisionDepth.x < boxCollisionDepth2) {
                    box.currentCollisionDepth.x = boxCollisionDepth2;
                }
            } else if (collisionMotion.x < 0.0 && box.currentCollisionDepth.x > (boxCollisionDepth = -(colBox.field_72336_d - mcBox.field_72340_a))) {
                box.currentCollisionDepth.x = boxCollisionDepth;
            }
            if (collisionMotion.y > 0.0) {
                boxCollisionDepth = mcBox.field_72337_e - colBox.field_72338_b;
                if (box.currentCollisionDepth.y < boxCollisionDepth) {
                    box.currentCollisionDepth.y = boxCollisionDepth;
                }
            } else if (collisionMotion.y < 0.0 && box.currentCollisionDepth.y > (boxCollisionDepth = -(colBox.field_72337_e - mcBox.field_72338_b))) {
                box.currentCollisionDepth.y = boxCollisionDepth;
            }
            if (collisionMotion.z > 0.0) {
                boxCollisionDepth = mcBox.field_72334_f - colBox.field_72339_c;
                if (!(box.currentCollisionDepth.z < boxCollisionDepth)) continue;
                box.currentCollisionDepth.z = boxCollisionDepth;
                continue;
            }
            if (!(collisionMotion.z < 0.0) || !(box.currentCollisionDepth.z > (boxCollisionDepth = -(colBox.field_72334_f - mcBox.field_72339_c)))) continue;
            box.currentCollisionDepth.z = boxCollisionDepth;
        }
        if (ignoreIfGreater) {
            if (collisionMotion.x > 0.0 && box.currentCollisionDepth.x > collisionMotion.x) {
                box.currentCollisionDepth.x = collisionMotion.x;
            } else if (collisionMotion.x < 0.0 && box.currentCollisionDepth.x < collisionMotion.x) {
                box.currentCollisionDepth.x = collisionMotion.x;
            }
            if (collisionMotion.y > 0.0 && box.currentCollisionDepth.y > collisionMotion.y) {
                box.currentCollisionDepth.y = collisionMotion.y;
            } else if (collisionMotion.y < 0.0 && box.currentCollisionDepth.y < collisionMotion.y) {
                box.currentCollisionDepth.y = collisionMotion.y;
            }
            if (collisionMotion.z > 0.0 && box.currentCollisionDepth.z > collisionMotion.z) {
                box.currentCollisionDepth.z = collisionMotion.z;
            } else if (collisionMotion.z < 0.0 && box.currentCollisionDepth.z < collisionMotion.z) {
                box.currentCollisionDepth.z = collisionMotion.z;
            }
        }
        if (box.currentCollisionDepth.isZero()) {
            box.collidingBlockPositions.clear();
        }
    }

    @Override
    public boolean checkForCollisions(BoundingBox box, Point3D offset, boolean clearCache, boolean breakLeaves) {
        if (clearCache) {
            this.knownAirBlocks.clear();
        }
        this.mutableCollidingAABBs.clear();
        AxisAlignedBB mcBox = WrapperWorld.convertWithOffset(box, offset.x, offset.y, offset.z);
        int i = (int)Math.floor(mcBox.field_72340_a);
        while ((double)i < Math.ceil(mcBox.field_72336_d)) {
            int j = (int)Math.floor(mcBox.field_72338_b);
            while ((double)j < Math.ceil(mcBox.field_72337_e)) {
                int k = (int)Math.floor(mcBox.field_72339_c);
                while ((double)k < Math.ceil(mcBox.field_72334_f)) {
                    BlockPos pos = new BlockPos(i, j, k);
                    if (!this.knownAirBlocks.contains(pos) && this.world.func_175667_e(pos)) {
                        IBlockState state = this.world.func_180495_p(pos);
                        if (state.func_185904_a() != Material.field_151584_j) {
                            if (state.func_177230_c().func_176209_a(state, false) && state.func_185890_d((IBlockAccess)this.world, pos) != null) {
                                int oldCollidingBlockCount = this.mutableCollidingAABBs.size();
                                state.func_185908_a(this.world, pos, mcBox, this.mutableCollidingAABBs, null, false);
                                if (this.mutableCollidingAABBs.size() > oldCollidingBlockCount) {
                                    return true;
                                }
                            } else {
                                this.knownAirBlocks.add(pos);
                            }
                            if (box.collidesWithLiquids && state.func_185904_a().func_76224_d() && mcBox.func_72326_a(state.func_185900_c((IBlockAccess)this.world, pos).func_186670_a(pos))) {
                                return true;
                            }
                        } else if (breakLeaves) {
                            this.world.func_175655_b(pos, false);
                        } else {
                            this.knownAirBlocks.add(pos);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getRedstonePower(Point3D position) {
        return this.world.func_175687_A(new BlockPos(position.x, position.y, position.z));
    }

    @Override
    public float getRainStrength(Point3D position) {
        return this.world.func_175727_C(new BlockPos(position.x, position.y + 1.0, position.z)) ? this.world.func_72867_j(1.0f) + this.world.func_72819_i(1.0f) : 0.0f;
    }

    @Override
    public float getTemperature(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        return this.world.func_180494_b(pos).func_180626_a(pos);
    }

    @Override
    public <TileEntityType extends ATileEntityBase<JSONDefinition>, JSONDefinition extends AJSONMultiModelProvider> boolean setBlock(ABlockBase block, Point3D position, IWrapperPlayer playerWrapper, ABlockBase.Axis axis) {
        if (!this.world.field_72995_K) {
            BuilderBlock wrapper = BuilderBlock.blockMap.get(block);
            BlockPos pos = new BlockPos(position.x, position.y, position.z);
            if (playerWrapper != null) {
                IBlockState newState;
                EntityPlayer mcPayer = ((WrapperPlayer)playerWrapper).player;
                WrapperItemStack stack = (WrapperItemStack)playerWrapper.getHeldStack();
                AItemBase item = stack.getItem();
                EnumFacing facing = EnumFacing.valueOf((String)axis.name());
                if (!this.world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.world, pos)) {
                    pos = pos.func_177972_a(facing);
                    position.add(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
                }
                if (item != null && mcPayer.func_175151_a(pos, facing, stack.stack) && this.world.func_190527_a((Block)wrapper, pos, false, facing, null) && this.world.func_180501_a(pos, newState = wrapper.getStateForPlacement(this.world, pos, facing, 0.0f, 0.0f, 0.0f, 0, (EntityLivingBase)mcPayer, EnumHand.MAIN_HAND), 11)) {
                    if (block instanceof ABlockBaseTileEntity) {
                        BuilderTileEntity builderTile = (BuilderTileEntity)this.world.func_175625_s(pos);
                        IWrapperNBT data = stack.getData();
                        if (data != null) {
                            data.deleteAllUUIDTags();
                        }
                        builderTile.tileEntity = ((ABlockBaseTileEntity)block).createTileEntity(this, position, playerWrapper, (AItemSubTyped)item, data);
                        this.addEntity(builderTile.tileEntity);
                    }
                    stack.add(-1);
                    return true;
                }
            } else {
                IBlockState newState = wrapper.func_176223_P();
                return this.world.func_180501_a(pos, newState, 11);
            }
        }
        return false;
    }

    @Override
    public <TileEntityType extends ATileEntityBase<?>> TileEntityType getTileEntity(Point3D position) {
        TileEntity tile = this.world.func_175625_s(new BlockPos(position.x, position.y, position.z));
        return tile instanceof BuilderTileEntity ? (TileEntityType)((BuilderTileEntity)tile).tileEntity : null;
    }

    @Override
    public void markTileEntityChanged(Point3D position) {
        this.world.func_175625_s(new BlockPos(position.x, position.y, position.z)).func_70296_d();
    }

    @Override
    public float getLightBrightness(Point3D position, boolean calculateBlock) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        float sunLight = this.world.getSunBrightnessFactor(0.0f) * (float)(this.world.func_175642_b(EnumSkyBlock.SKY, pos) - this.world.func_175657_ab()) / 15.0f;
        float blockLight = calculateBlock ? (float)this.world.func_175705_a(EnumSkyBlock.BLOCK, pos) / 15.0f : 0.0f;
        return Math.max(sunLight, blockLight);
    }

    @Override
    public void updateLightBrightness(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        this.world.func_175664_x(pos);
    }

    @Override
    public void destroyBlock(Point3D position, boolean spawnDrops) {
        this.world.func_175655_b(new BlockPos(position.x, position.y, position.z), spawnDrops);
    }

    @Override
    public boolean isAir(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block.isAir(state, (IBlockAccess)this.world, pos);
    }

    @Override
    public boolean isFire(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        IBlockState state = this.world.func_180495_p(pos);
        return state.func_185904_a().equals(Material.field_151581_o);
    }

    @Override
    public void setToFire(Point3D position, ABlockBase.Axis side) {
        BlockPos blockpos = new BlockPos(position.x, position.y, position.z).func_177972_a(EnumFacing.valueOf((String)side.name()));
        if (this.world.func_175623_d(blockpos) && ((Boolean)ConfigSystem.settings.general.blockBreakage.value).booleanValue()) {
            this.world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    @Override
    public void extinguish(Point3D position, ABlockBase.Axis side) {
        this.world.func_175719_a(null, new BlockPos(position.x, position.y, position.z), EnumFacing.valueOf((String)side.name()));
    }

    @Override
    public boolean placeBlock(Point3D position, IWrapperItemStack stack) {
        IBlockState newState;
        ItemStack mcStack;
        Block block;
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        return this.world.func_175623_d(pos) && (block = Block.func_149634_a((Item)(mcStack = ((WrapperItemStack)stack).stack).func_77973_b())) != Blocks.field_150350_a && this.world.func_180501_a(pos, newState = block.func_176203_a(mcStack.func_77960_j()), 11);
    }

    @Override
    public boolean fertilizeBlock(Point3D position, IWrapperItemStack stack) {
        IGrowable growable;
        BlockPos cropPos;
        IBlockState cropState;
        Block cropBlock;
        ItemStack mcStack = ((WrapperItemStack)stack).stack;
        if (mcStack.func_77973_b() == Items.field_151100_aR && !this.world.field_72995_K && (cropBlock = (cropState = this.world.func_180495_p(cropPos = new BlockPos(position.x, position.y, position.z))).func_177230_c()) instanceof IGrowable && (growable = (IGrowable)cropState.func_177230_c()).func_176473_a(this.world, cropPos, cropState, this.world.field_72995_K)) {
            ItemDye.func_179234_a((ItemStack)mcStack.func_77946_l(), (World)this.world, (BlockPos)cropPos);
            return true;
        }
        return false;
    }

    @Override
    public List<IWrapperItemStack> harvestBlock(Point3D position) {
        ArrayList<IWrapperItemStack> cropDrops;
        block5: {
            BlockPos pos = new BlockPos(position.x, position.y, position.z);
            IBlockState state = this.world.func_180495_p(pos);
            cropDrops = new ArrayList<IWrapperItemStack>();
            if ((!(state.func_177230_c() instanceof BlockCrops) || !((BlockCrops)state.func_177230_c()).func_185525_y(state)) && !(state.func_177230_c() instanceof BlockBush)) break block5;
            Block harvestedBlock = state.func_177230_c();
            NonNullList drops = NonNullList.func_191196_a();
            this.world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), harvestedBlock.getSoundType(state, this.world, pos, null).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            if (!this.world.field_72995_K) {
                harvestedBlock.getDrops(drops, (IBlockAccess)this.world, pos, state, 0);
                this.world.func_175698_g(pos);
                if (harvestedBlock instanceof BlockCrops) {
                    for (ItemStack drop : drops) {
                        cropDrops.add(new WrapperItemStack(drop.func_77946_l()));
                    }
                } else {
                    for (ItemStack stack : drops) {
                        if (stack.func_190916_E() <= 0) continue;
                        this.world.func_72838_d((Entity)new EntityItem(this.world, position.x, position.y, position.z, stack));
                    }
                }
            }
        }
        return cropDrops;
    }

    @Override
    public boolean plantBlock(Point3D position, IWrapperItemStack stack) {
        Item item = ((WrapperItemStack)stack).stack.func_77973_b();
        if (item instanceof IPlantable) {
            IBlockState plantState;
            BlockPos cropPos;
            IPlantable plantable = (IPlantable)item;
            BlockPos farmlandPos = new BlockPos(position.x, position.y, position.z);
            IBlockState farmlandState = this.world.func_180495_p(farmlandPos);
            Block farmlandBlock = farmlandState.func_177230_c();
            if (farmlandBlock.equals(Blocks.field_150458_ak) && this.world.func_175623_d(cropPos = farmlandPos.func_177984_a()) && farmlandBlock.canSustainPlant(plantState = plantable.getPlant((IBlockAccess)this.world, cropPos), (IBlockAccess)this.world, farmlandPos, EnumFacing.UP, plantable)) {
                this.world.func_180501_a(cropPos, plantState, 11);
                this.world.func_184134_a((double)farmlandPos.func_177958_n(), (double)farmlandPos.func_177956_o(), (double)farmlandPos.func_177952_p(), plantState.func_177230_c().getSoundType(plantState, this.world, farmlandPos, null).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean plowBlock(Point3D position) {
        IBlockState newState;
        BlockPos pos;
        block5: {
            block6: {
                Block block;
                IBlockState oldState;
                block4: {
                    pos = new BlockPos(position.x, position.y, position.z);
                    oldState = this.world.func_180495_p(pos);
                    block = oldState.func_177230_c();
                    if (!block.equals(Blocks.field_150349_c) && !block.equals(Blocks.field_185774_da)) break block4;
                    newState = Blocks.field_150458_ak.func_176223_P();
                    break block5;
                }
                if (!block.equals(Blocks.field_150346_d)) break block6;
                switch ((BlockDirt.DirtType)oldState.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        newState = Blocks.field_150458_ak.func_176223_P();
                        break block5;
                    }
                    case COARSE_DIRT: {
                        newState = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT);
                        break block5;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        this.world.func_180501_a(pos, newState, 11);
        this.world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        return true;
    }

    @Override
    public boolean removeSnow(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_185904_a().equals(Material.field_151597_y) || state.func_185904_a().equals(Material.field_151596_z)) {
            this.world.func_175698_g(pos);
            this.world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187807_fF, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean insertStack(Point3D position, ABlockBase.Axis axis, IWrapperItemStack stack) {
        IItemHandler itemHandler;
        EnumFacing facing = EnumFacing.valueOf((String)axis.name());
        TileEntity tile = this.world.func_175625_s(new BlockPos(position.x, position.y, position.z).func_177972_a(facing));
        if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack remainingStack = itemHandler.insertItem(i, ((WrapperItemStack)stack).stack, true);
                if (remainingStack.func_190916_E() >= stack.getSize()) continue;
                IWrapperItemStack stackToInsert = stack.split(1);
                itemHandler.insertItem(i, ((WrapperItemStack)stackToInsert).stack, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public WrapperItemStack extractStack(Point3D position, ABlockBase.Axis axis) {
        IItemHandler itemHandler;
        EnumFacing facing = EnumFacing.valueOf((String)axis.name());
        TileEntity tile = this.world.func_175625_s(new BlockPos(position.x, position.y, position.z).func_177972_a(facing));
        if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack extractedStack = itemHandler.extractItem(i, 1, false);
                if (extractedStack.func_190926_b()) continue;
                return new WrapperItemStack(extractedStack);
            }
        }
        return null;
    }

    @Override
    public void spawnItemStack(IWrapperItemStack stack, Point3D point) {
        this.world.func_72838_d((Entity)new EntityItem(this.world, point.x, point.y + 1.0, point.z, ((WrapperItemStack)stack).stack));
    }

    @Override
    public void spawnExplosion(Point3D location, double strength, boolean flames) {
        this.world.func_72885_a(null, location.x, location.y, location.z, (float)strength, flames && (Boolean)ConfigSystem.settings.general.blockBreakage.value != false, ((Boolean)ConfigSystem.settings.general.blockBreakage.value).booleanValue());
    }

    public static AxisAlignedBB convert(BoundingBox box) {
        return new AxisAlignedBB(box.globalCenter.x - box.widthRadius, box.globalCenter.y - box.heightRadius, box.globalCenter.z - box.depthRadius, box.globalCenter.x + box.widthRadius, box.globalCenter.y + box.heightRadius, box.globalCenter.z + box.depthRadius);
    }

    public static AxisAlignedBB convertWithOffset(BoundingBox box, double x, double y, double z) {
        return new AxisAlignedBB(x + box.globalCenter.x - box.widthRadius, y + box.globalCenter.y - box.heightRadius, z + box.globalCenter.z - box.depthRadius, x + box.globalCenter.x + box.widthRadius, y + box.globalCenter.y + box.heightRadius, z + box.globalCenter.z + box.depthRadius);
    }

    @SubscribeEvent
    public void onIVWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.world.equals(this.world)) {
            if (event.phase.equals((Object)TickEvent.Phase.START)) {
                this.beginProfiling("MTS_ServerVehicleUpdates", true);
                this.tickAll();
                for (EntityPlayer player : event.world.field_73010_i) {
                    UUID playerUUID = player.func_110124_au();
                    BuilderEntityExisting gunBuilder = this.playerServerGunBuilders.get(playerUUID);
                    if (gunBuilder != null) {
                        if (gunBuilder.field_70170_p != player.field_70170_p || player.field_70128_L || !gunBuilder.entity.isValid || gunBuilder.idleTickCounter == 20) {
                            gunBuilder.func_70106_y();
                            this.playerServerGunBuilders.remove(playerUUID);
                            this.ticksSincePlayerJoin.remove(playerUUID);
                            continue;
                        }
                        ++gunBuilder.idleTickCounter;
                        continue;
                    }
                    if (player.field_70128_L) continue;
                    int totalTicksWaited = 0;
                    if (this.ticksSincePlayerJoin.containsKey(playerUUID)) {
                        totalTicksWaited = this.ticksSincePlayerJoin.get(playerUUID);
                    }
                    if (++totalTicksWaited == 60) {
                        WrapperPlayer playerWrapper = WrapperPlayer.getWrapperFor(player);
                        EntityPlayerGun entity = new EntityPlayerGun(this, playerWrapper, null);
                        this.playerServerGunBuilders.put(playerUUID, this.spawnEntityInternal(entity));
                        if (!((Boolean)ConfigSystem.settings.general.giveManualsOnJoin.value).booleanValue() || ((List)ConfigSystem.settings.general.joinedPlayers.value).contains(playerUUID)) continue;
                        playerWrapper.getInventory().addStack(((AItemBase)PackParser.getItem("mts", "handbook_car")).getNewStack(null));
                        playerWrapper.getInventory().addStack(((AItemBase)PackParser.getItem("mts", "handbook_plane")).getNewStack(null));
                        ((List)ConfigSystem.settings.general.joinedPlayers.value).add(playerUUID);
                        ConfigSystem.saveToDisk();
                        continue;
                    }
                    this.ticksSincePlayerJoin.put(playerUUID, totalTicksWaited);
                }
            } else {
                this.beginProfiling("MTS_PlayerGunUpdates", true);
                for (EntityPlayerGun gun : this.getEntitiesOfType(EntityPlayerGun.class)) {
                    gun.update();
                    gun.doPostUpdateLogic();
                }
            }
            this.endProfiling();
        }
    }

    @SubscribeEvent
    public void onIVWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() == this.world) {
            for (AEntityA_Base entity : this.allEntities) {
                entity.remove();
            }
            worldWrappers.remove(this.world);
        }
    }
}

