/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mcinterface1122.BuilderEntityLinkedSeat;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperPlayer;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class WrapperEntity
implements IWrapperEntity {
    private static final Map<Entity, WrapperEntity> entityClientWrappers = new HashMap<Entity, WrapperEntity>();
    private static final Map<Entity, WrapperEntity> entityServerWrappers = new HashMap<Entity, WrapperEntity>();
    protected final Entity entity;
    private AEntityB_Existing cachedEntityRiding;
    private final Point3D mutablePosition = new Point3D();
    private final Point3D mutableVelocity = new Point3D();
    private final RotationMatrix mutableOrientation = new RotationMatrix();
    private float lastPitchChecked;
    private float lastYawChecked;
    private float lastYawApplied;
    private float lastPitch;
    private float lastYaw;
    private final Point3D mutableSight = new Point3D();
    private final BoundingBox mutableBounds = new BoundingBox(new Point3D(), 0.0, 0.0, 0.0);

    public static WrapperEntity getWrapperFor(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return WrapperPlayer.getWrapperFor((EntityPlayer)entity);
        }
        if (entity != null) {
            Map<Entity, WrapperEntity> entityWrappers = entity.field_70170_p.field_72995_K ? entityClientWrappers : entityServerWrappers;
            WrapperEntity wrapper = entityWrappers.get(entity);
            if (wrapper == null || !wrapper.isValid() || entity != wrapper.entity) {
                wrapper = new WrapperEntity(entity);
                entityWrappers.put(entity, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    protected WrapperEntity(Entity entity) {
        this.entity = entity;
    }

    public boolean equals(Object obj) {
        return this.entity.equals(obj instanceof WrapperEntity ? ((WrapperEntity)obj).entity : obj);
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    @Override
    public boolean isValid() {
        return this.entity != null && !this.entity.field_70128_L;
    }

    @Override
    public UUID getID() {
        return this.entity.func_110124_au();
    }

    @Override
    public String getName() {
        return this.entity.func_70005_c_();
    }

    @Override
    public AWrapperWorld getWorld() {
        return WrapperWorld.getWrapperFor(this.entity.field_70170_p);
    }

    @Override
    public AEntityB_Existing getEntityRiding() {
        AEntityB_Existing entityRiding;
        if (this.cachedEntityRiding != null) {
            return this.cachedEntityRiding;
        }
        Entity mcEntityRiding = this.entity.func_184187_bx();
        if (mcEntityRiding instanceof BuilderEntityLinkedSeat && (entityRiding = ((BuilderEntityLinkedSeat)mcEntityRiding).entity) != null && this.equals(entityRiding.rider)) {
            return entityRiding;
        }
        return null;
    }

    @Override
    public void setRiding(AEntityB_Existing entityToRide) {
        if (entityToRide != null) {
            AEntityB_Existing entityRiding = this.getEntityRiding();
            if (entityRiding == null) {
                if (!this.entity.field_70170_p.field_72995_K) {
                    BuilderEntityLinkedSeat seat = new BuilderEntityLinkedSeat(((WrapperWorld)entityToRide.world).world);
                    seat.loadedFromSavedNBT = true;
                    seat.func_70080_a(entityToRide.position.x, entityToRide.position.y, entityToRide.position.z, 0.0f, 0.0f);
                    seat.entity = entityToRide;
                    this.entity.field_70170_p.func_72838_d((Entity)seat);
                    this.entity.func_184205_a((Entity)seat, true);
                }
            } else {
                ((BuilderEntityLinkedSeat)this.entity.func_184187_bx()).entity = entityToRide;
            }
            this.cachedEntityRiding = entityToRide;
        } else {
            this.entity.func_184210_p();
            this.cachedEntityRiding = null;
        }
    }

    @Override
    public double getVerticalScale() {
        PartSeat seat;
        AEntityB_Existing riding = this.getEntityRiding();
        if (riding instanceof PartSeat && (seat = (PartSeat)riding) != null) {
            if (seat.placementDefinition.playerScale != null) {
                if (((JSONPart)seat.definition).seat.playerScale != null) {
                    return seat.scale.y * seat.placementDefinition.playerScale.y * ((JSONPart)seat.definition).seat.playerScale.y;
                }
                return seat.scale.y * seat.placementDefinition.playerScale.y;
            }
            if (((JSONPart)seat.definition).seat.playerScale != null) {
                return seat.scale.y * ((JSONPart)seat.definition).seat.playerScale.y;
            }
            return seat.scale.y;
        }
        return 1.0;
    }

    @Override
    public double getSeatOffset() {
        return 0.0;
    }

    @Override
    public double getEyeHeight() {
        return this.entity.func_70047_e();
    }

    @Override
    public Point3D getPosition() {
        this.mutablePosition.set(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        return this.mutablePosition;
    }

    @Override
    public Point3D getEyePosition() {
        AEntityB_Existing riding = this.getEntityRiding();
        return riding != null ? riding.riderEyePosition : this.getPosition().add(0.0, this.getEyeHeight() + this.getSeatOffset(), 0.0);
    }

    @Override
    public Point3D getHeadPosition() {
        AEntityB_Existing riding = this.getEntityRiding();
        return riding != null ? riding.riderHeadPosition : this.getPosition().add(0.0, this.getEyeHeight() + this.getSeatOffset(), 0.0);
    }

    @Override
    public void setPosition(Point3D position, boolean onGround) {
        if (this.cachedEntityRiding != null) {
            this.entity.func_70107_b(position.x, position.y + this.getSeatOffset(), position.z);
        } else {
            this.entity.func_70107_b(position.x, position.y, position.z);
        }
        this.entity.field_70143_R = 0.0f;
        this.entity.field_70122_E = onGround;
    }

    @Override
    public Point3D getVelocity() {
        this.mutableVelocity.set(this.entity.field_70159_w, this.entity.field_70122_E ? 0.0 : this.entity.field_70181_x, this.entity.field_70179_y);
        return this.mutableVelocity;
    }

    @Override
    public void setVelocity(Point3D motion) {
        this.entity.field_70159_w = motion.x;
        this.entity.field_70181_x = motion.y;
        this.entity.field_70179_y = motion.z;
    }

    @Override
    public RotationMatrix getOrientation() {
        if (this.lastPitchChecked != this.entity.field_70125_A || this.lastYawChecked != this.entity.field_70177_z) {
            this.lastPitchChecked = this.entity.field_70125_A;
            this.lastYawChecked = this.entity.field_70177_z;
            this.mutableOrientation.angles.set(this.entity.field_70125_A, -this.entity.field_70177_z, 0.0);
            this.mutableOrientation.setToAngles(this.mutableOrientation.angles);
        }
        return this.mutableOrientation;
    }

    @Override
    public void setOrientation(RotationMatrix rotation) {
        if (this.entity.field_70170_p.field_72995_K) {
            float yawDelta = ((float)(-rotation.angles.y) - this.lastYawApplied) % 360.0f;
            if (yawDelta > 180.0f) {
                yawDelta -= 360.0f;
            } else if (yawDelta < -180.0f) {
                yawDelta -= 360.0f;
            }
            this.lastYawApplied = this.entity.field_70177_z = this.lastYawApplied + yawDelta;
        } else {
            this.entity.field_70177_z = (float)(-rotation.angles.y);
        }
        this.entity.field_70125_A = (float)rotation.angles.x;
    }

    @Override
    public float getPitch() {
        return this.entity.field_70125_A;
    }

    @Override
    public float getPitchDelta() {
        float value = this.entity.field_70125_A - this.lastPitch;
        this.lastPitch = this.entity.field_70125_A;
        return value;
    }

    @Override
    public float getYaw() {
        return -this.entity.field_70177_z;
    }

    @Override
    public float getYawDelta() {
        float value = this.entity.field_70177_z - this.lastYaw;
        this.lastYaw = this.entity.field_70177_z;
        return -value;
    }

    @Override
    public float getBodyYaw() {
        return this.entity instanceof EntityLivingBase ? -((EntityLivingBase)this.entity).field_70761_aq : 0.0f;
    }

    @Override
    public Point3D getLineOfSight(double distance) {
        this.mutableSight.set(0.0, 0.0, distance).rotate(this.getOrientation());
        return this.mutableSight;
    }

    @Override
    public void setYaw(double yaw) {
        this.entity.field_70177_z = (float)(-yaw);
    }

    @Override
    public void setBodyYaw(double yaw) {
        if (this.entity instanceof EntityLivingBase) {
            this.entity.func_181013_g((float)(-yaw));
        }
    }

    @Override
    public void setPitch(double pitch) {
        this.entity.field_70125_A = (float)pitch;
    }

    @Override
    public BoundingBox getBounds() {
        this.mutableBounds.widthRadius = this.entity.field_70130_N / 2.0f;
        this.mutableBounds.heightRadius = this.entity.field_70131_O / 2.0f;
        this.mutableBounds.depthRadius = this.entity.field_70130_N / 2.0f;
        this.mutableBounds.globalCenter.set(this.entity.field_70165_t, this.entity.field_70163_u + this.mutableBounds.heightRadius, this.entity.field_70161_v);
        return this.mutableBounds;
    }

    @Override
    public IWrapperNBT getData() {
        NBTTagCompound tag = new NBTTagCompound();
        this.entity.func_189511_e(tag);
        return new WrapperNBT(tag);
    }

    @Override
    public void setData(IWrapperNBT data) {
        this.entity.func_70020_e(((WrapperNBT)data).tag);
    }

    @Override
    public boolean leashTo(IWrapperPlayer player) {
        EntityPlayer mcPlayer = ((WrapperPlayer)player).player;
        if (this.entity instanceof EntityLiving) {
            ItemStack heldStack = mcPlayer.func_184614_ca();
            if (((EntityLiving)this.entity).func_184652_a(mcPlayer) && heldStack.func_77973_b() instanceof ItemLead) {
                ((EntityLiving)this.entity).func_110162_b((Entity)mcPlayer, true);
                if (!mcPlayer.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void attack(final Damage damage) {
        if (damage.language == null) {
            throw new IllegalArgumentException("ERROR: Cannot attack an entity with a damage of no type and language component!");
        }
        EntityDamageSource newSource = new EntityDamageSource(damage.language.getCurrentValue(), damage.entityResponsible != null ? ((WrapperEntity)damage.entityResponsible).entity : null){

            public ITextComponent func_151519_b(EntityLivingBase player) {
                if (damage.entityResponsible != null) {
                    return new TextComponentString(String.format(damage.language.getCurrentValue(), player.func_145748_c_().func_150254_d(), ((WrapperEntity)damage.entityResponsible).entity.func_145748_c_().func_150254_d()));
                }
                return new TextComponentString(String.format(damage.language.getCurrentValue(), player.func_145748_c_().func_150254_d()));
            }
        };
        if (damage.isFire) {
            newSource.func_76361_j();
            this.entity.func_70015_d(5);
        }
        if (damage.isWater) {
            this.entity.func_70066_B();
            return;
        }
        if (damage.isExplosion) {
            newSource.func_94540_d();
        }
        if (damage.ignoreArmor) {
            newSource.func_76348_h();
        }
        if (damage.ignoreCooldown && this.entity instanceof EntityLivingBase) {
            this.entity.field_70172_ad = 0;
        }
        if (((Boolean)ConfigSystem.settings.general.creativeDamage.value).booleanValue()) {
            newSource.func_76359_i();
        }
        this.entity.func_70097_a((DamageSource)newSource, (float)damage.amount);
        if (damage.effects != null) {
            damage.effects.forEach(effect -> this.addPotionEffect((JSONPotionEffect)effect));
        }
    }

    @Override
    public void addPotionEffect(JSONPotionEffect effect) {
        if (this.entity instanceof EntityLivingBase) {
            Potion potion = Potion.func_180142_b((String)effect.name);
            if (potion != null) {
                ((EntityLivingBase)this.entity).func_70690_d(new PotionEffect(potion, effect.duration, effect.amplifier, false, false));
            } else {
                throw new NullPointerException("Potion " + effect.name + " does not exist.");
            }
        }
    }

    @Override
    public void removePotionEffect(JSONPotionEffect effect) {
        if (this.entity instanceof EntityLivingBase) {
            Potion potion = Potion.func_180142_b((String)effect.name);
            if (potion != null) {
                ((EntityLivingBase)this.entity).func_184589_d(potion);
            } else {
                throw new NullPointerException("Potion " + effect.name + " does not exist.");
            }
        }
    }

    @SubscribeEvent
    public static void onIVWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            entityClientWrappers.keySet().removeIf(entity1 -> event.getWorld() == entity1.field_70170_p);
        } else {
            entityServerWrappers.keySet().removeIf(entity1 -> event.getWorld() == entity1.field_70170_p);
        }
    }
}

