/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.io.File;
import java.util.ArrayList;
import mcinterface1122.InterfaceClient;
import mcinterface1122.InterfaceCore;
import mcinterface1122.InterfaceInput;
import mcinterface1122.InterfacePacket;
import mcinterface1122.InterfaceRender;
import mcinterface1122.InterfaceSound;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="mts", name="Immersive Vehicles (MTS)", version="22.14.2")
public final class InterfaceLoader {
    public static final String MODID = "mts";
    public static final String MODNAME = "Immersive Vehicles (MTS)";
    public static final String MODVER = "22.14.2";
    public static final Logger LOGGER = LogManager.getLogger((String)InterfaceManager.coreModID);

    @Mod.EventHandler
    public void modConstruction(FMLConstructionEvent event) {
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String gameDirectory = event.getModConfigurationDirectory().getParent();
        if (event.getSide().isClient()) {
            new InterfaceManager(MODID, gameDirectory, new InterfaceCore(), new InterfacePacket(), new InterfaceClient(), new InterfaceInput(), new InterfaceSound(), new InterfaceRender());
        } else {
            new InterfaceManager(MODID, gameDirectory, new InterfaceCore(), new InterfacePacket(), null, null, null, null);
        }
        LOGGER.info("Welcome to MTS VERSION:22.14.2");
        ConfigSystem.loadFromDisk(new File(gameDirectory, "config"), event.getSide().isClient());
        ArrayList<File> packDirectories = new ArrayList<File>();
        File modDirectory = new File(gameDirectory, "mods");
        if (modDirectory.exists()) {
            packDirectories.add(modDirectory);
            File versionedModDirectory = new File(modDirectory, "1.12.2");
            if (versionedModDirectory.exists()) {
                packDirectories.add(versionedModDirectory);
            }
            PackParser.addDefaultItems();
            PackParser.parsePacks(packDirectories);
        } else {
            InterfaceManager.coreInterface.logError("Could not find mods directory!  Game directory is confirmed to: " + gameDirectory);
        }
        LanguageSystem.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        InterfacePacket.init();
        if (event.getSide().isClient()) {
            LanguageSystem.populateNames();
            InterfaceManager.inputInterface.initConfigKey();
            ConfigSystem.settings.fuel.lastLoadedFluids = InterfaceManager.clientInterface.getAllFluidNames();
            if (InterfaceManager.coreInterface.isModPresent("tails") || InterfaceManager.coreInterface.isModPresent("obfuscate") || InterfaceManager.coreInterface.isModPresent("mobends")) {
                ConfigSystem.client.renderingSettings.playerTweaks.value = false;
            }
            ConfigSystem.saveToDisk();
        }
    }
}

