/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcinterface1122.InterfaceRender;
import mcinterface1122.WrapperEntity;
import mcinterface1122.WrapperPlayer;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InterfaceEventsEntityRendering {
    public static boolean renderCurrentRiderSitting;
    public static boolean renderCurrentRiderStanding;
    private static boolean needPlayerTweaks;
    private static boolean needToPopMatrix;
    private static ItemStack heldStackHolder;
    private static final Set<EntityPlayer> playersOverwritten;
    private static final Point3D leftArmAngles;
    private static final Point3D rightArmAngles;
    private static final Point3D entityScale;
    private static final RotationMatrix riderBodyOrientation;
    private static final TransformationMatrix riderTotalTransformation;
    private static final Point3D playerPosition;
    private static final Point3D playerPrevPosition;
    private static final Point3D playerPositionHelper;
    private static final Point3D cameraAdjustedPosition;
    private static final RotationMatrix cameraAdjustedOrientation;
    private static final TransformationMatrix cameraAdjustments;
    private static int lastScreenWidth;
    private static int lastScreenHeight;
    private static float lastRiderYawHead;
    private static float lastRiderPrevYawHead;
    private static float lastRiderPitch;
    private static float lastRiderPrevPitch;

    @SubscribeEvent
    public static void onIVCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        if (event.getEntity() instanceof EntityPlayer) {
            WrapperPlayer player = WrapperPlayer.getWrapperFor((EntityPlayer)event.getEntity());
            cameraAdjustedPosition.set(0.0, 0.0, 0.0);
            cameraAdjustedOrientation.setToZero();
            if (CameraSystem.adjustCamera(player, cameraAdjustedPosition, cameraAdjustedOrientation, (float)event.getRenderPartialTicks())) {
                EntityPlayer mcPlayer = player.player;
                playerPosition.set(mcPlayer.field_70165_t, mcPlayer.field_70163_u, mcPlayer.field_70161_v);
                playerPrevPosition.set(mcPlayer.field_70169_q, mcPlayer.field_70167_r, mcPlayer.field_70166_s);
                playerPositionHelper.set(playerPrevPosition).interpolate(playerPosition, event.getRenderPartialTicks());
                InterfaceEventsEntityRendering.playerPositionHelper.y += player.getEyeHeight();
                double temp = InterfaceEventsEntityRendering.cameraAdjustedOrientation.m01;
                InterfaceEventsEntityRendering.cameraAdjustedOrientation.m01 = InterfaceEventsEntityRendering.cameraAdjustedOrientation.m10;
                InterfaceEventsEntityRendering.cameraAdjustedOrientation.m10 = temp;
                temp = InterfaceEventsEntityRendering.cameraAdjustedOrientation.m02;
                InterfaceEventsEntityRendering.cameraAdjustedOrientation.m02 = InterfaceEventsEntityRendering.cameraAdjustedOrientation.m20;
                InterfaceEventsEntityRendering.cameraAdjustedOrientation.m20 = temp;
                temp = InterfaceEventsEntityRendering.cameraAdjustedOrientation.m12;
                InterfaceEventsEntityRendering.cameraAdjustedOrientation.m12 = InterfaceEventsEntityRendering.cameraAdjustedOrientation.m21;
                InterfaceEventsEntityRendering.cameraAdjustedOrientation.m21 = temp;
                cameraAdjustments.resetTransforms();
                cameraAdjustments.rotateY(180.0);
                cameraAdjustments.multiply(cameraAdjustedOrientation);
                InterfaceRender.applyTransformOpenGL(cameraAdjustments);
                cameraAdjustedPosition.subtract(playerPositionHelper).invert();
                GL11.glTranslated((double)InterfaceEventsEntityRendering.cameraAdjustedPosition.x, (double)InterfaceEventsEntityRendering.cameraAdjustedPosition.y, (double)InterfaceEventsEntityRendering.cameraAdjustedPosition.z);
                event.setYaw(0.0f);
                event.setPitch(0.0f);
                event.setRoll(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onIVRenderOverlayPre(RenderGameOverlayEvent.Pre event) {
        IWrapperPlayer player;
        AEntityB_Existing ridingEntity;
        if ((event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS || event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) && CameraSystem.customCameraOverlay != null) {
            event.setCanceled(true);
            return;
        }
        if ((event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR || event.getType() == RenderGameOverlayEvent.ElementType.FOOD || event.getType() == RenderGameOverlayEvent.ElementType.HEALTH || event.getType() == RenderGameOverlayEvent.ElementType.ARMOR || event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) && (InterfaceManager.clientInterface.inFirstPerson() ? (Boolean)ConfigSystem.client.renderingSettings.renderHUD_1P.value : (Boolean)ConfigSystem.client.renderingSettings.renderHUD_3P.value).booleanValue() && (ridingEntity = (player = InterfaceManager.clientInterface.getClientPlayer()).getEntityRiding()) instanceof PartSeat && ((PartSeat)ridingEntity).placementDefinition.isController) {
            event.setCanceled(true);
            return;
        }
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CHAT)) {
            boolean updateGUIs;
            long displaySize = InterfaceManager.clientInterface.getPackedDisplaySize();
            int screenWidth = (int)(displaySize >> 32);
            int screenHeight = (int)displaySize;
            int mouseX = Mouse.getX() * screenWidth / Minecraft.func_71410_x().field_71443_c;
            int mouseY = screenHeight - Mouse.getY() * screenHeight / Minecraft.func_71410_x().field_71440_d - 1;
            float partialTicks = event.getPartialTicks();
            boolean bl = updateGUIs = screenWidth != lastScreenWidth || screenHeight != lastScreenHeight;
            if (updateGUIs) {
                lastScreenWidth = screenWidth;
                lastScreenHeight = screenHeight;
            }
            InterfaceRender.renderGUI(mouseX, mouseY, screenWidth, screenHeight, partialTicks, updateGUIs);
        }
    }

    @SubscribeEvent
    public static void onIVRenderLivingPre(RenderLivingEvent.Pre event) {
        needPlayerTweaks = false;
        needToPopMatrix = false;
        renderCurrentRiderSitting = false;
        renderCurrentRiderStanding = false;
        leftArmAngles.set(0.0, 0.0, 0.0);
        rightArmAngles.set(0.0, 0.0, 0.0);
        EntityLivingBase entity = event.getEntity();
        WrapperEntity entityWrapper = WrapperEntity.getWrapperFor((Entity)entity);
        AEntityB_Existing ridingEntity = entityWrapper.getEntityRiding();
        if (ridingEntity != null) {
            GL11.glPushMatrix();
            ridingEntity.getInterpolatedOrientation(riderBodyOrientation, event.getPartialRenderTick());
            riderBodyOrientation.convertToAngles();
            if (ridingEntity instanceof PartSeat) {
                PartSeat seat = (PartSeat)ridingEntity;
                entityScale.set(seat.riderScale);
                if (((JSONPart)seat.definition).seat.playerScale != null) {
                    entityScale.multiply(((JSONPart)seat.definition).seat.playerScale);
                }
                if (seat.placementDefinition.playerScale != null) {
                    entityScale.multiply(seat.placementDefinition.playerScale);
                }
                if (((JSONPart)seat.definition).seat.standing) {
                    renderCurrentRiderStanding = true;
                } else {
                    renderCurrentRiderSitting = true;
                }
                if (seat.vehicleOn != null && seat.placementDefinition.isController) {
                    double turningAngle = seat.vehicleOn.rudderInput / 2.0;
                    rightArmAngles.set(Math.toRadians(-75.0 + turningAngle), Math.toRadians(-10.0), 0.0);
                    leftArmAngles.set(Math.toRadians(-75.0 - turningAngle), Math.toRadians(10.0), 0.0);
                }
            } else {
                renderCurrentRiderSitting = true;
                entityScale.set(1.0, 1.0, 1.0);
            }
            lastRiderYawHead = entity.field_70759_as;
            lastRiderPrevYawHead = entity.field_70758_at;
            lastRiderPitch = entity.field_70125_A;
            lastRiderPrevPitch = entity.field_70127_C;
            entity.field_70758_at = entity.field_70759_as = (float)(-ridingEntity.riderRelativeOrientation.convertToAngles().y);
            entity.field_70127_C = entity.field_70125_A = (float)ridingEntity.riderRelativeOrientation.angles.x;
            entity.field_70761_aq = 0.0f;
            entity.field_70760_ar = 0.0f;
            Entity cameraEntity = Minecraft.func_71410_x().func_175606_aa();
            if (cameraEntity != null) {
                Point3D deltaDistance = new Point3D(entity.field_70142_S - cameraEntity.field_70142_S + (entity.field_70165_t - entity.field_70142_S - (cameraEntity.field_70165_t - cameraEntity.field_70142_S)) * (double)event.getPartialRenderTick(), entity.field_70137_T - cameraEntity.field_70137_T + (entity.field_70163_u - entity.field_70137_T - (cameraEntity.field_70163_u - cameraEntity.field_70137_T)) * (double)event.getPartialRenderTick(), entity.field_70136_U - cameraEntity.field_70136_U + (entity.field_70161_v - entity.field_70136_U - (cameraEntity.field_70161_v - cameraEntity.field_70136_U)) * (double)event.getPartialRenderTick());
                riderTotalTransformation.resetTransforms();
                riderTotalTransformation.setTranslation(deltaDistance);
                riderTotalTransformation.applyTranslation(0.0, -entityWrapper.getSeatOffset(), 0.0);
                riderTotalTransformation.applyRotation(riderBodyOrientation);
                riderTotalTransformation.applyScaling(entityScale);
                riderTotalTransformation.applyTranslation(0.0, entityWrapper.getSeatOffset(), 0.0);
                riderTotalTransformation.applyInvertedTranslation(deltaDistance);
                InterfaceRender.applyTransformOpenGL(riderTotalTransformation);
            }
            needToPopMatrix = true;
            if (((Boolean)ConfigSystem.client.renderingSettings.playerTweaks.value).booleanValue()) {
                needPlayerTweaks = true;
            }
        }
        if (entity instanceof EntityPlayer && ((Boolean)ConfigSystem.client.renderingSettings.playerTweaks.value).booleanValue()) {
            boolean setModelToDefault;
            EntityPlayer player = (EntityPlayer)entity;
            EntityPlayerGun gunEntity = EntityPlayerGun.playerClientGuns.get(entity.func_110124_au());
            if (gunEntity != null && gunEntity.activeGun != null) {
                Point3D heldVector = gunEntity.activeGun.isHandHeldGunAimed ? ((JSONPart)gunEntity.activeGun.definition).gun.handHeldAimedOffset : ((JSONPart)gunEntity.activeGun.definition).gun.handHeldNormalOffset;
                double heldVectorLength = heldVector.length();
                double armPitchOffset = Math.toRadians(-90.0f + entity.field_70125_A) - Math.asin(heldVector.y / heldVectorLength);
                double armYawOffset = -Math.atan2(heldVector.x / heldVectorLength, heldVector.z / heldVectorLength);
                if (WrapperPlayer.getWrapperFor(player).isRightHanded()) {
                    rightArmAngles.set(armPitchOffset, armYawOffset + Math.toRadians(entity.field_70759_as - entity.field_70761_aq), 0.0);
                } else {
                    leftArmAngles.set(armPitchOffset, -armYawOffset + Math.toRadians(entity.field_70759_as - entity.field_70761_aq), 0.0);
                }
                if (gunEntity.activeGun.isHandHeldGunAimed || gunEntity.activeGun.currentIsTwoHandedness != 0.0f) {
                    heldVector = heldVector.copy();
                    heldVector.x = 0.625 - heldVector.x;
                    heldVectorLength = heldVector.length();
                    armPitchOffset = Math.toRadians(-90.0f + entity.field_70125_A) - Math.asin(heldVector.y / heldVectorLength);
                    armYawOffset = -Math.atan2(heldVector.x / heldVectorLength, heldVector.z / heldVectorLength);
                    if (WrapperPlayer.getWrapperFor(player).isRightHanded()) {
                        leftArmAngles.set(armPitchOffset, -armYawOffset + Math.toRadians(entity.field_70759_as - entity.field_70761_aq), 0.0);
                    } else {
                        rightArmAngles.set(armPitchOffset, armYawOffset + Math.toRadians(entity.field_70759_as - entity.field_70761_aq), 0.0);
                    }
                }
                heldStackHolder = player.func_184614_ca();
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                needPlayerTweaks = true;
            }
            boolean overwrotePlayerModel = playersOverwritten.contains(player);
            boolean setModelToCustom = (Boolean)ConfigSystem.client.renderingSettings.playerTweaks.value != false && needPlayerTweaks && !overwrotePlayerModel;
            boolean bl = setModelToDefault = ((Boolean)ConfigSystem.client.renderingSettings.playerTweaks.value == false || !needPlayerTweaks) && overwrotePlayerModel;
            if (setModelToCustom || setModelToDefault) {
                for (Field renderManagerField : RenderManager.class.getDeclaredFields()) {
                    if (!renderManagerField.getName().equals("skinMap") && !renderManagerField.getName().equals("field_178636_l")) continue;
                    try {
                        if (!renderManagerField.isAccessible()) {
                            renderManagerField.setAccessible(true);
                        }
                        Map skinMap = (Map)renderManagerField.get(Minecraft.func_71410_x().func_175598_ae());
                        ArrayList skinTypes = new ArrayList(skinMap.keySet());
                        for (String skinType : skinTypes) {
                            RenderPlayer render = (RenderPlayer)skinMap.get(skinType);
                            for (Field field : RenderLivingBase.class.getDeclaredFields()) {
                                if (!field.getName().equals("mainModel") && !field.getName().equals("field_77045_g")) continue;
                                try {
                                    if (!field.isAccessible()) {
                                        field.setAccessible(true);
                                    }
                                    if (setModelToCustom) {
                                        playersOverwritten.add(player);
                                        field.set(render, (Object)new ModelPlayerCustom((ModelPlayer)field.get(render), skinType.equals("slim")));
                                        continue;
                                    }
                                    playersOverwritten.remove(player);
                                    field.set(render, ((ModelPlayerCustom)((Object)field.get(render))).base);
                                }
                                catch (Exception e) {
                                    ConfigSystem.client.renderingSettings.playerTweaks.value = false;
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        ConfigSystem.client.renderingSettings.playerTweaks.value = false;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onIVRenderLivingPost(RenderLivingEvent.Post event) {
        if (needToPopMatrix) {
            GL11.glPopMatrix();
            EntityLivingBase entity = event.getEntity();
            entity.field_70759_as = lastRiderYawHead;
            entity.field_70758_at = lastRiderPrevYawHead;
            entity.field_70125_A = lastRiderPitch;
            entity.field_70127_C = lastRiderPrevPitch;
        }
        if (heldStackHolder != null) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, heldStackHolder);
            heldStackHolder = null;
        }
    }

    @SubscribeEvent
    public static void onIVRenderHand(RenderHandEvent event) {
        EntityPlayerGun entity = EntityPlayerGun.playerClientGuns.get(Minecraft.func_71410_x().field_71439_g.func_110124_au());
        if (entity != null && entity.activeGun != null || CameraSystem.runningCustomCameras) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onIVrenderSpecificHand(RenderSpecificHandEvent event) {
        EntityPlayerGun entity = EntityPlayerGun.playerClientGuns.get(Minecraft.func_71410_x().field_71439_g.func_110124_au());
        if (entity != null && entity.activeGun != null || CameraSystem.runningCustomCameras) {
            event.setCanceled(true);
        }
    }

    static {
        needPlayerTweaks = false;
        needToPopMatrix = false;
        heldStackHolder = null;
        playersOverwritten = new HashSet<EntityPlayer>();
        leftArmAngles = new Point3D();
        rightArmAngles = new Point3D();
        entityScale = new Point3D();
        riderBodyOrientation = new RotationMatrix();
        riderTotalTransformation = new TransformationMatrix();
        playerPosition = new Point3D();
        playerPrevPosition = new Point3D();
        playerPositionHelper = new Point3D();
        cameraAdjustedPosition = new Point3D();
        cameraAdjustedOrientation = new RotationMatrix();
        cameraAdjustments = new TransformationMatrix();
    }

    private static class ModelPlayerCustom
    extends ModelPlayer {
        private final ModelPlayer base;

        private ModelPlayerCustom(ModelPlayer base, boolean smallArms) {
            super(0.0f, smallArms);
            this.base = base;
        }

        public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
            super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
            if (needPlayerTweaks) {
                if (renderCurrentRiderSitting) {
                    this.field_178722_k.field_78795_f = (float)Math.toRadians(-90.0);
                    this.field_178722_k.field_78796_g = 0.0f;
                    this.field_178722_k.field_78808_h = 0.0f;
                    ModelPlayerCustom.func_178685_a((ModelRenderer)this.field_178722_k, (ModelRenderer)this.field_178733_c);
                    this.field_178721_j.field_78795_f = (float)Math.toRadians(-90.0);
                    this.field_178721_j.field_78796_g = 0.0f;
                    this.field_178721_j.field_78808_h = 0.0f;
                    ModelPlayerCustom.func_178685_a((ModelRenderer)this.field_178721_j, (ModelRenderer)this.field_178731_d);
                } else if (renderCurrentRiderStanding) {
                    this.field_178722_k.field_78795_f = 0.0f;
                    this.field_178722_k.field_78796_g = 0.0f;
                    this.field_178722_k.field_78808_h = 0.0f;
                    ModelPlayerCustom.func_178685_a((ModelRenderer)this.field_178722_k, (ModelRenderer)this.field_178733_c);
                    this.field_178721_j.field_78795_f = 0.0f;
                    this.field_178721_j.field_78796_g = 0.0f;
                    this.field_178721_j.field_78808_h = 0.0f;
                    ModelPlayerCustom.func_178685_a((ModelRenderer)this.field_178721_j, (ModelRenderer)this.field_178731_d);
                }
                this.field_178724_i.field_78795_f = (float)leftArmAngles.x;
                this.field_178724_i.field_78796_g = (float)leftArmAngles.y;
                this.field_178724_i.field_78808_h = (float)leftArmAngles.z;
                ModelPlayerCustom.func_178685_a((ModelRenderer)this.field_178724_i, (ModelRenderer)this.field_178734_a);
                this.field_178723_h.field_78795_f = (float)rightArmAngles.x;
                this.field_178723_h.field_78796_g = (float)rightArmAngles.y;
                this.field_178723_h.field_78808_h = (float)rightArmAngles.z;
                ModelPlayerCustom.func_178685_a((ModelRenderer)this.field_178723_h, (ModelRenderer)this.field_178732_b);
            }
        }
    }
}

