/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.jimphysics;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TyreSize {
    public static final Pattern numPattern = Pattern.compile("\\d+");
    public static final Matcher numMatcher = numPattern.matcher("");
    public String sizeString;
    public double width;
    public double diameter;
    public double radius;
    public double circumference;
    public double sideWall;

    public TyreSize(String ss) {
        this.sizeString = ss;
        numMatcher.reset(this.sizeString);
        int[] p = new int[3];
        for (int x = 0; x < 3; ++x) {
            numMatcher.find();
            p[x] = Integer.parseInt(numMatcher.group());
        }
        this.width = p[0];
        this.sideWall = (double)p[0] * ((double)p[1] / 100.0);
        this.diameter = (double)p[2] * 25.4 + this.sideWall * 2.0;
        this.radius = this.diameter / 2.0;
        this.circumference = this.diameter * Math.PI;
    }

    public double toM(double mm) {
        return mm / 1000.0;
    }

    public double getRadius() {
        return this.toM(this.radius);
    }

    public double getDiamter() {
        return this.toM(this.diameter);
    }

    public double getWidth() {
        return this.toM(this.width);
    }

    public double getCircumference() {
        return this.toM(this.circumference);
    }

    public double getSideWall() {
        return this.toM(this.sideWall);
    }
}

