/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.collisions;

import com.paneedah.weaponlib.vehicle.collisions.InertiaKit;
import com.paneedah.weaponlib.vehicle.collisions.VehicleMassObject;
import com.paneedah.weaponlib.vehicle.jimphysics.Chassis;
import com.paneedah.weaponlib.vehicle.jimphysics.Dimensions;
import java.util.ArrayList;
import javax.vecmath.Matrix3f;
import net.minecraft.util.math.Vec3d;

public class VehicleInertiaBuilder {
    private Matrix3f tensor = new Matrix3f();
    private double vehicleMass = 0.0;
    private ArrayList<InertiaObject> inertiaObjectList = new ArrayList();

    public VehicleInertiaBuilder(double mass) {
        this.vehicleMass = mass;
    }

    public VehicleInertiaBuilder basicConstructor(Chassis chassis, Dimensions d) {
        switch (chassis) {
            case SEDAN: {
                return this.threeBody(d, 0.6, 0.25, 0.5, 0.25, 0.6);
            }
            case SPORT: {
                return this.threeBody(d, 0.5, 0.5, 0.35, 0.25, 0.6);
            }
            case COUPE: {
                return this.threeBody(d, 0.45, 0.275, 0.5, 0.225, 0.55);
            }
            case HATCHBACK: {
                return this.twoBody(d, 0.4, 0.3, 0.7);
            }
            case WAGON: {
                return this.twoBody(d, 0.6, 0.36, 0.74);
            }
            case SUV: {
                return this.twoBody(d, 0.4, 0.4, 0.6);
            }
            case VAN: {
                return this.twoBody(d, 0.5, 0.2, 0.8);
            }
            case TRUCK: {
                return this.threeBody(d, 0.5, 0.15, 0.3, 0.55, 0.5);
            }
        }
        return null;
    }

    public VehicleInertiaBuilder basicSedanConstruct(Vec3d d, float heightOffGround, float wheelBase, float wheelRadius, float wheelThickness) {
        return this;
    }

    public VehicleInertiaBuilder twoBody(Dimensions rd, double a, double d, double c) {
        double w = rd.width;
        this.addCube(new Vec3d(0.0, 0.0, d *= rd.length), new Dimensions(d, w, a *= rd.height), 1.0);
        this.addCube(new Vec3d(0.0, 0.0, -(c *= rd.length)), new Dimensions(c, w, 1.0 * rd.height), 1.0);
        return this;
    }

    public VehicleInertiaBuilder threeBody(Dimensions rd, double a, double d, double c, double e, double b) {
        double w = rd.width;
        this.addCube(new Vec3d(0.0, 0.0, (d *= rd.length) + (c *= rd.length) / 2.0), new Dimensions(d, w, a *= rd.height), 1.0);
        this.addCube(Vec3d.field_186680_a, new Dimensions(c, w, 1.0 * rd.height), 1.0);
        this.addCube(new Vec3d(0.0, 0.0, -d - c / 2.0), new Dimensions(e *= rd.length, w, b *= rd.height), 1.0);
        return this;
    }

    public void addWheelAssembly(int axelCount, float height, float wheelBase, float radius, float depth, float axelLen, float density) {
        for (int n = 0; n < axelCount; ++n) {
            double distAlong = this.getPosInBetween(0.0, n, axelCount);
            double posAlongBase = this.interpValue(-wheelBase / 2.0f, wheelBase / 2.0f, distAlong);
            this.addAxel(height, radius, axelLen, (float)posAlongBase, depth, density);
        }
    }

    public void addAxel(float height, float wheelRadius, float axelLen, float distForward, float wheelThickness, float density) {
        this.addCylinder(new Vec3d((double)(-axelLen / 2.0f), (double)height, (double)distForward), wheelRadius, wheelThickness, density);
        this.addCylinder(new Vec3d(0.0, (double)height, (double)distForward), wheelRadius / 3.0f, axelLen, density);
        this.addCylinder(new Vec3d((double)(axelLen / 2.0f), (double)height, (double)distForward), wheelRadius, wheelThickness, density);
    }

    public void addCube(Vec3d offset, Dimensions dim, double density) {
        double volume = dim.getVolume();
        Matrix3f tens = InertiaKit.inertiaTensorCube(1.0f, (float)dim.height, (float)dim.width, (float)dim.length);
        this.inertiaObjectList.add(new InertiaObject(offset, tens, 0.0, volume, density));
    }

    public void addCylinder(Vec3d offset, float radius, float depth, double density) {
        double volume = Math.PI * (double)radius * (double)radius * (double)depth;
        Matrix3f tens = InertiaKit.inertiaTensorCylinder(1.0f, radius, depth);
        this.inertiaObjectList.add(new InertiaObject(offset, tens, 0.0, volume, density));
    }

    public void assignMass() {
        double sum = 0.0;
        for (InertiaObject iO : this.inertiaObjectList) {
            double massFactor = iO.getMassFactor();
            sum += massFactor;
        }
        for (InertiaObject iO : this.inertiaObjectList) {
            double r = iO.getMassFactor() / sum * this.vehicleMass;
            iO.setRealMass(r);
        }
    }

    public VehicleMassObject build() {
        this.assignMass();
        Vec3d local = Vec3d.field_186680_a;
        double mass = 0.0;
        for (InertiaObject iO : this.inertiaObjectList) {
            mass += iO.mass;
            local = local.func_178787_e(iO.pos.func_186678_a(iO.mass));
        }
        double iM = 1.0 / mass;
        local = local.func_186678_a(iM);
        for (InertiaObject iO : this.inertiaObjectList) {
            Vec3d toLoc = local.func_178788_d(iO.pos);
            double dist = toLoc.func_72430_b(toLoc);
            Matrix3f oP = this.outerProduct(toLoc, toLoc);
            Matrix3f tensMat = new Matrix3f();
            tensMat.setIdentity();
            tensMat.mul((float)dist);
            tensMat.sub(oP);
            tensMat.mul((float)iO.mass);
            Matrix3f oLocalTensor = (Matrix3f)iO.tensor.clone();
            oLocalTensor.add(tensMat);
            this.tensor.add(oLocalTensor);
        }
        return new VehicleMassObject(mass, this.tensor, local);
    }

    public Matrix3f outerProduct(Vec3d one, Vec3d two) {
        Matrix3f mat = new Matrix3f((float)(one.field_72450_a * two.field_72450_a), (float)(one.field_72450_a * two.field_72448_b), (float)(one.field_72450_a * two.field_72449_c), (float)(one.field_72448_b * two.field_72450_a), (float)(one.field_72448_b * two.field_72448_b), (float)(one.field_72448_b * two.field_72449_c), (float)(one.field_72449_c * two.field_72450_a), (float)(one.field_72449_c * two.field_72448_b), (float)(one.field_72449_c * two.field_72449_c));
        return mat;
    }

    public double getPosInBetween(double start, double pos, double end) {
        return (pos - start) / (end - start);
    }

    public double interpValue(double start, double end, double mu) {
        return start + (end - start) * mu;
    }

    class InertiaObject {
        public Vec3d pos = Vec3d.field_186680_a;
        public double volume = 0.0;
        public double density = 0.0;
        public Matrix3f tensor = new Matrix3f();
        public double mass = 0.0;

        public InertiaObject(Vec3d p, Matrix3f t, double m, double volume, double density) {
            this.pos = p;
            this.tensor = t;
            this.mass = m;
            this.density = density;
            this.volume = volume;
        }

        public double getMassFactor() {
            return this.density * this.volume;
        }

        public void setRealMass(double mass) {
            this.tensor.mul((float)mass);
            this.mass = mass;
        }
    }
}

