/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.collisions;

import com.paneedah.weaponlib.vehicle.collisions.Contact;
import net.minecraft.util.math.Vec3d;

public class ContactManifold {
    public static final float CONTACT_BREAK = 0.02f;
    public static final float CONTACT_BREAK_SQ = 4.0E-4f;
    public Contact[] contacts = new Contact[4];
    public int contactCount = 0;

    public void update() {
        Contact c;
        int i;
        for (i = 0; i < this.contactCount; ++i) {
            c = this.contacts[i];
            c.globalA = c.bodyA.localToGlobalPos(c.localA);
            c.globalB = c.bodyB.localToGlobalPos(c.localB);
            this.contacts[i].depth = (float)c.globalA.func_178788_d(c.globalB).func_72430_b(c.normal);
        }
        for (i = 0; i < this.contactCount; ++i) {
            c = this.contacts[i];
            if (c.depth > 0.02f) {
                this.removeContact(i);
                --i;
                continue;
            }
            Vec3d proj = c.globalA.func_178788_d(c.normal.func_186678_a((double)c.depth));
            double orthoDistToB = proj.func_178788_d(c.globalB).func_189985_c();
            if (!(orthoDistToB > (double)4.0E-4f)) continue;
            this.removeContact(i);
            --i;
        }
    }

    public void removeContact(int idx) {
        this.contacts[idx] = null;
        for (int i = idx; i < 3; ++i) {
            this.contacts[i] = this.contacts[i + 1];
            this.contacts[i + 1] = null;
        }
        --this.contactCount;
    }

    public boolean addContact(Contact c) {
        int idx = this.getContactIndex(c);
        boolean replace = true;
        if (idx < 0) {
            if (this.contactCount < 4) {
                idx = this.contactCount;
                replace = false;
            } else {
                idx = this.getLeastRemoteIndex(c);
            }
        }
        if (idx >= 0) {
            if (!replace) {
                ++this.contactCount;
            }
            this.contacts[idx] = c;
            return true;
        }
        return false;
    }

    public int getLeastRemoteIndex(Contact c) {
        Vec3d b;
        Vec3d a;
        float deepest = -3.4028235E38f;
        int deepIdx = -1;
        for (int i = 0; i < this.contactCount; ++i) {
            if (!(this.contacts[i].depth > deepest)) continue;
            deepest = this.contacts[i].depth;
            deepIdx = i;
        }
        double res0 = 0.0;
        double res1 = 0.0;
        double res2 = 0.0;
        double res3 = 0.0;
        if (deepIdx != 0) {
            a = c.localA.func_178788_d(this.contacts[1].localA);
            b = this.contacts[3].localA.func_178788_d(this.contacts[2].localA);
            res0 = a.func_72431_c(b).func_189985_c();
        }
        if (deepIdx != 1) {
            a = c.localA.func_178788_d(this.contacts[0].localA);
            b = this.contacts[3].localA.func_178788_d(this.contacts[2].localA);
            res1 = a.func_72431_c(b).func_189985_c();
        }
        if (deepIdx != 2) {
            a = c.localA.func_178788_d(this.contacts[0].localA);
            b = this.contacts[3].localA.func_178788_d(this.contacts[1].localA);
            res2 = a.func_72431_c(b).func_189985_c();
        }
        if (deepIdx != 3) {
            a = c.localA.func_178788_d(this.contacts[0].localA);
            b = this.contacts[2].localA.func_178788_d(this.contacts[1].localA);
            res3 = a.func_72431_c(b).func_189985_c();
        }
        return ContactManifold.absMaxIdx(res0, res1, res2, res3);
    }

    public static int absMaxIdx(double ... numbers) {
        int idx = 0;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < numbers.length; ++i) {
            double num = Math.abs(numbers[i]);
            if (!(num > max)) continue;
            idx = i;
            max = num;
        }
        return idx;
    }

    public int getContactIndex(Contact c) {
        int idx = -1;
        double shortestDist = 4.0E-4f;
        for (int i = 0; i < this.contactCount; ++i) {
            double dist = this.contacts[i].localA.func_178788_d(c.localA).func_189985_c();
            if (!(dist < shortestDist)) continue;
            shortestDist = dist;
            idx = i;
        }
        return idx;
    }
}

