/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.paneedah.mwc.network.NetworkPermitManager;
import com.paneedah.weaponlib.state.Aspect;
import com.paneedah.weaponlib.state.StateManager;
import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.VehicleState;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class VehicleDrivingAspect
implements Aspect<VehicleState, EntityVehicle> {
    private static final Set<VehicleState> allowedAutoUpdateFromStates = new HashSet<VehicleState>(Arrays.asList(VehicleState.IDLE, VehicleState.STARTING_TO_DRIVE, VehicleState.DRIVING, VehicleState.STARTING_TO_SHIFT, VehicleState.SHIFTING, VehicleState.FINISHING_SHIFT, VehicleState.STOPPING));
    private static Predicate<EntityVehicle> hasMinimalSpeed = vehicle -> vehicle.solver.velocity.func_72433_c() != 0.0;
    private static Predicate<EntityVehicle> movingForwardOrBackward = vehicle -> vehicle.isSteeredForward() || vehicle.isSteeredBackward();
    private static Predicate<EntityVehicle> isShifting = vehicle -> vehicle.isInShift();
    public static Predicate<EntityVehicle> shiftTime = vehicle -> System.currentTimeMillis() >= 500L + vehicle.getStateUpdateTimestamp();
    public static Predicate<EntityVehicle> isDoneShifting = vehicle -> !vehicle.solver.transmission.runningAShift;
    public static Predicate<EntityVehicle> toShiftKnobTime = vehicle -> System.currentTimeMillis() >= 50L + vehicle.getStateUpdateTimestamp();
    private static Predicate<EntityVehicle> speedupTimeoutExpired = vehicle -> System.currentTimeMillis() >= 300L + vehicle.getStateUpdateTimestamp();
    private StateManager<VehicleState, ? super EntityVehicle> stateManager;

    public VehicleDrivingAspect() {
        this.setStateManager(new StateManager((s1, s2) -> s1 == s2));
    }

    public static long timeSinceStateChange(EntityVehicle vehicle) {
        return System.currentTimeMillis() - vehicle.getStateUpdateTimestamp();
    }

    @Override
    public void setPermitManager(NetworkPermitManager permitManager) {
    }

    @Override
    public void setStateManager(StateManager<VehicleState, ? super EntityVehicle> stateManager) {
        this.stateManager = stateManager;
        stateManager.in(this).change(VehicleState.IDLE).to(VehicleState.STARTING_TO_DRIVE).when(hasMinimalSpeed.and(movingForwardOrBackward)).automatic().in(this).change(VehicleState.STARTING_TO_DRIVE).to(VehicleState.DRIVING).when(speedupTimeoutExpired).automatic().in(this).change(VehicleState.DRIVING).to(VehicleState.STOPPING).when(hasMinimalSpeed.negate()).automatic().in(this).change(VehicleState.DRIVING).to(VehicleState.STARTING_TO_SHIFT).when(isShifting).automatic().in(this).change(VehicleState.STARTING_TO_SHIFT).to(VehicleState.SHIFTING).when(toShiftKnobTime).automatic().in(this).change(VehicleState.SHIFTING).to(VehicleState.FINISHING_SHIFT).when(isDoneShifting).automatic().in(this).change(VehicleState.FINISHING_SHIFT).to(VehicleState.DRIVING).when(toShiftKnobTime).automatic().in(this).change(VehicleState.STOPPING).to(VehicleState.IDLE).when(speedupTimeoutExpired).automatic();
    }

    void onUpdate(EntityVehicle vehicle) {
        this.stateManager.changeStateFromAnyOf(this, vehicle, allowedAutoUpdateFromStates, new VehicleState[0]);
    }
}

