/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.sound;

import com.paneedah.mwc.proxies.ClientProxy;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.EFXUtil;
import org.lwjgl.util.WaveData;

public class JSoundEngine {
    IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
    IntBuffer source = BufferUtils.createIntBuffer((int)8);
    FloatBuffer sourcePos = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
    public float[] volumes = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    FloatBuffer sourceVel = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
    FloatBuffer listenerPos = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
    FloatBuffer listenerVel = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
    FloatBuffer listenerOri = BufferUtils.createFloatBuffer((int)6).put(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f});
    public static JSoundEngine instance;
    public static int auxFXSlot0;
    public static int echo0;
    public static int sendFilter0;
    public static int directFilter0;
    public HashMap<Integer, Float> volumesMap = new HashMap();
    public ArrayList<Integer> toDim = new ArrayList();
    public static float velo;
    public static long time;
    public static boolean loaded;

    public static JSoundEngine getInstance() {
        if (instance == null) {
            instance = new JSoundEngine();
        }
        return instance;
    }

    public JSoundEngine() {
        this.sourcePos.flip();
        this.sourceVel.flip();
        this.listenerPos.flip();
        this.listenerVel.flip();
        this.listenerOri.flip();
    }

    int loadALData() {
        AL10.alGenBuffers((IntBuffer)this.buffer);
        if (AL10.alGetError() != 0) {
            return 0;
        }
        ResourceLocation loc = new ResourceLocation("mwc:sounds/m4a1.wav");
        InputStream is = null;
        try {
            is = ClientProxy.MC.func_110442_L().func_110536_a(loc).func_110527_b();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        WaveData waveFile = WaveData.create((InputStream)bis);
        AL10.alBufferData((int)this.buffer.get(0), (int)waveFile.format, (ByteBuffer)waveFile.data, (int)waveFile.samplerate);
        waveFile.dispose();
        if (AL10.alGetError() != 0) {
            System.out.println("Error buffering");
            return 0;
        }
        return 1;
    }

    public int createFirstBuffer() {
        ArrayList removal = new ArrayList();
        for (int i : this.toDim) {
            if (!this.volumesMap.containsKey(i)) {
                this.volumesMap.put(i, Float.valueOf(1.0f));
            }
            this.volumesMap.put(i, Float.valueOf(this.volumesMap.get(i).floatValue() - 0.05f));
            if ((double)this.volumesMap.get(i).floatValue() < 0.0) {
                this.volumesMap.remove(i);
                continue;
            }
            AL10.alSourcef((int)this.source.get(i), (int)4106, (float)this.volumesMap.get(i).floatValue());
        }
        for (int i : removal) {
            this.toDim.remove(this.toDim.indexOf(i));
        }
        return 0;
    }

    private void addSource(int type) {
        int position = this.source.position();
        this.source.limit(position + 1);
        System.out.println(position);
        AL10.alGenSources((IntBuffer)this.source);
        if (AL10.alGetError() != 0) {
            System.out.println("Error generating audio source.");
        }
        this.toDim.add(position - 1);
        AL10.alSourcei((int)this.source.get(position), (int)4105, (int)this.buffer.get(type));
        AL10.alSourcef((int)this.source.get(position), (int)4099, (float)1.1f);
        AL10.alSourcef((int)this.source.get(position), (int)4106, (float)1.0f);
        AL10.alSource((int)this.source.get(position), (int)4100, (FloatBuffer)this.sourcePos);
        AL10.alSource((int)this.source.get(position), (int)4102, (FloatBuffer)this.sourceVel);
        AL10.alSourcei((int)this.source.get(position), (int)4103, (int)0);
        AL10.alSourcePlay((int)this.source.get(position));
        if (position + 1 != this.source.capacity()) {
            this.source.position(position + 1);
        } else {
            for (int x = 0; x < this.source.capacity() / 2; ++x) {
                this.toDim.remove(this.toDim.indexOf(x));
                AL10.alDeleteSources((int)this.source.get(x));
            }
            this.source.position(0);
        }
    }

    void setListenerValues() {
        AL10.alListener((int)4100, (FloatBuffer)this.listenerPos);
        AL10.alListener((int)4102, (FloatBuffer)this.listenerVel);
        AL10.alListener((int)4111, (FloatBuffer)this.listenerOri);
    }

    public void killALData() {
        AL10.alDeleteSources((IntBuffer)this.source);
        AL10.alDeleteBuffers((IntBuffer)this.buffer);
    }

    public void playSound() {
        if (!loaded) {
            this.source.rewind();
            this.loadALData();
            loaded = true;
        }
        this.addSource(0);
        velo = 1.0f;
    }

    public void execute() {
        AL10.alGetError();
        if (this.loadALData() == 0) {
            System.out.println("Error loading data.");
            return;
        }
        this.setListenerValues();
        AL10.alSourcePlay((int)this.source.get(0));
    }

    public static void checkSupport() {
        System.out.println("Checking supported effects ...");
        if (EFXUtil.isEffectSupported((int)0)) {
            System.out.println("AL_EFFECT_NULL is supported.");
        } else {
            System.out.println("AL_EFFECT_NULL is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)32768)) {
            System.out.println("AL_EFFECT_EAXREVERB is supported.");
        } else {
            System.out.println("AL_EFFECT_EAXREVERB is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)1)) {
            System.out.println("AL_EFFECT_REVERB is supported.");
        } else {
            System.out.println("AL_EFFECT_REVERB is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)2)) {
            System.out.println("AL_EFFECT_CHORUS is supported.");
        } else {
            System.out.println("AL_EFFECT_CHORUS is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)3)) {
            System.out.println("AL_EFFECT_DISTORTION is supported.");
        } else {
            System.out.println("AL_EFFECT_DISTORTION is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)4)) {
            System.out.println("AL_EFFECT_ECHO is supported.");
        } else {
            System.out.println("AL_EFFECT_ECHO is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)5)) {
            System.out.println("AL_EFFECT_FLANGER is supported.");
        } else {
            System.out.println("AL_EFFECT_FLANGER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)6)) {
            System.out.println("AL_EFFECT_FREQUENCY_SHIFTER is supported.");
        } else {
            System.out.println("AL_EFFECT_FREQUENCY_SHIFTER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)7)) {
            System.out.println("AL_EFFECT_VOCAL_MORPHER is supported.");
        } else {
            System.out.println("AL_EFFECT_VOCAL_MORPHER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)8)) {
            System.out.println("AL_EFFECT_PITCH_SHIFTER is supported.");
        } else {
            System.out.println("AL_EFFECT_PITCH_SHIFTER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)9)) {
            System.out.println("AL_EFFECT_RING_MODULATOR is supported.");
        } else {
            System.out.println("AL_EFFECT_RING_MODULATOR is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)10)) {
            System.out.println("AL_EFFECT_AUTOWAH is supported.");
        } else {
            System.out.println("AL_EFFECT_AUTOWAH is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)11)) {
            System.out.println("AL_EFFECT_COMPRESSOR is supported.");
        } else {
            System.out.println("AL_EFFECT_COMPRESSOR is NOT supported.");
        }
        if (EFXUtil.isEffectSupported((int)12)) {
            System.out.println("AL_EFFECT_EQUALIZER is supported.");
        } else {
            System.out.println("AL_EFFECT_EQUALIZER is NOT supported.");
        }
        System.out.println();
        System.out.println("Checking supported filters ...");
        if (EFXUtil.isFilterSupported((int)0)) {
            System.out.println("AL_FILTER_NULL is supported.");
        } else {
            System.out.println("AL_FILTER_NULL is NOT supported.");
        }
        if (EFXUtil.isFilterSupported((int)1)) {
            System.out.println("AL_FILTER_LOWPASS is supported.");
        } else {
            System.out.println("AL_FILTER_LOWPASS is NOT supported.");
        }
        if (EFXUtil.isFilterSupported((int)2)) {
            System.out.println("AL_FILTER_HIGHPASS is supported.");
        } else {
            System.out.println("AL_FILTER_HIGHPASS is NOT supported.");
        }
        if (EFXUtil.isFilterSupported((int)3)) {
            System.out.println("AL_FILTER_BANDPASS is supported.");
        } else {
            System.out.println("AL_FILTER_BANDPASS is NOT supported.");
        }
    }

    public static void main(String[] args) {
        new JSoundEngine().execute();
    }

    public String getALErrorString(int err) {
        switch (err) {
            case 0: {
                return "AL_NO_ERROR";
            }
            case 40961: {
                return "AL_INVALID_NAME";
            }
            case 40962: {
                return "AL_INVALID_ENUM";
            }
            case 40963: {
                return "AL_INVALID_VALUE";
            }
            case 40964: {
                return "AL_INVALID_OPERATION";
            }
            case 40965: {
                return "AL_OUT_OF_MEMORY";
            }
        }
        return "No such error code";
    }

    static {
        velo = 0.0f;
        time = System.currentTimeMillis();
        loaded = false;
    }
}

