/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render.cam;

import com.paneedah.weaponlib.numerical.SpringValue;
import net.minecraft.util.math.Vec3d;

public class ShockVector {
    private SpringValue x = new SpringValue(0.0, 0.0, 0.0);
    private SpringValue y = new SpringValue(0.0, 0.0, 0.0);
    private SpringValue z = new SpringValue(0.0, 0.0, 0.0);

    public void configure(double dampening, double mass, double k) {
        this.x.configure(k, mass, dampening);
        this.y.configure(k, mass, dampening);
        this.z.configure(k, mass, dampening);
    }

    public void update(double dt) {
        this.x.update(dt);
        this.y.update(dt);
        this.z.update(dt);
    }

    public void applyForce(double forceX, double forceY, double forceZ) {
        this.x.setVelocity(this.x.getVelocity() + forceX);
        this.y.setVelocity(this.y.getVelocity() + forceY);
        this.z.setVelocity(this.z.getVelocity() + forceZ);
    }

    public Vec3d getShockVector() {
        return new Vec3d(this.x.getPosition(), this.y.getPosition(), this.z.getPosition());
    }
}

