/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.render.bgl.GLCompatible;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;

public class DepthTexture {
    private int buffer = -1;
    private int texture = -1;
    private int width;
    private int height;

    public DepthTexture(int width, int height) {
        this.width = width;
        this.height = height;
        this.createDepthTexture();
    }

    public boolean shouldRecreate(int newWidth, int newHeight) {
        return newWidth != this.width || newHeight != this.height;
    }

    public void recreateBuffer(int newWidth, int newHeight) {
        if (this.shouldRecreate(newWidth, newHeight)) {
            this.width = newWidth;
            this.height = newHeight;
            this.createDepthTexture();
        }
    }

    protected void createDepthTexture() {
        if (this.buffer != -1) {
            OpenGlHelper.func_153174_h((int)this.buffer);
        }
        if (this.texture == -1) {
            this.texture = GL11.glGenTextures();
        }
        this.buffer = OpenGlHelper.func_153165_e();
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.buffer);
        GlStateManager.func_179144_i((int)this.texture);
        GL11.glTexImage2D((int)3553, (int)0, (int)GLCompatible.GL_DEPTH_COMPONENT24, (int)this.width, (int)this.height, (int)0, (int)6402, (int)5126, (FloatBuffer)null);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)33071);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)33071);
        OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)3553, (int)this.texture, (int)0);
        this.checkFramebufferStatus();
    }

    public void blitOn(Framebuffer source, boolean rebind) {
        this.blitOn(source.field_147616_f, source.field_147621_c, source.field_147618_d, rebind);
    }

    public void blitOn(int srcBuf, int srcW, int srcH, boolean rebind) {
        OpenGlHelper.func_153171_g((int)GLCompatible.GL_READ_FRAMEBUFFER, (int)srcBuf);
        OpenGlHelper.func_153171_g((int)GLCompatible.GL_DRAW_FRAMEBUFFER, (int)this.getBuffer());
        GLCompatible.glBlitFramebuffer(0, 0, srcW, srcH, 0, 0, this.getWidth(), this.getHeight(), 256, 9728);
        this.safeBindFramebuffer(srcBuf);
    }

    private void safeBindFramebuffer(int buf) {
        if (OpenGlHelper.func_148822_b()) {
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)buf);
        }
    }

    private void checkFramebufferStatus() {
        int status = OpenGlHelper.func_153167_i((int)OpenGlHelper.field_153198_e);
        if (status != OpenGlHelper.field_153202_i) {
            if (status == OpenGlHelper.field_153203_j) {
                ModReference.LOG.error("Depth framebuffer creation returned an incomplete attachment error.");
            } else if (status == OpenGlHelper.field_153204_k) {
                ModReference.LOG.error("Depth framebuffer creation returned a missing attachment error.");
            } else if (status == OpenGlHelper.field_153205_l) {
                ModReference.LOG.error("Depth framebuffer creation returned an incomplete draw buffer error.");
            } else if (status == OpenGlHelper.field_153206_m) {
                ModReference.LOG.error("Depth framebuffer creation returned an incomplete read buffer error.");
            } else {
                ModReference.LOG.error("Depth framebuffer creation returned an unknown status");
            }
        } else {
            ModReference.LOG.debug("Succesfully created depth buffer.");
        }
    }

    public int getTexture() {
        return this.texture;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

