/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.perspective;

import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.ItemScope;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.RenderableState;
import com.paneedah.weaponlib.perspective.FirstPersonPerspective;
import com.paneedah.weaponlib.perspective.PerspectiveManager;
import com.paneedah.weaponlib.shader.jim.Attribute;
import com.paneedah.weaponlib.shader.jim.Shader;
import com.paneedah.weaponlib.shader.jim.ShaderLoader;
import com.paneedah.weaponlib.shader.jim.Uniform;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class OpticalScopePerspective
extends FirstPersonPerspective<RenderableState> {
    private static final int DEFAULT_WIDTH = 200;
    private static final int DEFAULT_HEIGHT = 200;
    public static final FloatBuffer AUX_GL_BUFFER = GLAllocation.func_74529_h((int)16);
    public static final Uniform PROJECTION_MATRIX = shader -> {
        GL11.glGetFloat((int)2983, (FloatBuffer)AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        GL20.glUniformMatrix4((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"projection"), (boolean)false, (FloatBuffer)AUX_GL_BUFFER);
    };
    public static Shader scope = ShaderLoader.loadShader("vignette", new Attribute[0]).withUniforms(PROJECTION_MATRIX);

    public OpticalScopePerspective() {
        this.width = 200;
        this.height = 200;
    }

    @Override
    public void activate(ClientModContext modContext, PerspectiveManager manager) {
        ItemScope scope;
        PlayerWeaponInstance instance = modContext.getMainHeldWeapon();
        if (instance != null && (scope = instance.getScope()).isOptical()) {
            this.setSize(scope.getWidth(), scope.getHeight());
        }
        super.activate(modContext, manager);
    }

    @Override
    public float getBrightness(RenderContext<RenderableState> renderContext) {
        float brightness = 0.0f;
        PlayerWeaponInstance instance = renderContext.getWeaponInstance();
        if (instance == null) {
            return 0.0f;
        }
        boolean aimed = instance != null && instance.isAimed();
        float progress = Math.min(1.0f, renderContext.getTransitionProgress());
        if (OpticalScopePerspective.isAimingState(renderContext.getFromState()) && OpticalScopePerspective.isAimingState(renderContext.getToState())) {
            brightness = 1.0f;
        } else if (progress > 0.0f && aimed && OpticalScopePerspective.isAimingState(renderContext.getToState())) {
            brightness = progress;
        } else if (OpticalScopePerspective.isAimingState(renderContext.getFromState()) && progress > 0.0f && !aimed) {
            brightness = Math.max(1.0f - progress, 0.0f);
        }
        return brightness;
    }

    private static boolean isAimingState(RenderableState renderableState) {
        return renderableState == RenderableState.ZOOMING || renderableState == RenderableState.ZOOMING_RECOILED || renderableState == RenderableState.ZOOMING_SHOOTING;
    }

    @Override
    public void update(TickEvent.RenderTickEvent event) {
        PlayerWeaponInstance instance = this.modContext.getMainHeldWeapon();
        if (instance != null && instance.isAimed()) {
            ItemScope scope = instance.getScope();
            if (scope.isOptical()) {
                this.setSize(scope.getWidth(), scope.getHeight());
            }
            super.update(event);
        }
    }

    @Override
    protected void prepareRenderWorld(TickEvent.RenderTickEvent event) {
        boolean reload = false;
        if (reload) {
            scope = ShaderLoader.loadShader("vignette", new Attribute[0]);
        }
    }

    @Override
    protected void postRenderWorld(TickEvent.RenderTickEvent event) {
    }
}

