/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.command;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.BalancePackClientMessage;
import com.paneedah.weaponlib.command.TidyCompatibleCommand;
import com.paneedah.weaponlib.config.BalancePackManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.IOUtils;

public class BalancePackCommand
extends TidyCompatibleCommand {
    private static final String PASTEBIN_LINK_START = "https://pastebin.com/raw/";
    private static final String INFO_KEY = "info";
    private static final String LIST_KEY = "list";
    private static final String LOAD_KEY = "load";
    private static final String UNLOAD_KEY = "unload";
    private static final String GENERATE_KEY = "generate";
    private static final String DOWNLOAD_KEY = "download";
    private static final String PASTEBIN_KEY = "pastebin";
    private static final String RAW_KEY = "raw";

    public BalancePackCommand() {
        super("balancepack", "Balance Pack Manager " + BalancePackManager.getPackManagerVersion());
        this.addMainOption(INFO_KEY, "Displays all balance packs in directory", new String[0]);
        this.addMainOption(LIST_KEY, "Provides info about currently loaded pack", new String[0]);
        this.addMainOption(LOAD_KEY, "Loads a balance pack", "fileName");
        this.addMainOption(UNLOAD_KEY, "Unloads the current balance pack", new String[0]);
        this.addMainOption(GENERATE_KEY, "Generates the default balance pack", new String[0]);
        this.addMainOption(DOWNLOAD_KEY, "Downloads a balance pack online from Pastebin or any other raw text viewer", "raw, pastebin", "link/pastebin code");
        this.addSubOption(DOWNLOAD_KEY, PASTEBIN_KEY, "Gives a pastebin identifier", "code/link");
        this.addSubOption(DOWNLOAD_KEY, RAW_KEY, "Gives a raw link to the identifier", "link");
        this.initCommand();
    }

    @Override
    protected void executeTidyCommand(ICommandSender sender, String mainArgument, String secondArgument, String[] args) {
        File directory = BalancePackManager.getDirectory();
        switch (mainArgument) {
            case "list": {
                this.sendFormattedMessage(sender, "Listing balance packs:");
                int counter = 1;
                for (File file : directory.listFiles()) {
                    if (file.getName().equals("index.json")) continue;
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "(" + counter++ + ") " + TextFormatting.GREEN + file.getName()));
                }
                return;
            }
            case "info": {
                if (BalancePackManager.hasActiveBalancePack()) {
                    BalancePackManager.BalancePack bp = BalancePackManager.getActiveBalancePack();
                    sender.func_145747_a((ITextComponent)new TextComponentString(this.getHeader() + " Currently loaded " + TextFormatting.RED + bp.getName() + " (" + bp.getVersion() + ")"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(this.getHeader() + " No active balance pack. Load one with " + TextFormatting.RED + "/balancepack load <filename>" + TextFormatting.WHITE + "."));
                }
                return;
            }
            case "unload": {
                if (!BalancePackManager.hasActiveBalancePack()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(this.getHeader() + " No active balance pack. Load one with " + TextFormatting.RED + "/balancepack load <filename>" + TextFormatting.WHITE + "."));
                    return;
                }
                BalancePackManager.unloadBalancePack();
                this.sendFormattedMessage(sender, "Succesfully unloaded balance pack.");
                MWC.CHANNEL.sendToAll((IMessage)new BalancePackClientMessage(BalancePackManager.getActiveBalancePack()));
                return;
            }
            case "load": {
                if (secondArgument.length() == 0) {
                    this.sendFormattedMessage(sender, "You must specify a file name!");
                    return;
                }
                for (File f : directory.listFiles()) {
                    if (!f.getName().equals(secondArgument)) continue;
                    sender.func_145747_a((ITextComponent)new TextComponentString(this.getHeader() + " Loading balance pack " + TextFormatting.RED + f.getName()));
                    BalancePackManager.loadBalancePack(sender, f.getName());
                    MWC.CHANNEL.sendToAll((IMessage)new BalancePackClientMessage(BalancePackManager.getActiveBalancePack()));
                    return;
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(this.getHeader() + " Could not find balance pack " + TextFormatting.RED + args[1]));
                return;
            }
            case "generate": {
                BalancePackManager.createDefaultBalancePack();
                sender.func_145747_a((ITextComponent)new TextComponentString(this.getHeader() + " Generated default balance pack with name " + TextFormatting.RED + "default_pack.json" + TextFormatting.WHITE + "."));
                return;
            }
            case "download": {
                String link = "";
                if (secondArgument.length() == 0) {
                    this.sendOptionHelp(sender, DOWNLOAD_KEY);
                    return;
                }
                if (secondArgument.equals(PASTEBIN_KEY)) {
                    if (args.length == 0) {
                        this.sendOptionHelp(sender, DOWNLOAD_KEY);
                        return;
                    }
                    if (secondArgument.contains("/") && !secondArgument.contains(RAW_KEY)) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(this.getHeader() + " Detected pastebin link... but you forgot to link us to the raw data!"));
                        String[] split = link.split("/");
                        link = PASTEBIN_LINK_START + split[split.length - 1];
                        sender.func_145747_a((ITextComponent)new TextComponentString(this.getHeader() + " Fixed pastebin link: " + TextFormatting.RED + link));
                    } else {
                        link = PASTEBIN_LINK_START + secondArgument;
                    }
                } else if (secondArgument.equals(RAW_KEY)) {
                    if (args.length == 0) {
                        this.sendOptionHelp(sender, DOWNLOAD_KEY);
                        return;
                    }
                    link = args[0];
                }
                this.sendFormattedMessage(sender, "Fetching balance pack from link... this could take a minute.");
                try {
                    String result = IOUtils.toString((URL)new URL(link), (Charset)StandardCharsets.UTF_8);
                    BalancePackManager.loadBalancePackFromString(sender, result);
                    MWC.CHANNEL.sendToAll((IMessage)new BalancePackClientMessage(BalancePackManager.getActiveBalancePack()));
                    break;
                }
                catch (MalformedURLException e) {
                    this.sendFormattedMessage(sender, "Failed to open URL. Malformed URL exception.");
                    break;
                }
                catch (IOException e) {
                    this.sendFormattedMessage(sender, "Failed to process URL. IOException.");
                }
            }
        }
    }
}

