/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.weaponlib.Part;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.RenderableState;
import com.paneedah.weaponlib.WeaponRenderer;
import com.paneedah.weaponlib.animation.Transition;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.GlStateManager;

public class TransitionContainer {
    private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> custom = new LinkedHashMap();
    private List<Transition<RenderContext<RenderableState>>> firstPerson;
    private List<Transition<RenderContext<RenderableState>>> leftHand;
    private List<Transition<RenderContext<RenderableState>>> rightHand;
    private long duration;

    public TransitionContainer() {
    }

    public TransitionContainer(LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> custom, List<Transition<RenderContext<RenderableState>>> fps, List<Transition<RenderContext<RenderableState>>> left, List<Transition<RenderContext<RenderableState>>> right) {
        this.custom = custom;
        this.firstPerson = fps;
        this.leftHand = left;
        this.rightHand = right;
    }

    public void build(WeaponRenderer.Builder wr) {
        if (this.firstPerson == null) {
            this.firstPerson = Collections.singletonList(new Transition<RenderContext<RenderableState>>(wr.firstPersonPositioning, 250L));
        }
        for (Transition<RenderContext<RenderableState>> transition : this.firstPerson) {
        }
        GlStateManager.func_179094_E();
        if (this.leftHand == null) {
            this.leftHand = this.firstPerson.stream().map(t -> new Transition<RenderContext>(c -> wr.firstPersonLeftHandTransform.doGLDirect(), 0L)).collect(Collectors.toList());
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        if (this.rightHand == null) {
            this.rightHand = this.firstPerson.stream().map(t -> new Transition<RenderContext>(c -> wr.firstPersonRightHandTransform.doGLDirect(), 0L)).collect(Collectors.toList());
        }
        GlStateManager.func_179121_F();
        this.custom.forEach((p, t) -> {
            if (t.size() != this.firstPerson.size()) {
                throw new IllegalStateException("Custom reloading transition number mismatch. Expected " + this.firstPerson.size() + ", actual: " + t.size());
            }
        });
    }

    public LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> getCustom() {
        return this.custom;
    }

    public void setCustom(LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> custom) {
        this.custom = custom;
    }

    public List<Transition<RenderContext<RenderableState>>> getFirstPerson() {
        return this.firstPerson;
    }

    public void setFirstPerson(List<Transition<RenderContext<RenderableState>>> firstPerson) {
        this.firstPerson = firstPerson;
    }

    public List<Transition<RenderContext<RenderableState>>> getLeftHand() {
        return this.leftHand;
    }

    public void setLeftHand(List<Transition<RenderContext<RenderableState>>> leftHand) {
        this.leftHand = leftHand;
    }

    public List<Transition<RenderContext<RenderableState>>> getRightHand() {
        return this.rightHand;
    }

    public void setRightHand(List<Transition<RenderContext<RenderableState>>> rightHand) {
        this.rightHand = rightHand;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration() {
        this.duration = 0L;
        for (Transition<RenderContext<RenderableState>> t : this.firstPerson) {
            this.duration += t.getDuration();
        }
    }
}

