/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.network.NetworkPermitManager;
import com.paneedah.mwc.network.TypeRegistry;
import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.weaponlib.ItemBullet;
import com.paneedah.weaponlib.ItemMagazine;
import com.paneedah.weaponlib.MagazineState;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerMagazineInstance;
import com.paneedah.weaponlib.Tags;
import com.paneedah.weaponlib.state.Aspect;
import com.paneedah.weaponlib.state.Permit;
import com.paneedah.weaponlib.state.StateManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MagazineReloadAspect
implements Aspect<MagazineState, PlayerMagazineInstance> {
    private static final Set<MagazineState> allowedUpdateFromStates;
    private static long reloadAnimationDuration;
    private static Predicate<PlayerMagazineInstance> reloadAnimationCompleted;
    private ModContext modContext;
    private NetworkPermitManager permitManager;
    private StateManager<MagazineState, ? super PlayerMagazineInstance> stateManager;
    private Predicate<PlayerMagazineInstance> notFull = instance -> {
        boolean result = Tags.getAmmo(instance.getItemStack()) < instance.getMagazine().getCapacity();
        return result;
    };
    private Predicate<PlayerMagazineInstance> notEmpty = instance -> {
        boolean result = Tags.getAmmo(instance.getItemStack()) != 0;
        return result;
    };

    public MagazineReloadAspect(ModContext modContext) {
        this.modContext = modContext;
    }

    @Override
    public void setStateManager(StateManager<MagazineState, ? super PlayerMagazineInstance> stateManager) {
        if (this.permitManager == null) {
            throw new IllegalStateException("Permit manager not initialized");
        }
        this.stateManager = stateManager.in(this).change(MagazineState.READY).to(MagazineState.LOAD).when(this.notFull).withPermit((s, es) -> new LoadPermit((MagazineState)s), this.modContext.getPlayerItemInstanceRegistry()::update, this.permitManager).withAction((c, f, t, p) -> this.doPermittedLoad((PlayerMagazineInstance)c, (LoadPermit)p)).manual().in(this).change(MagazineState.LOAD).to(MagazineState.READY).when(reloadAnimationCompleted).automatic().in(this).change(MagazineState.READY).to(MagazineState.UNLOAD).when(this.notEmpty).withPermit((s, es) -> new UnloadPermit((MagazineState)s), this.modContext.getPlayerItemInstanceRegistry()::update, this.permitManager).withAction((c, f, t, p) -> this.doPermittedUnload((PlayerMagazineInstance)c, (UnloadPermit)p)).manual().in(this).change(MagazineState.UNLOAD).to(MagazineState.READY).when(reloadAnimationCompleted).automatic();
    }

    @Override
    public void setPermitManager(NetworkPermitManager permitManager) {
        this.permitManager = permitManager;
        permitManager.registerEvaluator(LoadPermit.class, PlayerMagazineInstance.class, (p, c) -> this.evaluateLoad((LoadPermit)p, (PlayerMagazineInstance)c));
        permitManager.registerEvaluator(UnloadPermit.class, PlayerMagazineInstance.class, (p, c) -> this.evaluateUnload((UnloadPermit)p, (PlayerMagazineInstance)c));
    }

    public void reloadMainHeldItem(EntityPlayer player) {
        PlayerMagazineInstance instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerMagazineInstance.class);
        this.stateManager.changeState(this, instance, new MagazineState[]{MagazineState.LOAD});
    }

    public void unloadMainHeldItem(EntityPlayer player) {
        PlayerMagazineInstance instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerMagazineInstance.class);
        this.stateManager.changeState(this, instance, new MagazineState[]{MagazineState.UNLOAD});
    }

    void updateMainHeldItem(EntityPlayer player) {
        PlayerMagazineInstance instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerMagazineInstance.class);
        if (instance != null) {
            this.stateManager.changeStateFromAnyOf(this, instance, allowedUpdateFromStates, new MagazineState[0]);
        }
    }

    private void evaluateUnload(UnloadPermit p, PlayerMagazineInstance magazineInstance) {
        if (!(magazineInstance.getPlayer() instanceof EntityPlayer)) {
            return;
        }
        ItemStack magazineStack = magazineInstance.getItemStack();
        Permit.Status status = Permit.Status.DENIED;
        if (magazineStack.func_77973_b() instanceof ItemMagazine) {
            ItemStack magazineItemStack = magazineStack;
            EntityPlayer player = (EntityPlayer)magazineInstance.getPlayer();
            boolean originalFlag = true;
            if (magazineItemStack.func_190916_E() > 1) {
                magazineItemStack.func_190918_g(1);
                ItemStack copyOfStack = magazineItemStack.func_77946_l();
                copyOfStack.func_190920_e(1);
                magazineItemStack = copyOfStack;
                originalFlag = false;
            }
            ItemMagazine magazine = (ItemMagazine)magazineItemStack.func_77973_b();
            List<ItemBullet> compatibleBullets = magazine.getCompatibleBullets();
            int currentAmmo = originalFlag ? Tags.getAmmo(magazineStack) : Tags.getAmmo(magazineItemStack);
            ItemStack stack = new ItemStack((Item)compatibleBullets.get(0));
            stack.func_190920_e(currentAmmo);
            player.func_191521_c(stack);
            if (originalFlag) {
                Tags.setAmmo(magazineStack, 0);
            } else {
                Tags.setAmmo(magazineItemStack, 0);
            }
            if (!originalFlag) {
                player.field_71071_by.func_70441_a(magazineItemStack);
            }
            if (magazine.getUnloadSound() != null) {
                magazineInstance.getPlayer().func_184185_a(magazine.getUnloadSound(), 1.0f, 1.0f);
            }
            status = Permit.Status.GRANTED;
        }
        p.setStatus(status);
    }

    private void evaluateLoad(LoadPermit p, PlayerMagazineInstance magazineInstance) {
        if (!(magazineInstance.getPlayer() instanceof EntityPlayer)) {
            return;
        }
        ItemStack magazineStack = magazineInstance.getItemStack();
        Permit.Status status = Permit.Status.DENIED;
        if (magazineStack.func_77973_b() instanceof ItemMagazine) {
            int consumedAmount;
            ItemStack magazineItemStack = magazineStack;
            EntityPlayer player = (EntityPlayer)magazineInstance.getPlayer();
            boolean shouldSplitStack = false;
            if (magazineItemStack.func_190916_E() > 1) {
                shouldSplitStack = true;
                if (player.field_71071_by.func_70447_i() < 0) {
                    p.setStatus(status);
                    return;
                }
            }
            ItemMagazine magazine = (ItemMagazine)magazineItemStack.func_77973_b();
            List<ItemBullet> bullets = magazine.getCompatibleBullets();
            int currentAmmo = Tags.getAmmo(magazineStack);
            if (currentAmmo < magazine.getCapacity() && (consumedAmount = MWCUtil.consumeItemsFromPlayerInventory(bullets, magazine.getCapacity() - currentAmmo, (EntityPlayer)magazineInstance.getPlayer())) != 0) {
                ItemStack remainingStack = null;
                if (shouldSplitStack) {
                    remainingStack = magazineStack.func_77979_a(magazineStack.func_190916_E() - 1);
                }
                Tags.setAmmo(magazineStack, Tags.getAmmo(magazineStack) + consumedAmount);
                if (remainingStack != null) {
                    player.field_71071_by.func_70441_a(remainingStack);
                }
                if (magazine.getReloadSound() != null) {
                    magazineInstance.getPlayer().func_184185_a(magazine.getReloadSound(), 1.0f, 1.0f);
                }
                status = Permit.Status.GRANTED;
            }
        }
        p.setStatus(status);
    }

    private void doPermittedUnload(PlayerMagazineInstance weaponInstance, UnloadPermit permit) {
        if (permit == null) {
            System.err.println("Permit is null, something went wrong");
            return;
        }
    }

    private void doPermittedLoad(PlayerMagazineInstance weaponInstance, LoadPermit permit) {
        if (permit == null) {
            System.err.println("Permit is null, something went wrong");
            return;
        }
    }

    static {
        TypeRegistry.getINSTANCE().register(LoadPermit.class);
        TypeRegistry.getINSTANCE().register(UnloadPermit.class);
        allowedUpdateFromStates = new HashSet<MagazineState>(Arrays.asList(MagazineState.LOAD_REQUESTED, MagazineState.LOAD, MagazineState.UNLOAD_REQUESTED, MagazineState.UNLOAD));
        reloadAnimationDuration = 1000L;
        reloadAnimationCompleted = es -> System.currentTimeMillis() >= es.getStateUpdateTimestamp() + reloadAnimationDuration;
    }

    public static class UnloadPermit
    extends Permit<MagazineState> {
        public UnloadPermit() {
        }

        public UnloadPermit(MagazineState state) {
            super(state);
        }
    }

    public static class LoadPermit
    extends Permit<MagazineState> {
        public LoadPermit() {
        }

        public LoadPermit(MagazineState state) {
            super(state);
        }
    }
}

