/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.ClientEffectManager;
import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.CommonModContext;
import com.paneedah.weaponlib.CustomGui;
import com.paneedah.weaponlib.EffectManager;
import com.paneedah.weaponlib.EntityShellCasing;
import com.paneedah.weaponlib.EntitySpreadable;
import com.paneedah.weaponlib.InvisibleEntityRenderer;
import com.paneedah.weaponlib.KeyBindings;
import com.paneedah.weaponlib.PlayerItemInstanceRegistry;
import com.paneedah.weaponlib.PlayerTransitionProvider;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.ShellCasingRenderer;
import com.paneedah.weaponlib.SpawnEntityRenderer;
import com.paneedah.weaponlib.SyncManager;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponEventHandler;
import com.paneedah.weaponlib.WeaponRenderer;
import com.paneedah.weaponlib.WeaponResourcePack;
import com.paneedah.weaponlib.WeaponSpawnEntity;
import com.paneedah.weaponlib.animation.ScreenShakingAnimationManager;
import com.paneedah.weaponlib.command.DebugCommand;
import com.paneedah.weaponlib.command.MainCommand;
import com.paneedah.weaponlib.compatibility.CompatibleRenderingRegistry;
import com.paneedah.weaponlib.crafting.ammopress.GUIContainerAmmoPress;
import com.paneedah.weaponlib.crafting.workbench.GUIContainerWorkbench;
import com.paneedah.weaponlib.electronics.EntityWirelessCamera;
import com.paneedah.weaponlib.electronics.WirelessCameraRenderer;
import com.paneedah.weaponlib.grenade.EntityFlashGrenade;
import com.paneedah.weaponlib.grenade.EntityGasGrenade;
import com.paneedah.weaponlib.grenade.EntityGrenade;
import com.paneedah.weaponlib.grenade.EntityGrenadeRenderer;
import com.paneedah.weaponlib.grenade.EntitySmokeGrenade;
import com.paneedah.weaponlib.grenade.GrenadeRenderer;
import com.paneedah.weaponlib.grenade.ItemGrenade;
import com.paneedah.weaponlib.inventory.InventoryTabs;
import com.paneedah.weaponlib.melee.ItemMelee;
import com.paneedah.weaponlib.melee.MeleeRenderer;
import com.paneedah.weaponlib.melee.PlayerMeleeInstance;
import com.paneedah.weaponlib.perspective.PerspectiveManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientModContext
extends CommonModContext {
    protected static ClientModContext currentContext;
    private ClientEventHandler clientEventHandler;
    private CompatibleRenderingRegistry rendererRegistry;
    private PerspectiveManager viewManager;
    private float aspectRatio;
    private Framebuffer inventoryFramebuffer;
    private Map<Object, Integer> inventoryTextureMap;
    private EffectManager effectManager;
    private ScreenShakingAnimationManager playerRawPitchAnimationManager;
    private PlayerTransitionProvider playerTransitionProvider;

    public static ClientModContext getContext() {
        return currentContext;
    }

    @Override
    public void preInit(Object mod) {
        super.preInit(mod);
        currentContext = new ClientModContext();
        this.aspectRatio = (float)ClientProxy.MC.field_71443_c / (float)ClientProxy.MC.field_71440_d;
        ClientCommandHandler.instance.func_71560_a((ICommand)new DebugCommand());
        ClientCommandHandler.instance.func_71560_a((ICommand)new MainCommand(this));
        this.rendererRegistry = new CompatibleRenderingRegistry();
        this.rendererRegistry.preInit();
        List defaultResourcePacks = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)ClientProxy.MC, (String)"field_110449_ao");
        WeaponResourcePack weaponResourcePack = new WeaponResourcePack();
        defaultResourcePacks.add(weaponResourcePack);
        IResourceManager resourceManager = ClientProxy.MC.func_110442_L();
        if (resourceManager instanceof IReloadableResourceManager) {
            ((SimpleReloadableResourceManager)resourceManager).func_110545_a((IResourcePack)weaponResourcePack);
        }
        MinecraftForge.EVENT_BUS.register((Object)new CustomGui(ClientProxy.MC, this, this.weaponAttachmentAspect));
        MinecraftForge.EVENT_BUS.register((Object)new WeaponEventHandler(this));
        KeyBindings.init();
        this.clientEventHandler = new ClientEventHandler(this);
        MinecraftForge.EVENT_BUS.register((Object)this.clientEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)InventoryTabs.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)this.clientEventHandler);
        this.viewManager = new PerspectiveManager(this);
        this.inventoryTextureMap = new HashMap<Object, Integer>();
        this.effectManager = new ClientEffectManager();
        this.playerRawPitchAnimationManager = new ScreenShakingAnimationManager();
        GUIContainerWorkbench.setModContext(this);
        GUIContainerAmmoPress.setModContext(this);
    }

    @Override
    public void init(Object mod) {
        super.init(mod);
        this.rendererRegistry.registerEntityRenderingHandler(WeaponSpawnEntity.class, (Object)new SpawnEntityRenderer());
        this.rendererRegistry.registerEntityRenderingHandler(EntityWirelessCamera.class, (Object)new WirelessCameraRenderer());
        this.rendererRegistry.registerEntityRenderingHandler(EntityShellCasing.class, (Object)new ShellCasingRenderer());
        this.rendererRegistry.registerEntityRenderingHandler(EntityGrenade.class, (Object)new EntityGrenadeRenderer());
        this.rendererRegistry.registerEntityRenderingHandler(EntitySmokeGrenade.class, (Object)new EntityGrenadeRenderer());
        this.rendererRegistry.registerEntityRenderingHandler(EntityGasGrenade.class, (Object)new EntityGrenadeRenderer());
        this.rendererRegistry.registerEntityRenderingHandler(EntityFlashGrenade.class, (Object)new EntityGrenadeRenderer());
        this.rendererRegistry.registerEntityRenderingHandler(EntitySpreadable.class, (Object)new InvisibleEntityRenderer());
        this.rendererRegistry.processDelayedRegistrations();
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void registerServerSideOnly() {
    }

    public PerspectiveManager getViewManager() {
        return this.viewManager;
    }

    @Override
    public void registerWeapon(String name, Weapon weapon, WeaponRenderer renderer) {
        super.registerWeapon(name, weapon, renderer);
        this.rendererRegistry.register((Item)weapon, weapon.getName(), (Object)weapon.getRenderer());
        renderer.setClientModContext(this);
    }

    @Override
    public void registerRenderableItem(String name, Item item, Object renderer) {
        super.registerRenderableItem(name, item, renderer);
        this.rendererRegistry.register(item, name, renderer);
    }

    @Override
    public void registerRenderableItem(ResourceLocation name, Item item, Object renderer) {
        super.registerRenderableItem(name, item, renderer);
        this.rendererRegistry.register(item, name, renderer);
    }

    @Override
    protected EntityPlayer getPlayer(MessageContext ctx) {
        return ClientProxy.MC.field_71439_g;
    }

    @Override
    public PlayerItemInstanceRegistry getPlayerItemInstanceRegistry() {
        return this.playerItemInstanceRegistry;
    }

    protected SyncManager<?> getSyncManager() {
        return this.syncManager;
    }

    @Override
    public PlayerWeaponInstance getMainHeldWeapon() {
        return this.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)ClientProxy.MC.field_71439_g, PlayerWeaponInstance.class);
    }

    public PlayerMeleeInstance getMainHeldMeleeWeapon() {
        return this.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)ClientProxy.MC.field_71439_g, PlayerMeleeInstance.class);
    }

    @Override
    public void registerMeleeWeapon(String name, ItemMelee itemMelee, MeleeRenderer renderer) {
        super.registerMeleeWeapon(name, itemMelee, renderer);
        this.rendererRegistry.register((Item)itemMelee, itemMelee.getName(), (Object)itemMelee.getRenderer());
        renderer.setClientModContext(this);
    }

    @Override
    public void registerGrenadeWeapon(String name, ItemGrenade itemGrenade, GrenadeRenderer renderer) {
        super.registerGrenadeWeapon(name, itemGrenade, renderer);
        this.rendererRegistry.register((Item)itemGrenade, itemGrenade.getName(), (Object)itemGrenade.getRenderer());
        renderer.setClientModContext(this);
    }

    @Override
    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public Framebuffer getInventoryFramebuffer() {
        if (this.inventoryFramebuffer == null) {
            this.inventoryFramebuffer = new Framebuffer(256, 256, true);
            this.inventoryFramebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.inventoryFramebuffer;
    }

    public Map<Object, Integer> getInventoryTextureMap() {
        return this.inventoryTextureMap;
    }

    @Override
    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    public ScreenShakingAnimationManager getPlayerRawPitchAnimationManager() {
        return this.playerRawPitchAnimationManager;
    }

    @Override
    public void registerRenderableEntity(Class<? extends Entity> entityClass, Object renderer) {
        this.rendererRegistry.registerEntityRenderingHandler(entityClass, renderer);
    }

    PlayerTransitionProvider getPlayerTransitionProvider() {
        return this.playerTransitionProvider;
    }

    @Override
    public void setPlayerTransitionProvider(PlayerTransitionProvider playerTransitionProvider) {
        this.playerTransitionProvider = playerTransitionProvider;
    }
}

