/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.renderer;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.items.equipment.carryable.ItemCarryable;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.renderer.EquipmentModelPools;
import com.paneedah.mwc.renderer.ModelSource;
import com.paneedah.mwc.renderer.ModelSourceTransforms;
import com.paneedah.mwc.skins.CustomSkin;
import com.paneedah.weaponlib.CustomRenderer;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.RenderableState;
import com.paneedah.weaponlib.Tuple;
import com.paneedah.weaponlib.WeaponRenderer;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class StaticModelSourceRenderer
extends ModelSource
implements IBakedModel {
    protected ModelSourceTransforms transforms;
    private final Pair<? extends IBakedModel, Matrix4f> pair = Pair.of((Object)this, null);
    protected EntityLivingBase owner;
    protected ItemStack itemStack;
    protected ItemCameraTransforms.TransformType transformType;

    public StaticModelSourceRenderer(ModelSourceTransforms transforms) {
        this.transforms = transforms;
    }

    public void renderCustomEquipped(EntityPlayer player, ItemStack itemStack) {
        RenderContext<RenderableState> renderContext = new RenderContext<RenderableState>((EntityLivingBase)player, itemStack);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.33f, (float)0.33f, (float)0.33f);
        GL11.glRotatef((float)180.0f, (float)0.001f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)0.5f);
        this.transforms.getCustomEquippedPositioning().run();
        this.renderModelSource(renderContext, itemStack, null, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.08f);
        GL11.glPopMatrix();
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (ForgeModContainer.allowEmissiveItems) {
            return Collections.emptyList();
        }
        if (this.itemStack == null) {
            return Collections.emptyList();
        }
        if (this.transformType == null || this.transformType == ItemCameraTransforms.TransformType.GROUND || this.transformType == ItemCameraTransforms.TransformType.GUI || this.transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || this.transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            tessellator.func_78381_a();
            GlStateManager.func_179094_E();
            if (this.owner != null && this.transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND && this.owner.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
            }
            int currentTextureId = GlStateManager.func_187397_v((int)32873);
            if (this.transformType == null && this.owner instanceof EntityPlayer) {
                this.renderCustomEquipped((EntityPlayer)this.owner, this.itemStack);
            } else {
                this.renderItem();
            }
            if (currentTextureId != 0) {
                GlStateManager.func_179144_i((int)currentTextureId);
            }
            GlStateManager.func_179121_F();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        }
        this.owner = null;
        this.itemStack = null;
        this.transformType = null;
        return Collections.emptyList();
    }

    public final boolean func_177555_b() {
        return true;
    }

    public final boolean func_177556_c() {
        return true;
    }

    public final boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return ClientProxy.MC.func_147117_R().func_174944_f();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem() {
        GL11.glPushMatrix();
        GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
        EntityPlayerSP player = ClientProxy.MC.field_71439_g;
        RenderContext<RenderableState> renderContext = new RenderContext<RenderableState>((EntityLivingBase)player, this.itemStack);
        switch (this.transformType) {
            case GROUND: {
                this.transforms.getEntityPositioning().run();
                break;
            }
            case GUI: {
                GL11.glScaled((double)0.6f, (double)0.6f, (double)0.6f);
                GL11.glTranslatef((float)-0.7f, (float)-0.8f, (float)-0.1f);
                GL11.glRotatef((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.transforms.getInventoryPositioning().run();
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                GL11.glScaled((double)0.4f, (double)0.4f, (double)0.4f);
                GL11.glTranslatef((float)-1.5f, (float)-2.4f, (float)1.3f);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.transforms.getThirdPersonPositioning().run();
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: {
                GL11.glScaled((double)0.6f, (double)0.6f, (double)0.6f);
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)-0.3f, (float)-0.855f, (float)0.5f);
                this.transforms.getFirstPersonPositioning().run();
                WeaponRenderer.renderLeftArm((EntityLivingBase)player, renderContext, (part, renderContext1) -> this.transforms.getFirstPersonLeftHandPositioning().run());
                WeaponRenderer.renderRightArm((EntityLivingBase)player, renderContext, (part, renderContext1) -> this.transforms.getFirstPersonRightHandPositioning().run());
                break;
            }
        }
        this.renderModelSource(renderContext, this.itemStack, this.transformType, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.08f);
        GL11.glPopMatrix();
    }

    protected void renderModelSource(RenderContext<RenderableState> renderContext, ItemStack itemStack, ItemCameraTransforms.TransformType transformType, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (itemStack.func_77973_b() instanceof ItemCarryable) {
            this.renderModelSourceCarryableItem(itemStack, transformType, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            return;
        }
        if (!(itemStack.func_77973_b() instanceof com.paneedah.weaponlib.ModelSource)) {
            throw new IllegalArgumentException();
        }
        GL11.glPushMatrix();
        com.paneedah.weaponlib.ModelSource modelSource = (com.paneedah.weaponlib.ModelSource)itemStack.func_77973_b();
        for (Tuple<ModelBase, String> texturedModel : modelSource.getTexturedModels()) {
            if (texturedModel.getV().startsWith("customskin_")) {
                ClientProxy.MC.field_71446_o.func_110577_a(CustomSkin.getCustomSkinResource(texturedModel.getV().replace("customskin_", "")));
            } else {
                ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation("mwc:textures/models/" + texturedModel.getV()));
            }
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            ModelBase model = texturedModel.getU();
            if (transformType != null) {
                switch (transformType) {
                    case GROUND: {
                        this.transforms.getEntityModelPositioning().accept(model);
                        break;
                    }
                    case GUI: {
                        this.transforms.getInventoryModelPositioning().accept(model);
                        break;
                    }
                    case THIRD_PERSON_RIGHT_HAND: 
                    case THIRD_PERSON_LEFT_HAND: {
                        this.transforms.getThirdPersonModelPositioning().accept(model);
                        break;
                    }
                    case FIRST_PERSON_RIGHT_HAND: 
                    case FIRST_PERSON_LEFT_HAND: {
                        this.transforms.getFirstPersonModelPositioning().accept(model);
                        break;
                    }
                }
            }
            model.func_78088_a((Entity)ClientProxy.MC.field_71439_g, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        CustomRenderer<?> postRenderer = modelSource.getPostRenderer();
        if (postRenderer != null) {
            renderContext.setAgeInTicks(-0.4f);
            renderContext.setScale(0.08f);
            renderContext.setCompatibleTransformType(transformType);
            renderContext.setPlayerItemInstance(MWC.modContext.getPlayerItemInstanceRegistry().getItemInstance(renderContext.getPlayer(), itemStack));
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8193);
            postRenderer.render(renderContext);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    protected void renderModelSourceCarryableItem(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ItemCarryable itemCarryable = (ItemCarryable)itemStack.func_77973_b();
        ModelBiped model = EquipmentModelPools.get(itemCarryable.modelName);
        ClientProxy.MC.func_110434_K().func_110577_a(new ResourceLocation("mwc:textures/models/" + itemCarryable.textureName));
        if (transformType != null) {
            switch (transformType) {
                case GROUND: {
                    this.transforms.getEntityModelPositioning().accept((ModelBase)model);
                    break;
                }
                case GUI: {
                    this.transforms.getInventoryModelPositioning().accept((ModelBase)model);
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: 
                case THIRD_PERSON_LEFT_HAND: {
                    this.transforms.getThirdPersonModelPositioning().accept((ModelBase)model);
                    break;
                }
                case FIRST_PERSON_RIGHT_HAND: 
                case FIRST_PERSON_LEFT_HAND: {
                    this.transforms.getFirstPersonModelPositioning().accept((ModelBase)model);
                    break;
                }
            }
        }
        model.func_78088_a((Entity)ClientProxy.MC.field_71439_g, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    public ItemOverrideList func_188617_f() {
        return new WeaponItemOverrideList(Collections.emptyList());
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.transformType = cameraTransformType;
        return this.pair;
    }

    private class WeaponItemOverrideList
    extends ItemOverrideList {
        public WeaponItemOverrideList(List<ItemOverride> overridesIn) {
            super(overridesIn);
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            StaticModelSourceRenderer.this.itemStack = stack;
            StaticModelSourceRenderer.this.owner = entity;
            return super.handleItemState(originalModel, stack, world, entity);
        }
    }
}

