/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network;

import com.paneedah.mwc.network.ISerializable;
import com.paneedah.mwc.utils.ModReference;
import io.netty.buffer.ByteBuf;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.UUID;

public final class TypeRegistry {
    private static final TypeRegistry INSTANCE = new TypeRegistry();
    private final HashMap<UUID, Class<? extends ISerializable>> typeRegistry = new HashMap();

    public <T extends ISerializable> void register(Class<T> cls) {
        this.typeRegistry.put(this.getUuid(cls), cls);
    }

    public UUID getUuid(Class<?> aClass) {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(aClass.getName().getBytes());
            return new UUID(secureRandom.nextLong(), secureRandom.nextLong());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to create a secure random", "", new String[]{noSuchAlgorithmException.getMessage()});
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public <T extends ISerializable> void toBytes(T object, ByteBuf byteBuf) {
        UUID uuid = this.getUuid(object.getClass());
        if (!this.typeRegistry.containsKey(uuid)) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to write object because its class is not registered", "", new String[]{"Object: " + object, "Class: " + object.getClass()});
            throw new RuntimeException();
        }
        byteBuf.writeLong(uuid.getMostSignificantBits());
        byteBuf.writeLong(uuid.getLeastSignificantBits());
        if (object.getClass().isEnum()) {
            byteBuf.writeInt(((Enum)((Object)object)).ordinal());
        } else {
            object.write(byteBuf);
        }
    }

    public <T extends ISerializable> T fromBytes(ByteBuf byteBuf) {
        ISerializable instance;
        long leastSigBits;
        long mostSigBits = byteBuf.readLong();
        UUID typeUuid = new UUID(mostSigBits, leastSigBits = byteBuf.readLong());
        Class<? extends ISerializable> targetClass = this.typeRegistry.get(typeUuid);
        if (targetClass == null) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to deserialize object.\nDid you forget to register type?", "", new String[0]);
            throw new RuntimeException();
        }
        if (targetClass.isEnum()) {
            ISerializable[] constants = targetClass.getEnumConstants();
            instance = constants[byteBuf.readInt()];
        } else {
            try {
                instance = targetClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException exception) {
                ModReference.RED_LOG.printFramedError("Networking", "Failed to create instance", "", new String[]{exception.getMessage(), exception.getStackTrace()[3].toString()});
                throw new RuntimeException();
            }
            instance.read(byteBuf);
        }
        return (T)targetClass.cast(instance);
    }

    public static TypeRegistry getINSTANCE() {
        return INSTANCE;
    }
}

