/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.PermitMessage;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.state.ExtendedState;
import com.paneedah.weaponlib.state.ManagedState;
import com.paneedah.weaponlib.state.Permit;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class NetworkPermitManager {
    private final HashMap<UUID, BiConsumer<Permit<?>, PlayerItemInstance<?>>> permitCallbacks = new HashMap();
    private final HashMap<Class<?>, BiConsumer<Permit<?>, PlayerItemInstance<?>>> permitEvaluators = new HashMap();

    public <S extends ManagedState<S>, P extends Permit<S>, E extends ExtendedState<S>> void request(P permit, E extendedState, BiConsumer<P, E> callback) {
        this.permitCallbacks.put(permit.getUuid(), callback);
        MWC.CHANNEL.sendToServer((IMessage)new PermitMessage(permit, (PlayerItemInstance)extendedState));
    }

    public <S extends ManagedState<S>, P extends Permit<S>, E extends ExtendedState<S>> void registerEvaluator(Class<? extends P> permitClass, Class<? extends E> esClass, BiConsumer<P, E> evaluator) {
        this.permitEvaluators.put(permitClass, (permit, playerItemInstance) -> {
            ModReference.LOG.debug("Processing permit {} for instance {}", permit, playerItemInstance);
            evaluator.accept(permitClass.cast(permit), esClass.cast(playerItemInstance));
        });
    }

    public HashMap<UUID, BiConsumer<Permit<?>, PlayerItemInstance<?>>> getPermitCallbacks() {
        return this.permitCallbacks;
    }

    public HashMap<Class<?>, BiConsumer<Permit<?>, PlayerItemInstance<?>>> getPermitEvaluators() {
        return this.permitEvaluators;
    }
}

