/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network;

import com.paneedah.mwc.utils.ModReference;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class CompressionUtil {
    public static byte[] compressString(String string) {
        GZIPOutputStream gzipOutputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        }
        catch (IOException ioException) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to create compression output stream.", "", new String[]{ioException.getMessage()});
            return new byte[0];
        }
        try {
            gzipOutputStream.write(string.getBytes());
        }
        catch (IOException ioException) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to compress string.", "", new String[]{ioException.getMessage()});
        }
        try {
            byteArrayOutputStream.close();
            gzipOutputStream.close();
        }
        catch (IOException ioException) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to close output stream.", "", new String[]{ioException.getMessage()});
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String decompressString(byte[] bytes) {
        GZIPInputStream gzipInputStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        StringBuilder line = new StringBuilder();
        try {
            gzipInputStream = new GZIPInputStream(byteArrayInputStream);
        }
        catch (IOException ioException) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to create compression input stream.", "", new String[]{ioException.getMessage()});
            return "";
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(gzipInputStream));
        try {
            while (bufferedReader.ready()) {
                line.append(bufferedReader.readLine());
            }
        }
        catch (IOException ioException) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to read lines from compression stream.", "", new String[]{ioException.getMessage()});
        }
        try {
            byteArrayInputStream.close();
            gzipInputStream.close();
            bufferedReader.close();
        }
        catch (IOException ioException) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to close input stream.", "", new String[]{ioException.getMessage()});
        }
        return line.toString();
    }
}

