/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.capabilities;

import com.paneedah.mwc.equipment.inventory.EquipmentInventory;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class EquipmentCapability
implements ICapabilitySerializable<NBTBase> {
    @CapabilityInject(value=InventoryContainer.class)
    static Capability<InventoryContainer> capabilityContainer = null;
    private final InventoryContainer instance = (InventoryContainer)capabilityContainer.getDefaultInstance();

    public static void setInventory(EntityLivingBase entity, EquipmentInventory inventory) {
        if (entity == null) {
            return;
        }
        InventoryContainer container = (InventoryContainer)entity.getCapability(capabilityContainer, null);
        if (container != null) {
            container.setInventory(inventory);
        }
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(InventoryContainer.class, (Capability.IStorage)new InventoryStorage(), InventoryContainerImpl::new);
    }

    public static EquipmentInventory getInventory(EntityLivingBase entity) {
        if (entity == null) {
            return null;
        }
        InventoryContainer container = (InventoryContainer)entity.getCapability(capabilityContainer, null);
        return container != null ? container.getInventory() : null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == capabilityContainer;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return (T)(capability == capabilityContainer ? capabilityContainer.cast((Object)this.instance) : null);
    }

    public NBTBase serializeNBT() {
        return capabilityContainer.getStorage().writeNBT(capabilityContainer, (Object)this.instance, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        capabilityContainer.getStorage().readNBT(capabilityContainer, (Object)this.instance, null, nbt);
    }

    public static class InventoryStorage
    implements Capability.IStorage<InventoryContainer> {
        public NBTBase writeNBT(Capability<InventoryContainer> capability, InventoryContainer instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            instance.getInventory().writeToNBT(compound);
            return compound;
        }

        public void readNBT(Capability<InventoryContainer> capability, InventoryContainer instance, EnumFacing side, NBTBase nbt) {
            EquipmentInventory inventory = new EquipmentInventory();
            inventory.readFromNBT((NBTTagCompound)nbt);
            instance.setInventory(inventory);
        }
    }

    public static class InventoryContainerImpl
    implements InventoryContainer {
        private EquipmentInventory inventory = new EquipmentInventory();

        @Override
        public void setInventory(EquipmentInventory inventory) {
            this.inventory = inventory;
        }

        @Override
        public EquipmentInventory getInventory() {
            return this.inventory;
        }
    }

    public static interface InventoryContainer {
        public void setInventory(EquipmentInventory var1);

        public EquipmentInventory getInventory();
    }
}

