/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.gui.overlay.Readouts;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.LocomotiveModel;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.DieselExhaust;
import cam72cam.immersiverailroading.model.part.Horn;
import cam72cam.immersiverailroading.model.part.PartSound;
import cam72cam.immersiverailroading.registry.LocomotiveDieselDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DieselLocomotiveModel
extends LocomotiveModel<LocomotiveDiesel, LocomotiveDieselDefinition> {
    private List<ModelComponent> components;
    private DieselExhaust exhaust;
    private Horn horn;
    private final PartSound idle;
    private final PartSound running;
    private Map<UUID, Float> runningFade = new HashMap<UUID, Float>();

    public DieselLocomotiveModel(LocomotiveDieselDefinition def) throws Exception {
        super(def);
        this.idle = def.isCabCar() ? null : new PartSound(def.idle, true, 80.0f, ConfigSound.SoundCategories.Locomotive.Diesel::idle);
        this.running = def.isCabCar() || def.running == null ? null : new PartSound(def.running, true, 80.0f, ConfigSound.SoundCategories.Locomotive.Diesel::running);
    }

    @Override
    protected void parseControllable(ComponentProvider provider, LocomotiveDieselDefinition def) {
        super.parseControllable(provider, def);
        this.addGauge(provider, ModelComponentType.GAUGE_TEMPERATURE_X, Readouts.TEMPERATURE);
        this.addControl(provider, ModelComponentType.ENGINE_START_X);
        this.addControl(provider, ModelComponentType.HORN_CONTROL_X);
    }

    @Override
    protected void parseComponents(ComponentProvider provider, LocomotiveDieselDefinition def) {
        this.components = provider.parse(ModelComponentType.FUEL_TANK, ModelComponentType.ALTERNATOR, ModelComponentType.ENGINE_BLOCK, ModelComponentType.CRANKSHAFT, ModelComponentType.GEARBOX, ModelComponentType.FLUID_COUPLING, ModelComponentType.FINAL_DRIVE, ModelComponentType.TORQUE_CONVERTER);
        this.components.addAll(provider.parseAll(ModelComponentType.PISTON_X, ModelComponentType.FAN_X, ModelComponentType.DRIVE_SHAFT_X));
        this.rocking.include(this.components);
        this.exhaust = DieselExhaust.get(provider);
        this.horn = Horn.get(provider, this.rocking, def.horn, def.getHornSus());
        super.parseComponents(provider, def);
    }

    @Override
    protected void effects(LocomotiveDiesel stock) {
        super.effects(stock);
        this.exhaust.effects(stock);
        this.horn.effects((EntityMoveableRollingStock)stock, stock.getHornTime() > 0 && (stock.isRunning() || stock.getDefinition().isCabCar()) ? (stock.getDefinition().getHornSus() ? (float)stock.getHornTime() / 10.0f : 1.0f) : 0.0f);
        if (this.idle != null) {
            if (stock.isRunning()) {
                float volume = Math.max(0.1f, stock.getRelativeRPM());
                float pitchRange = stock.getDefinition().getEnginePitchRange();
                float pitch = 1.0f - pitchRange + stock.getRelativeRPM() * pitchRange;
                if (this.running == null) {
                    this.idle.effects(stock, volume, pitch);
                } else {
                    boolean isThrottledUp = (double)stock.getRelativeRPM() > 0.01;
                    float fade = this.runningFade.getOrDefault(stock.getUUID(), Float.valueOf(0.0f)).floatValue();
                    fade += 0.05f * (float)(isThrottledUp ? 1 : -1);
                    fade = Math.min(Math.max(fade, 0.0f), 1.0f);
                    this.runningFade.put(stock.getUUID(), Float.valueOf(fade));
                    this.idle.effects(stock, 1.0f - fade + 0.01f, 1.0f);
                    this.running.effects(stock, fade + 0.01f, pitch);
                }
            } else {
                this.idle.effects((EntityMoveableRollingStock)stock, false);
                if (this.running != null) {
                    this.running.effects((EntityMoveableRollingStock)stock, false);
                    this.runningFade.put(stock.getUUID(), Float.valueOf(0.0f));
                }
            }
        }
    }

    @Override
    protected void removed(LocomotiveDiesel stock) {
        super.removed(stock);
        this.horn.removed(stock);
        if (this.idle != null) {
            this.idle.removed(stock);
        }
        if (this.running != null) {
            this.running.removed(stock);
        }
    }
}

