/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter.mixin;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.extensibility.IMixinProcessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.transformer.Proxy;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.service.mojang.MixinServiceLaunchWrapper;
import zone.rong.mixinbooter.ILateMixinLoader;
import zone.rong.mixinbooter.MixinBooterPlugin;
import zone.rong.mixinbooter.MixinLoader;
import zone.rong.mixinbooter.decorator.FMLContextQuery;
import zone.rong.mixinbooter.fix.MixinFixer;

@Mixin(value={LoadController.class}, remap=false)
public class LoadControllerMixin {
    @Shadow
    private Loader loader;

    @Inject(method={"distributeStateMessage(Lnet/minecraftforge/fml/common/LoaderState;[Ljava/lang/Object;)V"}, at={@At(value="HEAD")})
    private void beforeConstructing(LoaderState state, Object[] eventData, CallbackInfo ci) throws Throwable {
        if (state == LoaderState.CONSTRUCTING) {
            Class<?> clazz;
            ModClassLoader modClassLoader = (ModClassLoader)eventData[0];
            ASMDataTable asmDataTable = (ASMDataTable)eventData[1];
            for (Object container : this.loader.getActiveModList()) {
                modClassLoader.addFile(container.getSource());
            }
            FMLContextQuery.init();
            boolean log = false;
            for (ASMDataTable.ASMData asmData : asmDataTable.getAll(MixinLoader.class.getName())) {
                if (!log) {
                    MixinBooterPlugin.LOGGER.info("Instantiating all MixinLoader annotated classes...");
                    log = true;
                }
                clazz = Class.forName(asmData.getClassName());
                MixinBooterPlugin.LOGGER.info("Instantiating {} for its mixins.", clazz);
                clazz.newInstance();
            }
            log = false;
            for (ASMDataTable.ASMData asmData : asmDataTable.getAll(ILateMixinLoader.class.getName().replace('.', '/'))) {
                if (!log) {
                    MixinBooterPlugin.LOGGER.info("Instantiating all ILateMixinLoader implemented classes...");
                    log = true;
                }
                clazz = Class.forName(asmData.getClassName().replace('/', '.'));
                MixinBooterPlugin.LOGGER.info("Instantiating {} for its mixins.", clazz);
                ILateMixinLoader loader = (ILateMixinLoader)clazz.newInstance();
                for (String mixinConfig : loader.getMixinConfigs()) {
                    if (!loader.shouldMixinConfigQueue(mixinConfig)) continue;
                    MixinBooterPlugin.LOGGER.info("Adding {} mixin configuration.", (Object)mixinConfig);
                    Mixins.addConfiguration(mixinConfig);
                    loader.onMixinConfigQueued(mixinConfig);
                }
            }
            log = false;
            for (String mixinConfig : MixinFixer.retrieveLateMixinConfigs()) {
                if (!log) {
                    MixinBooterPlugin.LOGGER.info("Appending non-conventional mixin configurations...");
                    log = true;
                }
                MixinBooterPlugin.LOGGER.info("Adding {} mixin configuration.", (Object)mixinConfig);
                Mixins.addConfiguration(mixinConfig);
            }
            Field delegatedTransformersField = MixinServiceLaunchWrapper.class.getDeclaredField("delegatedTransformers");
            delegatedTransformersField.setAccessible(true);
            delegatedTransformersField.set(MixinService.getService(), null);
            IMixinProcessor processor = Proxy.transformer.getProcessor();
            Method selectMethod = processor.getClass().getDeclaredMethod("select", MixinEnvironment.class);
            selectMethod.setAccessible(true);
            selectMethod.invoke((Object)processor, MixinEnvironment.getCurrentEnvironment());
        }
    }
}

