/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.gui.container.slots;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.handlers.ConfigHandler;
import com.tiviacz.travelersbackpack.util.EnumSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;

public class SlotTool
extends Slot {
    private EntityPlayer player;
    private EnumSource source;
    private static String[] validToolNames = new String[]{"wrench", "hammer", "axe", "shovel", "grafter", "scoop", "crowbar", "mattock", "drill", "chisel", "cutter", "disassembler", "tool"};

    public SlotTool(EntityPlayer player, EnumSource source, IInventory inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
        this.player = player;
        this.source = source;
    }

    public boolean func_75214_a(ItemStack stack) {
        return SlotTool.isValid(stack);
    }

    public static boolean isValid(ItemStack stack) {
        if (stack.func_77976_d() == 1) {
            if (stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemHoe || stack.func_77973_b() instanceof ItemFishingRod || stack.func_77973_b() instanceof ItemShears || stack.func_77973_b() instanceof ItemFlintAndSteel) {
                return true;
            }
            for (String name : validToolNames) {
                if (!stack.func_77977_a().toLowerCase().contains(name)) continue;
                return true;
            }
            if (stack.func_77973_b().getClass().getName().contains("tconstruct.tools.tools")) {
                return true;
            }
            if (ConfigHandler.server.toolSlotsAcceptSwords) {
                if (stack.func_77973_b() instanceof ItemSword) {
                    return true;
                }
                if (stack.func_77973_b().getClass().getName().contains("tconstruct.tools.melee")) {
                    return true;
                }
            }
        }
        return false;
    }

    public void func_75218_e() {
        if (this.source == EnumSource.WEARABLE) {
            CapabilityUtils.synchronise(this.player);
            CapabilityUtils.synchroniseToOthers(this.player);
        }
    }
}

