/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.server;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.PartyPrivacy;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.utils.entity.EntityUtils;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1845;
import net.minecraft.class_2346;
import net.minecraft.class_388;
import net.minecraft.class_472;
import net.minecraft.class_485;
import net.minecraft.class_486;
import net.minecraft.class_624;
import net.minecraft.class_864;

public class ServerUtils
implements Module {
    private static final List<String> invalidMotds = StringUtils.newArrayList("multiplayer.status.cannot_connect", "multiplayer.status.cannot_resolve", "multiplayer.status.polling", "multiplayer.status.pinging");
    private static final List<String> invalidNames = StringUtils.newArrayList("selectServer.defaultName");
    public boolean enabled = false;
    public List<class_2346> currentPlayerList = StringUtils.newArrayList();
    public List<String> knownAddresses = StringUtils.newArrayList();
    public List<String> defaultAddresses = StringUtils.newArrayList();
    public Map<String, class_485> knownServerData = StringUtils.newHashMap();
    private boolean isInUse = false;
    private boolean hasScanned = false;
    private String currentServer_IP;
    private String currentServer_Name;
    private String currentServer_MOTD;
    private List<String> currentServer_MOTD_Lines = StringUtils.newArrayList();
    private String currentServerMessage = "";
    private String currentServerIcon = "";
    private Pair<Long, Instant> worldTimeData;
    private String timeString24;
    private String timeString12;
    private long dayCount;
    private String currentDifficulty;
    private String currentWorldName;
    private String currentWeatherName;
    private int currentPlayers;
    private int maxPlayers;
    private int serverIndex;
    private Tuple<Double, Double, Double> currentCoordinates;
    private Pair<Double, Double> currentHealth;
    private class_485 currentServerData;
    private class_1845 currentConnection;
    private boolean queuedForUpdate = false;
    private boolean joinInProgress = false;
    private boolean isOnLAN = false;

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.currentPlayerList.clear();
        this.defaultAddresses.clear();
        this.knownAddresses.clear();
        this.knownServerData.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.currentServer_IP = null;
        this.currentServer_MOTD = null;
        this.currentServer_MOTD_Lines.clear();
        this.currentServer_Name = null;
        this.currentServerData = null;
        this.currentConnection = null;
        this.currentCoordinates = null;
        this.currentHealth = null;
        this.currentDifficulty = null;
        this.currentWorldName = null;
        this.currentWeatherName = null;
        this.currentServerMessage = "";
        this.currentServerIcon = "";
        this.worldTimeData = null;
        this.timeString24 = null;
        this.timeString12 = null;
        this.dayCount = 0L;
        this.currentPlayers = 0;
        this.maxPlayers = 0;
        this.queuedForUpdate = false;
        this.joinInProgress = false;
        this.isOnLAN = false;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("server", "data.server", "world", "data.world", "player");
        CraftPresence.CLIENT.clearOverride("server.message", "server.icon");
        CraftPresence.CLIENT.clearPartyData();
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.joinInProgress = CraftPresence.CLIENT.STATUS == DiscordStatus.JoinGame || CraftPresence.CLIENT.STATUS == DiscordStatus.SpectateGame;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.generalSettings.detectWorldData : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned && this.canFetchData();
        if (needsUpdate) {
            this.scanForData();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null && !this.joinInProgress) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        class_485 newServerData = CraftPresence.instance.method_6625();
        class_1845 newConnection = CraftPresence.instance.method_2960();
        if (!this.joinInProgress) {
            Pair<Long, Instant> newTimeData;
            String secondaryWorldName;
            String primaryWorldName;
            String newWorldName;
            String newDifficulty;
            Pair<Double, Double> newHealth;
            Tuple<Double, Double, Double> newCoordinates;
            String newServer_MOTD;
            List newPlayerList = newConnection != null ? StringUtils.newArrayList(newConnection.method_9656()) : StringUtils.newArrayList();
            int newCurrentPlayers = newConnection != null ? newConnection.method_9656().size() : 1;
            int newMaxPlayers = newConnection != null && newConnection.field_7912 >= newCurrentPlayers ? newConnection.field_7912 : newCurrentPlayers + 1;
            boolean newLANStatus = CraftPresence.instance.method_2908() && newCurrentPlayers > 1 || newServerData != null && newServerData.method_4281();
            String newServer_IP = newServerData != null && !StringUtils.isNullOrEmpty(newServerData.field_1687) ? newServerData.field_1687 : "127.0.0.1";
            String newServer_Name = newServerData != null && !this.isInvalidName(newServerData.field_1686) ? newServerData.field_1686 : CraftPresence.CONFIG.serverSettings.fallbackServerName;
            String string = newServer_MOTD = !this.isOnLAN && !CraftPresence.instance.method_2908() && newServerData != null && !this.isInvalidMotd(newServerData.field_1689) ? StringUtils.stripAllFormatting(newServerData.field_1689) : CraftPresence.CONFIG.serverSettings.fallbackServerMotd;
            if (newLANStatus != this.isOnLAN || newServerData != null && !newServerData.equals(this.currentServerData) || newServerData == null && this.currentServerData != null || newConnection != null && !newConnection.equals(this.currentConnection) || !newServer_IP.equals(this.currentServer_IP) || !StringUtils.isNullOrEmpty(newServer_MOTD) && !newServer_MOTD.equals(this.currentServer_MOTD) || !StringUtils.isNullOrEmpty(newServer_Name) && !newServer_Name.equals(this.currentServer_Name)) {
                this.currentServer_IP = newServer_IP;
                if (!newServer_MOTD.equals(this.currentServer_MOTD)) {
                    this.currentServer_MOTD = newServer_MOTD;
                    this.currentServer_MOTD_Lines = StringUtils.splitTextByNewLine(newServer_MOTD);
                }
                this.currentServer_Name = newServer_Name;
                this.currentServerData = newServerData;
                this.currentConnection = newConnection;
                this.isOnLAN = newLANStatus;
                this.queuedForUpdate = true;
                if (!StringUtils.isNullOrEmpty(this.currentServer_IP)) {
                    String formattedIP;
                    String string2 = formattedIP = this.currentServer_IP.contains(":") ? StringUtils.formatAddress(this.currentServer_IP, false) : this.currentServer_IP;
                    if (!this.defaultAddresses.contains(formattedIP)) {
                        this.defaultAddresses.add(formattedIP);
                    }
                    if (!this.knownAddresses.contains(formattedIP)) {
                        this.knownAddresses.add(formattedIP);
                    }
                }
                class_486 serverList = new class_486(CraftPresence.instance);
                serverList.method_1273();
                if (serverList.method_1281() != this.serverIndex || CraftPresence.CONFIG.serverSettings.serverData.size() != this.serverIndex) {
                    this.scanForData();
                }
            }
            if (!Objects.equals(newCoordinates = new Tuple<Double, Double, Double>(MathUtils.roundDouble(CraftPresence.player.field_3252, 3), MathUtils.roundDouble(CraftPresence.player.field_3253, 3), MathUtils.roundDouble(CraftPresence.player.field_3254, 3)), this.currentCoordinates)) {
                this.currentCoordinates = newCoordinates;
                this.queuedForUpdate = true;
            }
            if (!Objects.equals(newHealth = new Pair<Double, Double>(MathUtils.roundDouble(CraftPresence.player.method_6122(), 0), MathUtils.roundDouble(CraftPresence.player.method_6125(), 0)), this.currentHealth)) {
                this.currentHealth = newHealth;
                this.queuedForUpdate = true;
            }
            String string3 = newDifficulty = CraftPresence.player.field_3248.method_3588().method_235() && ModUtils.RAW_TRANSLATOR != null ? ModUtils.RAW_TRANSLATOR.translate("selectWorld.gameMode.hardcore", new Object[0]) : StringUtils.formatWord(CraftPresence.player.field_3248.method_8519().name().toLowerCase());
            if (!newDifficulty.equals(this.currentDifficulty)) {
                this.currentDifficulty = newDifficulty;
                this.queuedForUpdate = true;
            }
            String newWeatherData = EntityUtils.getWeather((class_864)CraftPresence.player);
            String newWeatherName = Constants.TRANSLATOR.translate("craftpresence.defaults.weather." + newWeatherData, new Object[0]);
            if (!newWeatherName.equals(this.currentWeatherName)) {
                this.currentWeatherName = newWeatherName;
                this.queuedForUpdate = true;
            }
            if (!(newWorldName = StringUtils.getOrDefault(primaryWorldName = CraftPresence.instance.method_2909() != null ? CraftPresence.instance.method_2909().method_2976() : "", secondaryWorldName = StringUtils.getOrDefault(CraftPresence.player.field_3248.method_3588().method_226(), Constants.TRANSLATOR.translate("craftpresence.defaults.world_name", new Object[0])))).equals(this.currentWorldName)) {
                this.currentWorldName = newWorldName;
                this.queuedForUpdate = true;
            }
            if (!Objects.equals(newTimeData = TimeUtils.fromWorldTime(CraftPresence.player.field_3248.method_3583()), this.worldTimeData)) {
                this.dayCount = newTimeData.getFirst();
                this.timeString24 = TimeUtils.toString(newTimeData.getSecond(), "HH:mm");
                this.timeString12 = TimeUtils.toString(newTimeData.getSecond(), "hh:mm a");
                this.worldTimeData = newTimeData;
                this.queuedForUpdate = true;
            }
            if (newCurrentPlayers != this.currentPlayers || newMaxPlayers != this.maxPlayers) {
                this.currentPlayers = newCurrentPlayers;
                this.maxPlayers = newMaxPlayers;
                this.queuedForUpdate = true;
            }
            if (!newPlayerList.equals(this.currentPlayerList)) {
                this.currentPlayerList = newPlayerList;
                if (CraftPresence.ENTITIES.enabled) {
                    CraftPresence.ENTITIES.ENTITY_NAMES.removeAll(CraftPresence.ENTITIES.PLAYER_BINDINGS.keySet());
                    CraftPresence.ENTITIES.scanForData();
                }
            }
        }
        if (this.queuedForUpdate) {
            this.updatePresence();
        }
    }

    private boolean isInvalidData(String input, List<String> invalidItems) {
        if (!StringUtils.isNullOrEmpty(input)) {
            for (String item : invalidItems) {
                if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item) || !input.equalsIgnoreCase(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isInvalidMotd(String serverMotd) {
        return this.isInvalidData(serverMotd, invalidMotds);
    }

    private boolean isInvalidName(String serverName) {
        return this.isInvalidData(serverName, invalidNames);
    }

    private String makeSecret() {
        String formattedKey = CraftPresence.CLIENT.CLIENT_ID;
        boolean containsServerName = false;
        boolean containsServerIP = false;
        if (!StringUtils.isNullOrEmpty(this.currentServer_Name)) {
            formattedKey = formattedKey + "-" + this.currentServer_Name;
            containsServerName = true;
        }
        if (!StringUtils.isNullOrEmpty(this.currentServer_IP)) {
            formattedKey = formattedKey + "-" + this.currentServer_IP;
            containsServerIP = true;
        }
        formattedKey = formattedKey + ";" + containsServerName + ";" + containsServerIP;
        return formattedKey;
    }

    public void verifyAndJoin(String secret) {
        boolean isValidSecret;
        String[] boolParts = secret.split(";");
        String[] stringParts = boolParts[0].split("-");
        boolean containsValidClientID = StringUtils.elementExists(stringParts, 0) && stringParts[0].length() >= 18 && StringUtils.getValidLong(stringParts[0]).getFirst() != false;
        boolean containsServerName = StringUtils.elementExists(boolParts, 1) && StringUtils.elementExists(stringParts, 1) && Boolean.parseBoolean(boolParts[1]);
        boolean containsServerIP = StringUtils.elementExists(boolParts, 2) && StringUtils.elementExists(stringParts, 2) && Boolean.parseBoolean(boolParts[2]);
        String serverName = containsServerName ? stringParts[1] : CraftPresence.CONFIG.serverSettings.fallbackServerName;
        String serverIP = containsServerIP ? stringParts[2] : "";
        boolean bl = isValidSecret = boolParts.length <= 4 && stringParts.length <= 3 && containsValidClientID;
        if (isValidSecret) {
            CraftPresence.instance.method_6635(() -> this.joinServer(new class_485(serverName, serverIP, false)));
        } else {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.join", secret), new Object[0]);
        }
        CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
    }

    private void joinServer(class_485 serverData) {
        try {
            if (!serverData.field_1691) {
                serverData.field_1691 = true;
                serverData.field_1690 = -2L;
                serverData.field_1689 = "";
                serverData.field_1688 = "";
            }
            if (CraftPresence.player != null) {
                CraftPresence.player.field_3248.method_3577();
                CraftPresence.instance.method_2929(null);
            }
            CraftPresence.instance.method_2928((class_388)new class_472((class_388)(CraftPresence.instance.field_3816 != null ? CraftPresence.instance.field_3816 : new class_624()), CraftPresence.instance, serverData));
        }
        catch (Exception ex) {
            Constants.LOG.debugError(ex);
        }
    }

    @Override
    public void updatePresence() {
        CraftPresence.CLIENT.syncArgument("player.position.x", this.currentCoordinates.getFirst());
        CraftPresence.CLIENT.syncArgument("player.position.y", this.currentCoordinates.getSecond());
        CraftPresence.CLIENT.syncArgument("player.position.z", this.currentCoordinates.getThird());
        CraftPresence.CLIENT.syncArgument("player.health.current", this.currentHealth.getFirst());
        CraftPresence.CLIENT.syncArgument("player.health.max", this.currentHealth.getSecond());
        CraftPresence.CLIENT.syncArgument("world.difficulty", StringUtils.getOrDefault(this.currentDifficulty));
        CraftPresence.CLIENT.syncArgument("world.weather.name", StringUtils.getOrDefault(this.currentWeatherName));
        CraftPresence.CLIENT.syncArgument("world.name", StringUtils.getOrDefault(this.currentWorldName));
        if (this.worldTimeData != null) {
            CraftPresence.CLIENT.syncArgument("world.time.day", this.dayCount);
            CraftPresence.CLIENT.syncArgument("world.time.format_24", this.timeString24);
            CraftPresence.CLIENT.syncArgument("world.time.format_12", this.timeString12);
            CraftPresence.CLIENT.syncArgument("data.world.time.instance", this.worldTimeData);
        } else {
            CraftPresence.CLIENT.removeArguments("world.time", "data.world.time");
        }
        CraftPresence.CLIENT.syncArgument("server.default.icon", CraftPresence.CONFIG.serverSettings.fallbackServerIcon);
        ModuleData resultData = new ModuleData();
        if (!CraftPresence.instance.method_2908() && this.currentServerData != null) {
            String currentIcon;
            CraftPresence.CLIENT.syncArgument("server.players.current", this.currentPlayers);
            CraftPresence.CLIENT.syncArgument("server.players.max", this.maxPlayers);
            String formattedIP = this.currentServer_IP.contains(":") ? StringUtils.formatAddress(this.currentServer_IP, false) : this.currentServer_IP;
            CraftPresence.CLIENT.syncArgument("server.address.full", this.currentServer_IP);
            CraftPresence.CLIENT.syncArgument("server.address.short", formattedIP);
            CraftPresence.CLIENT.syncArgument("server.name", this.currentServer_Name);
            CraftPresence.CLIENT.syncArgument("server.motd.raw", this.currentServer_MOTD);
            if (!this.currentServer_MOTD_Lines.isEmpty()) {
                int index = 1;
                for (String motdPart : this.currentServer_MOTD_Lines) {
                    CraftPresence.CLIENT.syncArgument("data.server.motd.line_" + index, motdPart);
                    ++index;
                }
            }
            ModuleData defaultData = CraftPresence.CONFIG.serverSettings.serverData.get("default");
            ModuleData alternateData = CraftPresence.CONFIG.serverSettings.serverData.get(this.currentServer_Name);
            ModuleData primaryData = CraftPresence.CONFIG.serverSettings.serverData.get(formattedIP);
            String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : "";
            String alternateIcon = Config.isValidProperty(alternateData, "iconOverride") ? alternateData.getIconOverride() : defaultIcon;
            String string = currentIcon = Config.isValidProperty(primaryData, "iconOverride") ? primaryData.getIconOverride() : alternateIcon;
            resultData = primaryData != null ? primaryData : (alternateData != null ? alternateData : defaultData);
            this.currentServerIcon = currentIcon;
            if (StringUtils.isNullOrEmpty(this.currentServerIcon)) {
                this.currentServerIcon = CraftPresence.CLIENT.addEndpointIcon(CraftPresence.CONFIG, CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, formattedIP) ? formattedIP : this.currentServer_Name;
            }
            if (this.isOnLAN) {
                resultData = CraftPresence.CONFIG.statusMessages.lanData;
                this.currentServerMessage = Config.isValidProperty(resultData, "textOverride") ? resultData.getTextOverride() : "";
                this.currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
            } else {
                String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
                String alternateMessage = alternateData != null && Config.isValidProperty(alternateData, "textOverride") ? alternateData.getTextOverride() : defaultMessage;
                String string2 = this.currentServerMessage = primaryData != null && Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : alternateMessage;
                if (CraftPresence.CONFIG.generalSettings.enableJoinRequests) {
                    CraftPresence.CLIENT.PARTY_ID = !StringUtils.isNullOrEmpty(this.currentServer_Name) && !this.currentServer_Name.equalsIgnoreCase(CraftPresence.CONFIG.serverSettings.fallbackServerName) ? "Join Server: " + this.currentServer_Name : "Join Server: " + this.currentServer_IP;
                    CraftPresence.CLIENT.JOIN_SECRET = this.makeSecret();
                    CraftPresence.CLIENT.PARTY_SIZE = this.currentPlayers;
                    CraftPresence.CLIENT.PARTY_MAX = this.maxPlayers;
                    CraftPresence.CLIENT.PARTY_PRIVACY = PartyPrivacy.from(CraftPresence.CONFIG.generalSettings.partyPrivacyLevel % 2);
                }
            }
        } else if (CraftPresence.instance.method_2908()) {
            resultData = CraftPresence.CONFIG.statusMessages.singleplayerData;
            this.currentServerMessage = Config.isValidProperty(resultData, "textOverride") ? resultData.getTextOverride() : "";
            this.currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
        }
        String formattedIcon = CraftPresence.CLIENT.imageOf("server.icon", true, this.currentServerIcon, CraftPresence.CONFIG.serverSettings.fallbackServerIcon);
        CraftPresence.CLIENT.syncOverride(resultData, "server.message", "server.icon");
        CraftPresence.CLIENT.syncArgument("server.message", this.currentServerMessage);
        CraftPresence.CLIENT.syncArgument("server.icon", formattedIcon);
        this.queuedForUpdate = false;
    }

    @Override
    public void getAllData() {
        try {
            class_486 serverList = new class_486(CraftPresence.instance);
            serverList.method_1273();
            this.serverIndex = serverList.method_1281();
            for (int currentIndex = 0; currentIndex < this.serverIndex; ++currentIndex) {
                String formattedIP;
                class_485 data = serverList.method_1274(currentIndex);
                if (StringUtils.isNullOrEmpty(data.field_1687)) continue;
                String string = formattedIP = data.field_1687.contains(":") ? StringUtils.formatAddress(data.field_1687, false) : data.field_1687;
                if (!this.defaultAddresses.contains(formattedIP)) {
                    this.defaultAddresses.add(formattedIP);
                }
                if (!this.knownAddresses.contains(formattedIP)) {
                    this.knownAddresses.add(formattedIP);
                }
                if (this.knownServerData.containsKey(data.field_1687)) continue;
                this.knownServerData.put(data.field_1687, data);
            }
        }
        catch (Exception ex) {
            Constants.LOG.debugError(ex);
        }
        for (String serverEntry : CraftPresence.CONFIG.serverSettings.serverData.keySet()) {
            if (StringUtils.isNullOrEmpty(serverEntry) || this.knownAddresses.contains(serverEntry)) continue;
            this.knownAddresses.add(serverEntry);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        if (state && !this.isInUse) {
            CraftPresence.CLIENT.syncTimestamp("data.server.time");
        }
        this.isInUse = state;
    }

    public class_485 getDataFromName(String serverAddress) {
        return this.knownServerData.getOrDefault(serverAddress, null);
    }
}

