/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.DiscordUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.entity.EntityUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.entity.TileEntityUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.server.ServerUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.world.BiomeUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.world.DimensionUtils;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.MappingUtils;
import io.github.cdagaming.unicore.utils.OSUtils;
import io.github.cdagaming.unicore.utils.ScheduleUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import net.minecraft.class_1600;
import net.minecraft.class_355;
import net.minecraft.class_988;

@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class CraftPresence {
    public static final KeyUtils KEYBINDINGS = new KeyUtils();
    public static final DiscordUtils CLIENT = new DiscordUtils();
    public static final ServerUtils SERVER = new ServerUtils();
    public static final BiomeUtils BIOMES = new BiomeUtils();
    public static final DimensionUtils DIMENSIONS = new DimensionUtils();
    public static final EntityUtils ENTITIES = new EntityUtils();
    public static final TileEntityUtils TILE_ENTITIES = new TileEntityUtils();
    public static final GuiUtils GUIS = new GuiUtils();
    public static class_1600 instance;
    public static class_355 session;
    public static class_988 player;
    public static Config CONFIG;
    public static final ScheduleUtils SCHEDULER;
    private final Runnable initCallback;
    private boolean initialized = false;

    public CraftPresence(Runnable callback) {
        this.initCallback = callback;
        this.scheduleTick();
    }

    public CraftPresence() {
        this(null);
    }

    private void init() {
        CommandUtils.updateModes();
        FileUtils.detectClasses();
        MappingUtils.getClassMap();
        Constants.LOG.debugWarn(Constants.TRANSLATOR.translate("craftpresence.logger.warning.debug_mode", new Object[0]), new Object[0]);
        Constants.LOG.debugInfo(Constants.TRANSLATOR.translate("craftpresence.logger.info.os", OSUtils.OS_NAME, OSUtils.OS_ARCH, OSUtils.IS_64_BIT), new Object[0]);
        ModUtils.UPDATER.checkForUpdates();
        CONFIG = Config.getInstance();
        CommandUtils.init();
        CLIENT.setup();
        CommandUtils.setupRPC();
        if (this.initCallback != null) {
            this.initCallback.run();
        }
        this.initialized = true;
    }

    private void scheduleTick() {
        if (!Constants.IS_GAME_CLOSING) {
            Constants.getThreadPool().scheduleAtFixedRate(this::clientTick, 0L, 50L, TimeUtils.getTimeUnitFrom("MILLISECONDS"));
        }
    }

    private void clientTick() {
        if (!Constants.IS_GAME_CLOSING) {
            instance = class_1600.method_2965();
            if (this.initialized) {
                session = instance.method_5568();
                player = CraftPresence.instance.field_10310;
                CommandUtils.reloadData(false);
            } else if (instance != null && (session = instance.method_5568()) != null) {
                this.init();
            }
        }
    }

    static {
        SCHEDULER = new ScheduleUtils(CommandUtils::onTick);
    }
}

