/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.element;

import com.gitlab.cdagaming.craftpresence.core.config.Module;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import java.io.Serializable;

public class ColorSection
extends Module
implements Serializable {
    private static final ColorSection DEFAULT = new ColorSection();
    public int red;
    public int green;
    public int blue;
    public int alpha;

    public ColorSection(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public ColorSection(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public ColorSection(ColorSection other) {
        this(other.red, other.green, other.blue, other.alpha);
    }

    public ColorSection() {
        this(Color.white);
    }

    public Color getColor() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    @Override
    public ColorSection getDefaults() {
        return new ColorSection(DEFAULT);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof ColorSection && !this.equals(target)) {
            ColorSection data = (ColorSection)target;
            this.red = data.red;
            this.green = data.green;
            this.blue = data.blue;
            this.alpha = data.alpha;
        }
    }

    @Override
    public ColorSection copy() {
        return new ColorSection(this);
    }

    @Override
    public Object getProperty(String name) {
        return StringUtils.getField(ColorSection.class, this, name);
    }

    @Override
    public void setProperty(String name, Object value) {
        StringUtils.updateField(ColorSection.class, this, value, name);
    }
}

