/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.redcore.math;

import net.jafama.FastMath;

public final class MathUtil {
    public static float absolute(float input) {
        return input >= 0.0f ? input : -input;
    }

    public static double absolute(double input) {
        return input >= 0.0 ? input : -input;
    }

    public static float absoluteMax(float input1, float input2) {
        return Math.max(input1 >= 0.0f ? input1 : -input1, input2 >= 0.0f ? input2 : -input2);
    }

    public static double absoluteMax(double input1, double input2) {
        return Math.max(input1 >= 0.0 ? input1 : -input1, input2 >= 0.0 ? input2 : -input2);
    }

    public static float addOrSubtractBasedOnSign(float input, float add) {
        return input < 0.0f ? input - add : input + add;
    }

    public static double addOrSubtractBasedOnSign(double input, double add) {
        return input < 0.0 ? input - add : input + add;
    }

    public static float round(float input, int decimals) {
        float multiplier = (float)FastMath.pow(10.0, decimals);
        int rounded = FastMath.round(input * multiplier);
        return (float)rounded / multiplier;
    }

    public static double round(double input, int decimals) {
        double multiplier = FastMath.pow(10.0, decimals);
        long rounded = FastMath.round(input * multiplier);
        return (double)rounded / multiplier;
    }

    public static int floorToInt(float input) {
        int floored = (int)input;
        return input < (float)floored ? floored - 1 : floored;
    }

    public static int floorToInt(double input) {
        int floored = (int)input;
        return input < (double)floored ? floored - 1 : floored;
    }

    public static float lerp(float startValue, float partialTicks, float targetValue) {
        return startValue + (targetValue - startValue) * partialTicks;
    }

    public static double lerp(double startValue, double partialTicks, double targetValue) {
        return startValue + (targetValue - startValue) * partialTicks;
    }

    public static int boolToInt(boolean input) {
        return input ? 1 : 0;
    }
}

