/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class AdjacencyGraph<T> {
    private HashMap<T, HashSet<T>> adjacencyMatrix = new HashMap();

    public void add(T object, HashSet<T> adjNodes) {
        if (!this.contains(object)) {
            this.adjacencyMatrix.put(object, adjNodes);
            for (T adjNode : adjNodes) {
                this.adjacencyMatrix.get(adjNode).add(object);
            }
        }
    }

    public boolean contains(T node) {
        return this.adjacencyMatrix.get(node) != null;
    }

    public boolean isNeighbor(T a, T b) {
        HashSet<T> set = this.adjacencyMatrix.get(a);
        if (set != null) {
            return set.contains(b);
        }
        return false;
    }

    public final Set<T> getKeys() {
        return this.adjacencyMatrix.keySet();
    }

    public HashSet<T> getAllNodesConnectedToNode(T node) {
        HashSet removableNodes = new HashSet();
        this.getAllNodesConnectedToBlock(node, removableNodes);
        return removableNodes;
    }

    private void getAllNodesConnectedToBlock(T node, HashSet<T> removableNodes) {
        Stack<T> stack = new Stack<T>();
        stack.push(node);
        removableNodes.add(node);
        while (!stack.isEmpty()) {
            Object stackElement = stack.pop();
            for (T nextElement : this.adjacencyMatrix.get(stackElement)) {
                if (removableNodes.contains(nextElement)) continue;
                stack.push(nextElement);
                removableNodes.add(nextElement);
            }
        }
    }

    private boolean findPathToBlock(T from, T to, HashSet<T> removableNodes) {
        Stack<T> stack = new Stack<T>();
        stack.push(from);
        while (!stack.isEmpty()) {
            Object stackElement = stack.pop();
            removableNodes.add(stackElement);
            for (T nextElement : this.adjacencyMatrix.get(stackElement)) {
                if (nextElement == null) {
                    return false;
                }
                if (to.equals(nextElement)) {
                    return true;
                }
                if (removableNodes.contains(nextElement)) continue;
                stack.push(nextElement);
            }
        }
        return false;
    }

    public boolean doesPathExist(T from, T to) {
        HashSet pos = new HashSet();
        return this.findPathToBlock(from, to, pos);
    }

    public Collection<T> removeAllNodesConnectedTo(T node) {
        HashSet<T> removableNode = this.getAllNodesConnectedToNode(node);
        for (T t : removableNode) {
            this.adjacencyMatrix.remove(t);
        }
        return removableNode;
    }

    public void remove(T node) {
        HashSet<T> set = this.adjacencyMatrix.get(node);
        if (set != null) {
            for (T t : set) {
                this.adjacencyMatrix.get(t).remove(node);
            }
        }
        this.adjacencyMatrix.remove(node);
    }

    public void clear() {
        this.adjacencyMatrix.clear();
    }

    public int size() {
        return this.adjacencyMatrix.size();
    }
}

