/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.common.utils.TektopiaUtils;
import bletch.tektopiainformation.network.data.EntityData;
import bletch.tektopiainformation.network.data.ResidentData;
import bletch.tektopiainformation.network.data.VillageData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.entities.EntityArchitect;
import net.tangotek.tektopia.entities.EntityGuard;
import net.tangotek.tektopia.entities.EntityTradesman;
import net.tangotek.tektopia.entities.EntityVillagerTek;

public class ResidentsData {
    protected static final String NBTTAG_VILLAGE_RESIDENTS = "residents";
    protected static final String NBTTAG_VILLAGE_RESIDENTSLIST = "list";
    protected static final String NBTTAG_VILLAGE_RESIDENTSPROFESSIONCOUNTS = "profs";
    protected static final String NBTTAG_VILLAGE_RESIDENTSPROFESSIONNAME = "name";
    protected static final String NBTTAG_VILLAGE_RESIDENTSPROFESSIONCOUNT = "count";
    protected static final String NBTTAG_VILLAGE_RESIDENTADULTCOUNT = "adults";
    protected static final String NBTTAG_VILLAGE_RESIDENTCHILDCOUNT = "childs";
    protected static final String NBTTAG_VILLAGE_RESIDENTMALECOUNT = "males";
    protected static final String NBTTAG_VILLAGE_RESIDENTFEMALECOUNT = "females";
    public static final int STATISTICS_RANGE = 20;
    protected VillageData villageData;
    protected List<ResidentData> residents;
    protected Map<String, Integer> professionTypeCounts;
    protected int adultCount = 0;
    protected int childCount = 0;
    protected int maleCount = 0;
    protected int femaleCount = 0;

    public ResidentsData() {
        this.populateData(null, null);
    }

    protected VillageData getVillageData() {
        return this.villageData;
    }

    public int getResidentsCount() {
        return (int)this.residents.stream().filter(r -> !r.getProfessionType().equals("ARCHITECT") && !r.getProfessionType().equals("TRADESMAN")).count();
    }

    public int getResidentsCountAll() {
        return this.residents == null ? 0 : this.residents.size();
    }

    public List<ResidentData> getResidents() {
        return this.residents == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.residents.stream().sorted(Comparator.comparing(EntityData::getName)).collect(Collectors.toList()));
    }

    public List<ResidentData> getResidentsByType(String professionType, Boolean sortByLevel) {
        return this.residents == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.residents.stream().filter(r -> professionType != null && professionType.toUpperCase().equals(r.getProfessionType())).sorted((c1, c2) -> {
            int compare = sortByLevel != false ? Integer.compare(c2.getBaseLevel(), c1.getBaseLevel()) : 0;
            return compare != 0 ? compare : c1.getName().compareTo(c2.getName());
        }).collect(Collectors.toList()));
    }

    public ResidentData getResident(int index) {
        return this.residents == null ? null : this.residents.get(index);
    }

    public ResidentData getResidentById(int residentId) {
        return this.residents == null ? null : (ResidentData)this.residents.stream().filter(r -> r.getId() == residentId).findFirst().orElse(null);
    }

    public ResidentData getResidentByBedPosition(BlockPos bedPosition) {
        return this.residents == null ? null : (ResidentData)this.residents.stream().filter(r -> bedPosition != null && bedPosition.equals((Object)r.getBedPosition())).findFirst().orElse(null);
    }

    public Map<String, Integer> getProfessionTypeCounts() {
        return this.professionTypeCounts == null ? Collections.unmodifiableMap(new LinkedHashMap()) : Collections.unmodifiableMap(this.professionTypeCounts.entrySet().stream().filter(e -> (Integer)e.getValue() > 0 && !((String)e.getKey()).equals("ARCHITECT") && !((String)e.getKey()).equals("TRADESMAN")).sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)));
    }

    public Map<String, Integer> getProfessionTypeCountsAll() {
        return this.professionTypeCounts == null ? Collections.unmodifiableMap(new LinkedHashMap()) : Collections.unmodifiableMap(this.professionTypeCounts.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)));
    }

    public int getProfessionTypeCount(String professionType) {
        return professionType != null && this.professionTypeCounts != null && this.professionTypeCounts.containsKey(professionType.toUpperCase()) ? this.professionTypeCounts.get(professionType.toUpperCase()) : 0;
    }

    public int getAdultCount() {
        return this.adultCount;
    }

    public int getChildCount() {
        return this.childCount;
    }

    public int getMaleCount() {
        return this.maleCount;
    }

    public int getFemaleCount() {
        return this.femaleCount;
    }

    public int getNoBedCount() {
        int[] total = new int[]{0};
        if (this.residents != null) {
            this.residents.forEach(h -> {
                total[0] = total[0] + (!h.getCanHaveBed() || h.hasBed() ? 0 : 1);
            });
        }
        return total[0];
    }

    public Map<Integer, List<ResidentData>> getResidentHappinessStatistics() {
        int rangeIndex = 0;
        LinkedHashMap<Integer, List<ResidentData>> result = new LinkedHashMap<Integer, List<ResidentData>>();
        result.put(20 * rangeIndex++, new ArrayList());
        result.put(20 * rangeIndex++, new ArrayList());
        result.put(20 * rangeIndex++, new ArrayList());
        result.put(20 * rangeIndex++, new ArrayList());
        result.put(20 * rangeIndex++, new ArrayList());
        result.put(20 * rangeIndex++, new ArrayList());
        if (this.residents != null) {
            this.residents.forEach(r -> {
                int key = result.keySet().stream().filter(k -> r.getHappy() <= k).findFirst().orElse(-1);
                if (key > -1) {
                    ((List)result.get(key)).add(r);
                }
            });
        }
        for (Map.Entry entry : result.entrySet()) {
            if (entry == null) continue;
            ((List)entry.getValue()).sort(Comparator.comparingInt(ResidentData::getHappy).thenComparing(EntityData::getName));
        }
        return result;
    }

    public Map<Integer, List<ResidentData>> getResidentHungerStatistics() {
        int rangeIndex = 0;
        LinkedHashMap<Integer, List<ResidentData>> result = new LinkedHashMap<Integer, List<ResidentData>>();
        result.put(20 * rangeIndex++, new ArrayList());
        result.put(20 * rangeIndex++, new ArrayList());
        result.put(20 * rangeIndex++, new ArrayList());
        result.put(20 * rangeIndex++, new ArrayList());
        result.put(20 * rangeIndex++, new ArrayList());
        result.put(20 * rangeIndex++, new ArrayList());
        if (this.residents != null) {
            this.residents.forEach(r -> {
                int key = result.keySet().stream().filter(k -> r.getHunger() <= k).findFirst().orElse(-1);
                if (key > -1) {
                    ((List)result.get(key)).add(r);
                }
            });
        }
        for (Map.Entry entry : result.entrySet()) {
            if (entry == null) continue;
            ((List)entry.getValue()).sort(Comparator.comparingInt(ResidentData::getHunger).thenComparing(EntityData::getName));
        }
        return result;
    }

    public ResidentData getArchitect() {
        return this.residents == null ? null : (ResidentData)this.residents.stream().filter(r -> r.getProfessionType().equals("ARCHITECT")).findFirst().orElse(null);
    }

    public ResidentData getTradesman() {
        return this.residents == null ? null : (ResidentData)this.residents.stream().filter(r -> r.getProfessionType().equals("TRADESMAN")).findFirst().orElse(null);
    }

    protected void clearData() {
        this.residents = new ArrayList<ResidentData>();
        this.professionTypeCounts = new HashMap<String, Integer>();
        this.adultCount = 0;
        this.childCount = 0;
        this.maleCount = 0;
        this.femaleCount = 0;
    }

    public void populateData(VillageData villageData, Village village) {
        this.clearData();
        this.villageData = villageData;
        if (village != null) {
            List<EntityVillagerTek> villageResidents = TektopiaUtils.getVillageResidents(village);
            for (String professionType : TektopiaUtils.getProfessionTypeNames(true)) {
                this.professionTypeCounts.put(professionType, 0);
            }
            for (EntityVillagerTek resident : villageResidents) {
                if (resident.field_70128_L) continue;
                this.residents.add(new ResidentData(resident));
                ProfessionType professionType = resident.getProfessionType();
                if (resident instanceof EntityGuard && ((EntityGuard)resident).isCaptain()) {
                    professionType = ProfessionType.CAPTAIN;
                }
                this.professionTypeCounts.put(professionType.name(), this.professionTypeCounts.get(professionType.name()) + 1);
                if (professionType == ProfessionType.CHILD) {
                    ++this.childCount;
                } else {
                    ++this.adultCount;
                }
                if (resident.isMale()) {
                    ++this.maleCount;
                    continue;
                }
                ++this.femaleCount;
            }
            AxisAlignedBB villageAABB = village.getAABB().func_186662_g(120.0);
            List villageArchitects = village.getWorld().func_72872_a(EntityArchitect.class, villageAABB);
            for (EntityVillagerTek entity : villageArchitects) {
                if (entity.field_70128_L) continue;
                this.professionTypeCounts.put("ARCHITECT", this.professionTypeCounts.get("ARCHITECT") + 1);
                this.residents.add(new ResidentData(entity));
                ++this.adultCount;
                if (entity.isMale()) {
                    ++this.maleCount;
                    continue;
                }
                ++this.femaleCount;
            }
            List villageTradesmen = village.getWorld().func_72872_a(EntityTradesman.class, villageAABB);
            for (EntityVillagerTek entity : villageTradesmen) {
                if (entity.field_70128_L) continue;
                this.professionTypeCounts.put("TRADESMAN", this.professionTypeCounts.get("TRADESMAN") + 1);
                this.residents.add(new ResidentData(entity));
                ++this.adultCount;
                if (entity.isMale()) {
                    ++this.maleCount;
                    continue;
                }
                ++this.femaleCount;
            }
        }
    }

    public void readNBT(VillageData villageData, NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        this.villageData = villageData;
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTS)) {
            int index;
            NBTTagCompound nbtResidentsData = nbtTag.func_74775_l(NBTTAG_VILLAGE_RESIDENTS);
            if (nbtResidentsData.func_74764_b(NBTTAG_VILLAGE_RESIDENTSLIST)) {
                NBTTagList nbtTagListResidents = nbtResidentsData.func_150295_c(NBTTAG_VILLAGE_RESIDENTSLIST, 10);
                for (index = 0; index < nbtTagListResidents.func_74745_c(); ++index) {
                    this.residents.add(new ResidentData(nbtTagListResidents.func_150305_b(index)));
                }
            }
            if (nbtResidentsData.func_74764_b(NBTTAG_VILLAGE_RESIDENTSPROFESSIONCOUNTS)) {
                NBTTagList nbtTagProfessionCounts = nbtResidentsData.func_150295_c(NBTTAG_VILLAGE_RESIDENTSPROFESSIONCOUNTS, 10);
                for (index = 0; index < nbtTagProfessionCounts.func_74745_c(); ++index) {
                    NBTTagCompound nbtTagProfessionCount = nbtTagProfessionCounts.func_150305_b(index);
                    this.professionTypeCounts.put(nbtTagProfessionCount.func_74779_i(NBTTAG_VILLAGE_RESIDENTSPROFESSIONNAME), nbtTagProfessionCount.func_74762_e(NBTTAG_VILLAGE_RESIDENTSPROFESSIONCOUNT));
                }
            }
            this.adultCount = nbtResidentsData.func_74764_b(NBTTAG_VILLAGE_RESIDENTADULTCOUNT) ? nbtResidentsData.func_74762_e(NBTTAG_VILLAGE_RESIDENTADULTCOUNT) : 0;
            this.childCount = nbtResidentsData.func_74764_b(NBTTAG_VILLAGE_RESIDENTCHILDCOUNT) ? nbtResidentsData.func_74762_e(NBTTAG_VILLAGE_RESIDENTCHILDCOUNT) : 0;
            this.maleCount = nbtResidentsData.func_74764_b(NBTTAG_VILLAGE_RESIDENTMALECOUNT) ? nbtResidentsData.func_74762_e(NBTTAG_VILLAGE_RESIDENTMALECOUNT) : 0;
            this.femaleCount = nbtResidentsData.func_74764_b(NBTTAG_VILLAGE_RESIDENTFEMALECOUNT) ? nbtResidentsData.func_74762_e(NBTTAG_VILLAGE_RESIDENTFEMALECOUNT) : 0;
        }
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        NBTTagCompound nbtResidentsData = new NBTTagCompound();
        if (this.professionTypeCounts != null && this.professionTypeCounts.size() > 0) {
            NBTTagList nbtTagListProfessionCounts = new NBTTagList();
            for (Map.Entry entry : this.professionTypeCounts.entrySet()) {
                NBTTagCompound nbtTagProfessionCount = new NBTTagCompound();
                nbtTagProfessionCount.func_74778_a(NBTTAG_VILLAGE_RESIDENTSPROFESSIONNAME, (String)entry.getKey());
                nbtTagProfessionCount.func_74768_a(NBTTAG_VILLAGE_RESIDENTSPROFESSIONCOUNT, ((Integer)entry.getValue()).intValue());
                nbtTagListProfessionCounts.func_74742_a((NBTBase)nbtTagProfessionCount);
            }
            if (!nbtTagListProfessionCounts.func_82582_d()) {
                nbtResidentsData.func_74782_a(NBTTAG_VILLAGE_RESIDENTSPROFESSIONCOUNTS, (NBTBase)nbtTagListProfessionCounts);
            }
        }
        if (this.residents != null && this.residents.size() > 0) {
            NBTTagList nbtTagListResidents = new NBTTagList();
            for (ResidentData residentData : this.residents) {
                NBTTagCompound nbtTagResident = residentData.writeNBT(new NBTTagCompound());
                if (nbtTagResident.func_82582_d()) continue;
                nbtTagListResidents.func_74742_a((NBTBase)nbtTagResident);
            }
            if (!nbtTagListResidents.func_82582_d()) {
                nbtResidentsData.func_74782_a(NBTTAG_VILLAGE_RESIDENTSLIST, (NBTBase)nbtTagListResidents);
            }
        }
        if (this.adultCount > 0) {
            nbtResidentsData.func_74768_a(NBTTAG_VILLAGE_RESIDENTADULTCOUNT, this.adultCount);
        }
        if (this.childCount > 0) {
            nbtResidentsData.func_74768_a(NBTTAG_VILLAGE_RESIDENTCHILDCOUNT, this.childCount);
        }
        if (this.maleCount > 0) {
            nbtResidentsData.func_74768_a(NBTTAG_VILLAGE_RESIDENTMALECOUNT, this.maleCount);
        }
        if (this.femaleCount > 0) {
            nbtResidentsData.func_74768_a(NBTTAG_VILLAGE_RESIDENTFEMALECOUNT, this.femaleCount);
        }
        if (!nbtResidentsData.func_82582_d()) {
            nbtTag.func_74782_a(NBTTAG_VILLAGE_RESIDENTS, (NBTBase)nbtResidentsData);
        }
        return nbtTag;
    }
}

