/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.common.utils.TektopiaUtils;
import bletch.tektopiainformation.network.data.ResidentData;
import bletch.tektopiainformation.network.data.VillageData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.structures.VillageStructure;
import net.tangotek.tektopia.structures.VillageStructureBarracks;
import net.tangotek.tektopia.structures.VillageStructureHome;
import net.tangotek.tektopia.structures.VillageStructureType;

public class HomeData {
    protected static final String NBTTAG_VILLAGE_HOMEID = "id";
    protected static final String NBTTAG_VILLAGE_HOMETYPE = "type";
    protected static final String NBTTAG_VILLAGE_HOMEPOSITION = "pos";
    protected static final String NBTTAG_VILLAGE_HOMEVALID = "valid";
    protected static final String NBTTAG_VILLAGE_HOMEFLOORTILECOUNT = "tiles";
    protected static final String NBTTAG_VILLAGE_HOMETILESPERVILLAGER = "tilesper";
    protected static final String NBTTAG_VILLAGE_HOMEMAXBEDS = "maxbeds";
    protected static final String NBTTAG_VILLAGE_HOMERESIDENTS = "residents";
    protected static final String NBTTAG_VILLAGE_HOMEBEDPOSITIONS = "beds";
    protected static final String NBTTAG_VILLAGE_HOMEBEDPOSITION = "bedpos";
    protected static final Random rand = new Random();
    protected VillageData villageData;
    protected int homeId;
    protected VillageStructureType structureType;
    protected BlockPos framePosition;
    protected boolean isValid;
    protected int floorTileCount;
    protected int maxBeds;
    protected int tilesPerVillager;
    protected List<ResidentData> residents;
    protected List<BlockPos> bedPositions;

    public HomeData(VillageData villageData, VillageStructure structure) {
        this.villageData = villageData;
        this.populateData(structure);
    }

    public HomeData(VillageData villageData, NBTTagCompound nbtTag) {
        this.villageData = villageData;
        this.readNBT(nbtTag);
    }

    protected VillageData getVillageData() {
        return this.villageData;
    }

    public int getHomeId() {
        return this.homeId;
    }

    public VillageStructureType getStructureType() {
        return this.structureType;
    }

    public String getStructureTypeName() {
        return this.structureType != null && this.structureType.itemStack != null ? this.structureType.itemStack.func_82833_r() : "";
    }

    public BlockPos getFramePosition() {
        return this.framePosition;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getFloorTileCount() {
        return this.floorTileCount;
    }

    public int getMaxBeds() {
        return this.maxBeds;
    }

    public int getTilesPerVillager() {
        return this.tilesPerVillager;
    }

    public int getResidentsCount() {
        return this.residents == null ? 0 : this.residents.size();
    }

    public boolean isFull() {
        return this.residents.size() >= this.maxBeds;
    }

    public List<ResidentData> getResidents() {
        return this.residents == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.residents);
    }

    public ResidentData getResidentByBedPosition(BlockPos bedPosition) {
        return this.residents == null ? null : (ResidentData)this.residents.stream().filter(r -> bedPosition != null && bedPosition.equals((Object)r.getBedPosition())).findFirst().orElse(null);
    }

    public int getBedCount() {
        return this.bedPositions == null ? 0 : this.bedPositions.size();
    }

    public List<BlockPos> getBedPositions() {
        return this.bedPositions == null ? new ArrayList<BlockPos>() : Collections.unmodifiableList(this.bedPositions.stream().sorted((c1, c2) -> c1.compareTo((Vec3i)c2)).collect(Collectors.toList()));
    }

    public boolean hasBedPosition(BlockPos bedPosition) {
        return this.bedPositions != null && bedPosition != null && this.bedPositions.stream().anyMatch(p -> bedPosition.equals(p));
    }

    public int getAdultCount() {
        return this.residents == null ? 0 : (int)this.residents.stream().filter(r -> !r.isChild()).count();
    }

    public int getChildCount() {
        return this.residents == null ? 0 : (int)this.residents.stream().filter(r -> r.isChild()).count();
    }

    public int getMaleCount() {
        return this.residents == null ? 0 : (int)this.residents.stream().filter(r -> r.isMale()).count();
    }

    public int getFemaleCount() {
        return this.residents == null ? 0 : (int)this.residents.stream().filter(r -> !r.isMale()).count();
    }

    public int getDensityRatio() {
        if (this.tilesPerVillager == 0 || this.maxBeds == 0) {
            return 0;
        }
        return this.floorTileCount / this.maxBeds;
    }

    public Boolean isOvercrowded() {
        if (this.tilesPerVillager == 0 || this.maxBeds == 0) {
            return false;
        }
        int densityRatio = this.floorTileCount / this.maxBeds;
        return densityRatio < this.tilesPerVillager;
    }

    protected void clearData() {
        this.homeId = rand.nextInt();
        this.structureType = null;
        this.framePosition = null;
        this.isValid = false;
        this.floorTileCount = 0;
        this.maxBeds = 0;
        this.tilesPerVillager = 0;
        this.residents = new ArrayList<ResidentData>();
        this.bedPositions = new ArrayList<BlockPos>();
    }

    protected void populateData(VillageStructure structure) {
        this.clearData();
        List<VillageStructureType> homeTypes = TektopiaUtils.getVillageHomeTypes();
        if (structure != null && homeTypes != null && homeTypes.contains(structure.type)) {
            this.homeId = structure.getItemFrame().func_145782_y();
            this.structureType = structure.type;
            this.framePosition = structure.getFramePos();
            this.isValid = structure.isValid();
            List<BlockPos> floorTiles = TektopiaUtils.getStructureFloorTiles(structure);
            this.floorTileCount = floorTiles == null ? 0 : floorTiles.size();
            this.tilesPerVillager = structure.type.tilesPerVillager;
            if (structure instanceof VillageStructureBarracks) {
                VillageStructureBarracks barracks = (VillageStructureBarracks)structure;
                this.maxBeds = TektopiaUtils.getStructureMaxBeds(barracks);
                for (EntityVillagerTek resident : barracks.getResidents()) {
                    this.residents.add(new ResidentData(resident));
                }
                this.bedPositions = new ArrayList<BlockPos>(barracks.getSpecialBlocks(Blocks.field_150324_C));
            } else if (structure instanceof VillageStructureHome) {
                VillageStructureHome home = (VillageStructureHome)structure;
                this.maxBeds = TektopiaUtils.getStructureMaxBeds(home);
                for (EntityVillagerTek resident : home.getResidents()) {
                    this.residents.add(new ResidentData(resident));
                }
                this.bedPositions = new ArrayList<BlockPos>(home.getSpecialBlocks(Blocks.field_150324_C));
            }
        }
    }

    public void readNBT(NBTTagCompound nbtTag) {
        int index;
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        this.homeId = nbtTag.func_74764_b(NBTTAG_VILLAGE_HOMEID) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_HOMEID) : rand.nextInt();
        this.structureType = nbtTag.func_74764_b(NBTTAG_VILLAGE_HOMETYPE) ? VillageStructureType.valueOf((String)nbtTag.func_74779_i(NBTTAG_VILLAGE_HOMETYPE)) : null;
        this.framePosition = nbtTag.func_74764_b(NBTTAG_VILLAGE_HOMEPOSITION) ? BlockPos.func_177969_a((long)nbtTag.func_74763_f(NBTTAG_VILLAGE_HOMEPOSITION)) : null;
        this.isValid = nbtTag.func_74764_b(NBTTAG_VILLAGE_HOMEVALID) && nbtTag.func_74767_n(NBTTAG_VILLAGE_HOMEVALID);
        this.floorTileCount = nbtTag.func_74764_b(NBTTAG_VILLAGE_HOMEFLOORTILECOUNT) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_HOMEFLOORTILECOUNT) : 0;
        this.tilesPerVillager = nbtTag.func_74764_b(NBTTAG_VILLAGE_HOMETILESPERVILLAGER) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_HOMETILESPERVILLAGER) : 0;
        int n = this.maxBeds = nbtTag.func_74764_b(NBTTAG_VILLAGE_HOMEMAXBEDS) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_HOMEMAXBEDS) : 0;
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_HOMERESIDENTS)) {
            NBTTagList nbtTagListResidents = nbtTag.func_150295_c(NBTTAG_VILLAGE_HOMERESIDENTS, 3);
            for (index = 0; index < nbtTagListResidents.func_74745_c(); ++index) {
                int nbtTagId = nbtTagListResidents.func_186858_c(index);
                if (this.villageData == null) continue;
                ResidentData resident = this.villageData.getResidentsData().getResidentById(nbtTagId);
                if (resident == null) {
                    resident = this.villageData.getVisitorsData().getVisitorById(nbtTagId);
                }
                if (resident == null) continue;
                this.residents.add(resident);
            }
        }
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_HOMEBEDPOSITIONS)) {
            NBTTagList nbtTagListBedPositions = nbtTag.func_150295_c(NBTTAG_VILLAGE_HOMEBEDPOSITIONS, 10);
            for (index = 0; index < nbtTagListBedPositions.func_74745_c(); ++index) {
                NBTTagCompound nbtTagBedPosition = nbtTagListBedPositions.func_150305_b(index);
                this.bedPositions.add(BlockPos.func_177969_a((long)nbtTagBedPosition.func_74763_f(NBTTAG_VILLAGE_HOMEBEDPOSITION)));
            }
        }
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        nbtTag.func_74768_a(NBTTAG_VILLAGE_HOMEID, this.homeId);
        if (this.structureType != null) {
            nbtTag.func_74778_a(NBTTAG_VILLAGE_HOMETYPE, this.structureType.name());
        }
        if (this.framePosition != null) {
            nbtTag.func_74772_a(NBTTAG_VILLAGE_HOMEPOSITION, this.framePosition.func_177986_g());
        }
        if (this.isValid) {
            nbtTag.func_74757_a(NBTTAG_VILLAGE_HOMEVALID, this.isValid);
        }
        if (this.floorTileCount > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_HOMEFLOORTILECOUNT, this.floorTileCount);
        }
        if (this.tilesPerVillager > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_HOMETILESPERVILLAGER, this.tilesPerVillager);
        }
        if (this.maxBeds > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_HOMEMAXBEDS, this.maxBeds);
        }
        if (this.residents != null) {
            NBTTagList nbtTagListResidents = new NBTTagList();
            for (ResidentData resident : this.residents) {
                nbtTagListResidents.func_74742_a((NBTBase)new NBTTagInt(resident.getId()));
            }
            if (!nbtTagListResidents.func_82582_d()) {
                nbtTag.func_74782_a(NBTTAG_VILLAGE_HOMERESIDENTS, (NBTBase)nbtTagListResidents);
            }
        }
        if (this.bedPositions != null) {
            NBTTagList nbtTagListBedPositions = new NBTTagList();
            for (BlockPos bedPosition : this.bedPositions) {
                if (bedPosition == null) continue;
                NBTTagCompound nbtTagBedPosition = new NBTTagCompound();
                nbtTagBedPosition.func_74772_a(NBTTAG_VILLAGE_HOMEBEDPOSITION, bedPosition.func_177986_g());
                nbtTagListBedPositions.func_74742_a((NBTBase)nbtTagBedPosition);
            }
            if (!nbtTagListBedPositions.func_82582_d()) {
                nbtTag.func_74782_a(NBTTAG_VILLAGE_HOMEBEDPOSITIONS, (NBTBase)nbtTagListBedPositions);
            }
        }
        return nbtTag;
    }
}

