/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.common.utils.TektopiaUtils;
import bletch.tektopiainformation.network.data.VillageData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.caps.IVillageData;

public class EconomyData {
    protected static final String NBTTAG_VILLAGE_ECONOMY = "economy";
    protected static final String NBTTAG_VILLAGE_PROFESSIONSALES = "psales";
    protected static final String NBTTAG_VILLAGE_MERCHANTSALES = "msales";
    protected static final String NBTTAG_VILLAGE_SALESHISTORY = "hist";
    protected VillageData villageData;
    protected int professionSales;
    protected int merchantSales;
    protected List<ItemStack> salesHistory;

    public EconomyData() {
        this.populateData(null, null);
    }

    protected VillageData getVillageData() {
        return this.villageData;
    }

    public int getProfessionSales() {
        return this.professionSales;
    }

    public int getMerchantSales() {
        return this.merchantSales;
    }

    public List<ItemStack> getSalesHistory() {
        return this.salesHistory == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.salesHistory);
    }

    protected void clearData() {
        this.professionSales = 0;
        this.merchantSales = 0;
        this.salesHistory = new ArrayList<ItemStack>();
    }

    public void populateData(VillageData villageData, Village village) {
        this.clearData();
        this.villageData = villageData;
        if (village != null) {
            List<ItemStack> salesHistory;
            IVillageData townData = village.getTownData();
            this.professionSales = townData != null ? townData.getProfessionSales() : 0;
            int n = this.merchantSales = townData != null && townData.getEconomy() != null ? townData.getEconomy().getSalesHistorySize() : 0;
            if (townData != null && townData.getEconomy() != null && (salesHistory = TektopiaUtils.getEconomySalesHistory(townData.getEconomy())) != null) {
                for (ItemStack itemStack : salesHistory) {
                    if (itemStack == null) continue;
                    this.salesHistory.add(itemStack);
                }
            }
        }
    }

    public void readNBT(VillageData villageData, NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        this.villageData = villageData;
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_ECONOMY)) {
            NBTTagCompound nbtEconomyData = nbtTag.func_74775_l(NBTTAG_VILLAGE_ECONOMY);
            this.professionSales = nbtEconomyData.func_74764_b(NBTTAG_VILLAGE_PROFESSIONSALES) ? nbtEconomyData.func_74762_e(NBTTAG_VILLAGE_PROFESSIONSALES) : 0;
            int n = this.merchantSales = nbtEconomyData.func_74764_b(NBTTAG_VILLAGE_MERCHANTSALES) ? nbtEconomyData.func_74762_e(NBTTAG_VILLAGE_MERCHANTSALES) : 0;
            if (nbtEconomyData.func_74764_b(NBTTAG_VILLAGE_SALESHISTORY)) {
                NBTTagList nbtTagListSalesHistory = nbtEconomyData.func_150295_c(NBTTAG_VILLAGE_SALESHISTORY, 10);
                for (int index = 0; index < nbtTagListSalesHistory.func_74745_c(); ++index) {
                    this.salesHistory.add(new ItemStack(nbtTagListSalesHistory.func_150305_b(index)));
                }
            }
        }
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        int merchantSales;
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        NBTTagCompound nbtEconomyData = new NBTTagCompound();
        int professionSales = this.getProfessionSales();
        if (professionSales > 0) {
            nbtEconomyData.func_74768_a(NBTTAG_VILLAGE_PROFESSIONSALES, professionSales);
        }
        if ((merchantSales = this.getMerchantSales()) > 0) {
            nbtEconomyData.func_74768_a(NBTTAG_VILLAGE_MERCHANTSALES, merchantSales);
        }
        if (this.salesHistory != null && this.salesHistory.size() > 0) {
            NBTTagList nbtTagListSalesHistory = new NBTTagList();
            for (ItemStack itemStack : this.salesHistory) {
                if (itemStack == null || itemStack.func_190926_b()) continue;
                nbtTagListSalesHistory.func_74742_a((NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
            }
            if (!nbtTagListSalesHistory.func_82582_d()) {
                nbtEconomyData.func_74782_a(NBTTAG_VILLAGE_SALESHISTORY, (NBTBase)nbtTagListSalesHistory);
            }
        }
        if (!nbtEconomyData.func_82582_d()) {
            nbtTag.func_74782_a(NBTTAG_VILLAGE_ECONOMY, (NBTBase)nbtEconomyData);
        }
        return nbtTag;
    }
}

