/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.jei;

import bletch.common.utils.TektopiaUtils;
import bletch.common.utils.TextUtils;
import bletch.tektopiainformation.core.ModConfig;
import bletch.tektopiainformation.jei.BlankRecipeCategory;
import bletch.tektopiainformation.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

@ParametersAreNonnullByDefault
@JEIPlugin
public class TektopiaJei
implements IModPlugin {
    private static final String KEY_SUFFIX = ".information";
    private static IJeiHelpers jeiHelpers;
    private static IJeiRuntime jeiRuntime;
    private static final List<BlankRecipeCategory<?>> categories;

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        TektopiaJei.jeiRuntime = jeiRuntime;
    }

    public void register(IModRegistry registry) {
        if (!ModConfig.jei.enableJeiIntegration) {
            return;
        }
        if (ModConfig.jei.showJeiInformationTab) {
            try {
                TektopiaJei.registerTektopiaIngredientInfo(registry);
            }
            catch (Exception ex) {
                LoggerUtils.instance.error(ex.getMessage());
            }
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        if (!ModConfig.jei.enableJeiIntegration) {
            return;
        }
        categories.forEach(c -> registry.addRecipeCategories(new IRecipeCategory[]{c}));
    }

    public static BlankRecipeCategory<?> getCategory(Class<?> categoryClass) {
        return categories.stream().filter(categoryClass::isInstance).findFirst().orElse(null);
    }

    public static IGuiHelper getGuiHelper() {
        return jeiHelpers.getGuiHelper();
    }

    public static IJeiHelpers getJeiHelper() {
        return jeiHelpers;
    }

    public static IJeiRuntime getJeiRuntime() {
        return jeiRuntime;
    }

    public static String getJeiUid(String category) {
        return "tektopiainformation:" + category;
    }

    private static void registerTektopiaIngredientInfo(IModRegistry registry) {
        ArrayList<String> processed = new ArrayList<String>();
        LoggerUtils.instance.info("Registering item/block information with JEI");
        ArrayList<ItemStack> tektopiaItemStacks = new ArrayList<ItemStack>();
        tektopiaItemStacks.addAll(TektopiaUtils.getTektopiaBlockStacks());
        tektopiaItemStacks.addAll(TektopiaUtils.getTektopiaItemStacks());
        ArrayList<String> missingInformation = new ArrayList<String>();
        ArrayList<String> registeredInformation = new ArrayList<String>();
        int count = 0;
        for (ItemStack tektopiaItemStack : tektopiaItemStacks) {
            NonNullList itemStackList = NonNullList.func_191196_a();
            if (tektopiaItemStack.func_77981_g()) {
                Item item = tektopiaItemStack.func_77973_b();
                item.func_150895_a(item.func_77640_w(), itemStackList);
            } else {
                itemStackList.add((Object)tektopiaItemStack);
            }
            for (ItemStack itemStack : itemStackList) {
                String key = itemStack.func_77977_a() + KEY_SUFFIX;
                if (processed.contains(key)) continue;
                processed.add(key);
                if (!itemStack.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("tektopia")) continue;
                if (TextUtils.canTranslate(key) || ModConfig.debug.enableDebug && ModConfig.debug.registerJeiMissingInformation) {
                    try {
                        registry.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, new String[]{key});
                        ++count;
                        if (!ModConfig.debug.enableDebug || !ModConfig.debug.showJeiRegisteredInformation) continue;
                        registeredInformation.add("Registered JEI information for " + itemStack.func_82833_r() + "; key: " + key);
                    }
                    catch (Exception e) {
                        if (!ModConfig.debug.enableDebug) continue;
                        LoggerUtils.instance.writeLine("Error registering JEI information for " + itemStack.func_82833_r() + "; key: " + key, true);
                    }
                    continue;
                }
                if (!ModConfig.debug.enableDebug || !ModConfig.debug.showJeiMissingInformation) continue;
                missingInformation.add("Missing JEI information for " + itemStack.func_82833_r() + "; key: " + key);
            }
        }
        if (ModConfig.debug.enableDebug && registeredInformation.size() > 0) {
            registeredInformation.sort((i1, i2) -> i1.compareTo((String)i2));
            LoggerUtils.instance.writeLines(registeredInformation, true);
        }
        if (ModConfig.debug.enableDebug && missingInformation.size() > 0) {
            missingInformation.sort((i1, i2) -> i1.compareTo((String)i2));
            LoggerUtils.instance.writeLines(missingInformation, true);
        }
        LoggerUtils.instance.info("Registered item/block information with JEI - count: " + count);
    }

    static {
        categories = new ArrayList();
    }
}

