/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic;

import com.animania.Animania;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAgeable;
import com.animania.api.interfaces.IAnimaniaAnimal;
import com.animania.api.interfaces.IBlinking;
import com.animania.api.interfaces.IChild;
import com.animania.api.interfaces.IFoodEating;
import com.animania.api.interfaces.IImpregnable;
import com.animania.api.interfaces.IMateable;
import com.animania.api.interfaces.ISleeping;
import com.animania.api.interfaces.ISterilizable;
import com.animania.api.interfaces.IVariant;
import com.animania.common.entities.generic.ai.GenericAIEatGrass;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GenericBehavior {
    private static Random rand = Animania.RANDOM;

    public static <T extends EntityAnimal & ISleeping & IBlinking> void livingUpdateCommon(T entity) {
        int blinkTimer;
        int happyTimer;
        int wateredTimer;
        if (entity.field_70170_p.field_72995_K) {
            ((IFoodEating)entity).setEatTimer(Math.max(0, ((IFoodEating)entity).getEatTimer() - 1));
        }
        if (entity.func_110167_bD() && ((ISleeping)entity).getSleeping()) {
            ((ISleeping)entity).setSleeping(false);
        }
        if (entity.func_110167_bD() && !((IFoodEating)entity).getInteracted()) {
            ((IFoodEating)entity).setInteracted(true);
        }
        if (entity.func_184207_aI() && ((ISleeping)entity).getSleeping()) {
            ((ISleeping)entity).setSleeping(false);
        }
        if (((IAgeable)entity).getAge() == 0) {
            ((IAgeable)entity).setAge(1);
        }
        int fedTimer = ((IFoodEating)entity).getFedTimer();
        if (AnimaniaConfig.gameRules.ambianceMode) {
            ((IFoodEating)entity).setFed(true);
            ((IFoodEating)entity).setWatered(true);
        }
        if (!(fedTimer <= -1 || AnimaniaConfig.gameRules.requireAnimalInteractionForAI && !((IFoodEating)entity).getInteracted() || AnimaniaConfig.gameRules.ambianceMode)) {
            ((IFoodEating)entity).setFedTimer(--fedTimer);
            if (fedTimer == 0) {
                ((IFoodEating)entity).setFed(false);
            }
        }
        if ((wateredTimer = ((IFoodEating)entity).getWaterTimer()) > -1) {
            ((IFoodEating)entity).setWaterTimer(--wateredTimer);
            if (!(wateredTimer != 0 || AnimaniaConfig.gameRules.requireAnimalInteractionForAI && !((IFoodEating)entity).getInteracted() || AnimaniaConfig.gameRules.ambianceMode)) {
                ((IFoodEating)entity).setWatered(false);
            }
        }
        boolean fed = ((IFoodEating)entity).getFed();
        boolean watered = ((IFoodEating)entity).getWatered();
        if (!fed && !watered) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
            if (AnimaniaConfig.gameRules.animalsStarve) {
                int damageTimer = ((IFoodEating)entity).getDamageTimer();
                if (damageTimer >= AnimaniaConfig.careAndFeeding.starvationTimer) {
                    entity.func_70097_a(DamageSource.field_76366_f, 4.0f);
                    ((IFoodEating)entity).setDamageTimer(0);
                }
                if (!((ISleeping)entity).getSleeping()) {
                    ((IFoodEating)entity).setDamageTimer(++damageTimer);
                }
            }
        } else if (!fed || !watered) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        }
        if ((happyTimer = ((IFoodEating)entity).getHappyTimer()) > -1) {
            ((IFoodEating)entity).setHappyTimer(--happyTimer);
            if (happyTimer == 0) {
                ((IFoodEating)entity).setHappyTimer(60);
                if (!(((IFoodEating)entity).getFed() || ((IFoodEating)entity).getWatered() || ((ISleeping)entity).getSleeping() || !AnimaniaConfig.gameRules.showUnhappyParticles || AnimaniaConfig.gameRules.requireAnimalInteractionForAI && !((IFoodEating)entity).getInteracted())) {
                    double d = rand.nextGaussian() * 0.001;
                    double d1 = rand.nextGaussian() * 0.001;
                    double d2 = rand.nextGaussian() * 0.001;
                    entity.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, entity.field_70165_t + (double)(rand.nextFloat() * entity.field_70130_N) - (double)entity.field_70130_N, entity.field_70163_u + 1.5 + (double)(rand.nextFloat() * entity.field_70131_O), entity.field_70161_v + (double)(rand.nextFloat() * entity.field_70130_N) - (double)entity.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        if ((blinkTimer = ((IBlinking)entity).getBlinkTimer()) > -1) {
            ((IBlinking)entity).setBlinkTimer(--blinkTimer);
            if (blinkTimer == 0) {
                ((IBlinking)entity).setBlinkTimer(100 + rand.nextInt(100));
            }
        }
    }

    public static <T extends EntityAgeable & ISleeping> void livingUpdateChild(T entity, Class<? extends EntityLivingBase> motherClass) {
        World world = entity.field_70170_p;
        entity.func_70873_a((int)(-((0.85 - (double)((IChild)entity).getEntityAge()) * 100.0 * (double)AnimaniaConfig.careAndFeeding.childGrowthTick)));
        boolean fed = ((IFoodEating)entity).getFed();
        boolean watered = ((IFoodEating)entity).getWatered();
        int ageTimer = ((IChild)entity).getAgeTimer();
        ((IChild)entity).setAgeTimer(++ageTimer);
        if (ageTimer >= AnimaniaConfig.careAndFeeding.childGrowthTick && fed && watered && !((ISleeping)entity).getSleeping()) {
            ((IChild)entity).setAgeTimer(0);
            float age = ((IChild)entity).getEntityAge();
            ((IChild)entity).setEntityAge(age += 0.01f);
            if ((double)age >= 0.85 && !entity.field_70170_p.field_72995_K) {
                entity.func_70106_y();
                EntityLiving grownUp = null;
                grownUp = rand.nextInt(2) == 0 ? (EntityLiving)((IAnimaniaAnimal)entity).getAnimalType().getFemale(world) : (EntityLiving)((IAnimaniaAnimal)entity).getAnimalType().getMale(world);
                if (IImpregnable.class.isAssignableFrom(motherClass)) {
                    List<? extends EntityLivingBase> entities = AnimaniaHelper.getEntitiesInRange(motherClass, 15.0, world, entity);
                    for (EntityLivingBase entityLivingBase : entities) {
                        if (!entityLivingBase.getPersistentID().equals(((IChild)entity).getParentUniqueId())) continue;
                        ((IImpregnable)entityLivingBase).setHasKids(false);
                        break;
                    }
                }
                if (grownUp != null) {
                    if (entity instanceof IVariant) {
                        ((IVariant)grownUp).setVariant(((IVariant)entity).getVariant());
                    }
                    grownUp.func_70107_b(entity.field_70165_t, entity.field_70163_u + 0.5, entity.field_70161_v);
                    String name = entity.func_95999_t();
                    if (name != "") {
                        grownUp.func_96094_a(name);
                    }
                    if (grownUp instanceof IAgeable) {
                        ((IAgeable)grownUp).setAge(1);
                    }
                    if (grownUp instanceof IFoodEating) {
                        ((IFoodEating)grownUp).setInteracted(((IFoodEating)entity).getInteracted());
                    }
                    AnimaniaHelper.spawnEntity(world, (Entity)grownUp);
                    grownUp.func_70642_aH();
                }
            }
        }
    }

    public static <T extends EntityAnimal & ISleeping> void livingUpdateMateable(T entity, Class<? extends EntityLivingBase> partnerClass) {
        World world = entity.field_70170_p;
        if (rand.nextInt(200) == 0 && ((IMateable)entity).getMateUniqueId() != null) {
            UUID mateUUID = ((IMateable)entity).getMateUniqueId();
            boolean mateReset = true;
            List<? extends EntityLivingBase> entities = AnimaniaHelper.getEntitiesInRange(partnerClass, 30.0, world, entity);
            for (int k = 0; k <= entities.size() - 1; ++k) {
                UUID id;
                Entity mate = (Entity)entities.get(k);
                if (mate == null || !(id = mate.getPersistentID()).equals(((IMateable)entity).getMateUniqueId()) || mate.field_70128_L) continue;
                mateReset = false;
                break;
            }
            if (mateReset) {
                ((IMateable)entity).setMateUniqueId(null);
            }
        }
    }

    public static <T extends EntityAnimal & ISleeping & IImpregnable> void livingUpdateFemale(T entity, Class<? extends EntityLivingBase> partnerClass) {
        GenericBehavior.livingUpdateMateable(entity, partnerClass);
        World world = entity.field_70170_p;
        int dryTimer = ((IImpregnable)entity).getDryTimer();
        if (!((IImpregnable)entity).getFertile() && dryTimer > -1) {
            ((IImpregnable)entity).setDryTimer(--dryTimer);
        } else {
            ((IImpregnable)entity).setFertile(true);
            ((IImpregnable)entity).setDryTimer(AnimaniaConfig.careAndFeeding.gestationTimer / 9 + rand.nextInt(50));
        }
        int gestationTimer = ((IImpregnable)entity).getGestation();
        if (gestationTimer > -1 && ((IImpregnable)entity).getPregnant()) {
            ((IImpregnable)entity).setGestation(--gestationTimer);
            if (gestationTimer < 200 && ((ISleeping)entity).getSleeping()) {
                ((ISleeping)entity).setSleeping(false);
            }
            if (gestationTimer == 0) {
                UUID MateID = ((IMateable)entity).getMateUniqueId();
                List<? extends EntityLivingBase> entities = AnimaniaHelper.getEntitiesInRange(partnerClass, 30.0, world, entity);
                EntityLiving male = null;
                for (EntityLivingBase entityLivingBase : entities) {
                    if (entityLivingBase == null || !entityLivingBase.getPersistentID().equals(MateID)) continue;
                    male = (EntityLiving)entityLivingBase;
                    break;
                }
                if (!((IFoodEating)entity).getFed() && !((IFoodEating)entity).getWatered() && rand.nextDouble() <= AnimaniaConfig.careAndFeeding.animalLossChance) {
                    ((IImpregnable)entity).setPregnant(false);
                    ((IImpregnable)entity).setFertile(false);
                    ((IImpregnable)entity).setHasKids(false);
                    return;
                }
                double birthChance = 1.0;
                while (rand.nextDouble() <= birthChance) {
                    birthChance *= AnimaniaConfig.careAndFeeding.birthMultipleChance;
                    entity.func_146082_f(null);
                    AnimaniaType maleType = male == null ? ((IAnimaniaAnimal)entity).getAnimalType() : ((IAnimaniaAnimal)male).getAnimalType();
                    AnimaniaType babyType = maleType.breed(((IAnimaniaAnimal)entity).getAnimalType());
                    EntityAgeable entityKid = (EntityAgeable)babyType.getChild(entity.field_70170_p);
                    entityKid.func_70107_b(entity.field_70165_t, entity.field_70163_u + 0.2, entity.field_70161_v);
                    ((IChild)entityKid).setParentUniqueId(entity.getPersistentID());
                    entityKid.func_70642_aH();
                    if (entityKid instanceof IFoodEating) {
                        ((IFoodEating)entityKid).setInteracted(((IFoodEating)entity).getInteracted());
                    }
                    if (!world.field_72995_K) {
                        AnimaniaHelper.spawnEntity(world, (Entity)entityKid);
                    }
                    ((IImpregnable)entity).setPregnant(false);
                    ((IImpregnable)entity).setFertile(false);
                    ((IImpregnable)entity).setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent(entity, male == null ? entity : male, entityKid);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                }
            }
        } else if (gestationTimer < 0) {
            ((IImpregnable)entity).setGestation(1);
        }
    }

    public static <T extends EntityAnimal & ISleeping> boolean interactCommon(T entity, EntityPlayer player, EnumHand hand, @Nullable GenericAIEatGrass<T> eatAI) {
        ItemStack stack;
        if (!((IFoodEating)entity).getInteracted()) {
            ((IFoodEating)entity).setInteracted(true);
        }
        if ((stack = player.func_184586_b(hand)) != ItemStack.field_190927_a && AnimaniaHelper.isWaterContainer(stack) && !((ISleeping)entity).getSleeping()) {
            if (!player.func_184812_l_()) {
                ItemStack emptied = AnimaniaHelper.emptyContainer(stack);
                stack.func_190918_g(1);
                AnimaniaHelper.addItem(player, emptied);
            }
            ((IFoodEating)entity).setEatTimer(40);
            if (eatAI != null) {
                eatAI.func_75249_e();
            }
            ((IFoodEating)entity).setWatered(true);
            entity.func_146082_f(player);
            return true;
        }
        if (entity.func_70877_b(stack)) {
            EntityTameable tame;
            if (((ISleeping)entity).getSleeping()) {
                return true;
            }
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            ((IFoodEating)entity).setFed(true);
            ((IFoodEating)entity).setHandFed(true);
            if (eatAI != null) {
                eatAI.func_75249_e();
            }
            ((IFoodEating)entity).setEatTimer(80);
            if (entity instanceof EntityTameable && !(tame = (EntityTameable)entity).func_70909_n()) {
                tame.func_184754_b(player.getPersistentID());
                tame.func_70903_f(true);
            }
            entity.func_146082_f(player);
            return true;
        }
        if (entity instanceof EntityTameable) {
            EntityTameable tame = (EntityTameable)entity;
            if (stack.func_190926_b() && tame.func_70909_n() && !tame.func_70906_o() && !player.func_70093_af() && !((ISleeping)entity).getSleeping()) {
                tame.func_70904_g(true);
                tame.func_70637_d(false);
                tame.func_70661_as().func_75499_g();
                return true;
            }
            if (stack.func_190926_b() && tame.func_70909_n() && tame.func_70906_o() && !player.func_70093_af() && !((ISleeping)entity).getSleeping()) {
                tame.func_70904_g(false);
                tame.func_70637_d(false);
                tame.func_70661_as().func_75499_g();
                return true;
            }
        }
        return false;
    }

    public static <T extends EntityAnimal & ISleeping & IAnimaniaAnimal> void initialSpawnFemale(T entity, Class<? extends EntityLivingBase> baseClass) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        int chooser = rand.nextInt(3);
        List<? extends EntityLivingBase> others = AnimaniaHelper.getEntitiesInRange(baseClass, 64.0, entity.field_70170_p, entity.func_180425_c());
        if (others.size() <= 8) {
            EntityLivingBase animal = null;
            if (chooser == 0) {
                animal = ((IAnimaniaAnimal)entity).getAnimalType().getMale(entity.field_70170_p);
                IMateable mateable = (IMateable)animal;
                mateable.setMateUniqueId(entity.func_110124_au());
            } else if (chooser == 1) {
                animal = ((IAnimaniaAnimal)entity).getAnimalType().getChild(entity.field_70170_p);
                ((IChild)animal).setParentUniqueId(entity.func_110124_au());
                ((IImpregnable)entity).setHasKids(true);
            }
            if (animal != null) {
                animal.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                AnimaniaHelper.spawnEntity(entity.field_70170_p, (Entity)animal);
            }
        }
    }

    public static <T extends EntityAnimal & ISleeping> void writeCommonNBT(NBTTagCompound tag, T entity) {
        IMateable mateable;
        UUID mate;
        tag.func_74757_a("Fed", ((IFoodEating)entity).getFed());
        tag.func_74757_a("Interacted", ((IFoodEating)entity).getInteracted());
        tag.func_74757_a("Handfed", ((IFoodEating)entity).getHandFed());
        tag.func_74757_a("Watered", ((IFoodEating)entity).getWatered());
        tag.func_74768_a("Age", ((IAgeable)entity).getAge());
        tag.func_74757_a("Sleep", ((ISleeping)entity).getSleeping());
        tag.func_74776_a("SleepTimer", ((ISleeping)entity).getSleepTimer().floatValue());
        if (entity instanceof IImpregnable) {
            IImpregnable preg = (IImpregnable)entity;
            tag.func_74757_a("Pregnant", preg.getPregnant());
            tag.func_74757_a("HasKids", preg.getHasKids());
            tag.func_74757_a("Fertile", preg.getFertile());
            tag.func_74768_a("Gestation", preg.getGestation());
        }
        if (entity instanceof IMateable && (mate = (mateable = (IMateable)entity).getMateUniqueId()) != null) {
            tag.func_74778_a("MateUUID", mate.toString());
        }
        if (entity instanceof ISterilizable) {
            tag.func_74757_a("Sterilized", ((ISterilizable)entity).getSterilized());
        }
        if (entity instanceof IChild) {
            IChild child = (IChild)entity;
            tag.func_74776_a("Age", child.getEntityAge());
            if (child.getParentUniqueId() != null) {
                tag.func_74778_a("ParentUUID", child.getParentUniqueId().toString());
            }
        }
    }

    public static <T extends EntityAnimal & ISleeping> void readCommonNBT(NBTTagCompound tag, T entity) {
        String s;
        ((IFoodEating)entity).setFed(tag.func_74767_n("Fed"));
        ((IFoodEating)entity).setInteracted(tag.func_74767_n("Interacted"));
        ((IFoodEating)entity).setHandFed(tag.func_74767_n("Handfed"));
        ((IFoodEating)entity).setWatered(tag.func_74767_n("Watered"));
        ((IAgeable)entity).setAge(tag.func_74762_e("Age"));
        ((ISleeping)entity).setSleeping(tag.func_74767_n("Sleep"));
        ((ISleeping)entity).setSleepTimer(Float.valueOf(tag.func_74760_g("SleepTimer")));
        if (entity instanceof IImpregnable) {
            IImpregnable preg = (IImpregnable)entity;
            preg.setPregnant(tag.func_74767_n("Pregnant"));
            preg.setHasKids(tag.func_74767_n("HasKids"));
            preg.setFertile(tag.func_74767_n("Fertile"));
            preg.setGestation(tag.func_74762_e("Gestation"));
        }
        if (entity instanceof IMateable) {
            IMateable mateable = (IMateable)entity;
            s = "";
            if (tag.func_74764_b("MateUUID")) {
                s = tag.func_74779_i("MateUUID");
            }
            if (!s.isEmpty()) {
                mateable.setMateUniqueId(UUID.fromString(s));
            }
        }
        if (entity instanceof ISterilizable) {
            ((ISterilizable)entity).setSterilized(tag.func_74767_n("Sterilized"));
        }
        if (entity instanceof IChild) {
            IChild child = (IChild)entity;
            s = "";
            if (tag.func_74764_b("ParentUUID")) {
                s = tag.func_74779_i("ParentUUID");
            }
            if (!s.isEmpty()) {
                child.setParentUniqueId(UUID.fromString(s));
            }
            child.setEntityAge(tag.func_74760_g("Age"));
        }
    }

    public static SoundEvent getRandomSound(SoundEvent ... sounds) {
        if (sounds == null || sounds.length == 0) {
            return null;
        }
        return sounds[rand.nextInt(sounds.length)];
    }

    public static <T extends EntityAnimal & ISleeping> SoundEvent getAmbientSound(T entity, SoundEvent ... sounds) {
        int len;
        if (sounds == null || sounds.length == 0) {
            return null;
        }
        int num = len = sounds.length * 8;
        if (((IFoodEating)entity).getWatered()) {
            num -= len / 3;
        }
        if (((IFoodEating)entity).getFed()) {
            num -= len / 3;
        }
        if (((ISleeping)entity).getSleeping()) {
            return null;
        }
        int index = rand.nextInt(num);
        if (index > sounds.length - 1) {
            return null;
        }
        return sounds[index];
    }
}

