/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class RotatingSplitMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        if (type == BoundingBoxType.COLLISION && !topBlock) {
            return null;
        }
        return AABBUtils.rotate((AxisAlignedBB)IDoorMovement.getHalfBoundingBox(), (int)(topBlock ? -1 : 1), (EnumFacing.Axis)EnumFacing.Axis.X);
    }

    private Rotation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float angle = 90.0f;
        float hingeY = -0.40625f;
        float hingeZ = -0.40625f;
        if (topBlock) {
            angle = -angle;
            hingeY = 1.0f - hingeY;
        }
        Rotation rotation = new Rotation(angle).aroundAxis(1.0f, 0.0f, 0.0f).offset(0.0f, hingeY, hingeZ);
        rotation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        rotation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return rotation;
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model.getShape("top"), (Transformation)this.getTransformation(tileEntity, true)), new Animation((ITransformable)model.getShape("bottom"), (Transformation)this.getTransformation(tileEntity, false))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

