/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.common.config.MekanismConfig;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.ITier;

public enum CableTier implements ITier
{
    BASIC(3200),
    ADVANCED(12800),
    ELITE(64000),
    ULTIMATE(320000);

    private final int baseCapacity;
    private final BaseTier baseTier;

    private CableTier(int capacity) {
        this.baseCapacity = capacity;
        this.baseTier = BaseTier.values()[this.ordinal()];
    }

    public static CableTier get(BaseTier tier) {
        for (CableTier transmitter : CableTier.values()) {
            if (transmitter.getBaseTier() != tier) continue;
            return transmitter;
        }
        return BASIC;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public int getCableCapacity() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).CableCapacity.val();
    }

    public int getBaseCapacity() {
        return this.baseCapacity;
    }
}

