/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle;

import CoroUtil.forge.CULog;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.ARBDrawInstanced;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GLContext;

public class ShaderManager {
    private static boolean check = true;
    private static boolean canUseShaders = false;
    private static boolean canUseShadersInstancedRendering = false;
    private static boolean useARBInstancedRendering = false;
    private static boolean useARBShaders = false;
    private static boolean useARBVBO = false;
    private static boolean useARBVAO = false;
    private static boolean useARBInstancedArrays = false;

    public static boolean canUseShadersInstancedRendering() {
        if (check) {
            check = false;
            ShaderManager.queryGLCaps();
        }
        return canUseShadersInstancedRendering;
    }

    public static void disableShaders() {
        canUseShaders = false;
        canUseShadersInstancedRendering = false;
    }

    public static void queryGLCaps() {
        ContextCapabilities contextcapabilities = GLContext.getCapabilities();
        CULog.log("Extended Renderer: Detected GLSL version: " + GL11.glGetString((int)35724));
        boolean bl = useARBVBO = !contextcapabilities.OpenGL15 && contextcapabilities.GL_ARB_vertex_buffer_object;
        if (contextcapabilities.OpenGL21 || contextcapabilities.GL_ARB_vertex_shader && contextcapabilities.GL_ARB_fragment_shader && contextcapabilities.GL_ARB_shader_objects) {
            canUseShaders = true;
            useARBShaders = !contextcapabilities.OpenGL21;
            if (contextcapabilities.OpenGL33 || contextcapabilities.GL_ARB_draw_instanced && contextcapabilities.GL_ARB_instanced_arrays && contextcapabilities.GL_ARB_vertex_array_object) {
                canUseShadersInstancedRendering = true;
                if (contextcapabilities.OpenGL33) {
                    useARBInstancedRendering = false;
                    useARBInstancedArrays = false;
                    useARBVAO = false;
                } else {
                    useARBInstancedRendering = true;
                    useARBInstancedArrays = true;
                    useARBVAO = true;
                }
            } else {
                CULog.log("Extended Renderer WARNING: Unable to use instanced rendering shaders, OpenGL33: " + contextcapabilities.OpenGL33 + ", (GL_ARB_draw_instanced: " + contextcapabilities.GL_ARB_draw_instanced + ", GL_ARB_instanced_arrays: " + contextcapabilities.GL_ARB_instanced_arrays + ", GL_ARB_vertex_array_object: " + contextcapabilities.GL_ARB_vertex_array_object + ")");
                canUseShadersInstancedRendering = false;
            }
        } else {
            CULog.log("Extended Renderer WARNING: Unable to use shaders, OpenGL21: " + contextcapabilities.OpenGL21 + ", (GL_ARB_vertex_shader: " + contextcapabilities.GL_ARB_vertex_shader + ", GL_ARB_fragment_shader: " + contextcapabilities.GL_ARB_fragment_shader + ", GL_ARB_shader_objects: " + contextcapabilities.GL_ARB_shader_objects + ")");
            canUseShadersInstancedRendering = false;
        }
    }

    public static void glDrawElementsInstanced(int mode, int indices_count, int type, long indices_buffer_offset, int primcount) {
        if (useARBInstancedRendering) {
            ARBDrawInstanced.glDrawElementsInstancedARB((int)mode, (int)indices_count, (int)type, (long)indices_buffer_offset, (int)primcount);
        } else {
            GL31.glDrawElementsInstanced((int)mode, (int)indices_count, (int)type, (long)indices_buffer_offset, (int)primcount);
        }
    }

    public static void glShaderSource(int shader, CharSequence string) {
        if (useARBShaders) {
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)string);
        } else {
            GL20.glShaderSource((int)shader, (CharSequence)string);
        }
    }

    public static void glBindAttribLocation(int program, int index, CharSequence name) {
        if (useARBShaders) {
            ARBVertexShader.glBindAttribLocationARB((int)program, (int)index, (CharSequence)name);
        } else {
            GL20.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
        }
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long buffer_buffer_offset) {
        if (useARBShaders) {
            ARBVertexShader.glVertexAttribPointerARB((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)buffer_buffer_offset);
        } else {
            GL20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)buffer_buffer_offset);
        }
    }

    public static void glEnableVertexAttribArray(int index) {
        if (useARBShaders) {
            ARBVertexShader.glEnableVertexAttribArrayARB((int)index);
        } else {
            GL20.glEnableVertexAttribArray((int)index);
        }
    }

    public static void glDisableVertexAttribArray(int index) {
        if (useARBShaders) {
            ARBVertexShader.glDisableVertexAttribArrayARB((int)index);
        } else {
            GL20.glDisableVertexAttribArray((int)index);
        }
    }

    public static void glBufferData(int target, FloatBuffer data, int usage) {
        if (useARBVBO) {
            ARBVertexBufferObject.glBufferDataARB((int)target, (FloatBuffer)data, (int)usage);
        } else {
            GL15.glBufferData((int)target, (FloatBuffer)data, (int)usage);
        }
    }

    public static void glBufferData(int target, IntBuffer data, int usage) {
        if (useARBVBO) {
            ARBVertexBufferObject.glBufferDataARB((int)target, (IntBuffer)data, (int)usage);
        } else {
            GL15.glBufferData((int)target, (IntBuffer)data, (int)usage);
        }
    }

    public static void glVertexAttribDivisor(int index, int divisor) {
        if (useARBInstancedArrays) {
            ARBInstancedArrays.glVertexAttribDivisorARB((int)index, (int)divisor);
        } else {
            GL33.glVertexAttribDivisor((int)index, (int)divisor);
        }
    }

    public static void glBindVertexArray(int array) {
        if (useARBVAO) {
            ARBVertexArrayObject.glBindVertexArray((int)array);
        } else {
            GL30.glBindVertexArray((int)array);
        }
    }

    public static void glDeleteVertexArrays(int array) {
        if (useARBVAO) {
            ARBVertexArrayObject.glDeleteVertexArrays((int)array);
        } else {
            GL30.glDeleteVertexArrays((int)array);
        }
    }

    public static int glGenVertexArrays() {
        if (useARBVAO) {
            return ARBVertexArrayObject.glGenVertexArrays();
        }
        return GL30.glGenVertexArrays();
    }

    public static void resetCheck() {
        check = true;
    }
}

