/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox.debug;

import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.handler.SignalStateFileV2;
import com.troblecodings.signals.handler.SignalStatePosV2;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.Logger;

public class DebugSignalStateFileV2
extends SignalStateFileV2 {
    private final HashMap<BlockPos, SignalStatePosV2> createdPositions = new HashMap();
    private final HashMap<BlockPos, SignalStatePosV2> foundPositions = new HashMap();
    private final HashMap<SignalStatePosV2, byte[]> dataCache = new HashMap();
    private final Logger logger = OpenSignalsMain.getLogger();

    public DebugSignalStateFileV2(Path path) {
        super(path);
    }

    @Override
    @Nullable
    public synchronized SignalStatePosV2 create(BlockPos pos) {
        if (this.createdPositions.containsKey(pos)) {
            this.logger.warn("{} was already created!", (Object)pos.toString());
        }
        SignalStatePosV2 statePos = super.create(pos);
        this.createdPositions.put(pos, statePos);
        return statePos;
    }

    @Override
    @Nullable
    public synchronized SignalStatePosV2 find(BlockPos pos) {
        SignalStatePosV2 oldPosition;
        SignalStatePosV2 statePos = super.find(pos);
        if (this.foundPositions.containsKey(pos) && statePos != null && !(oldPosition = this.foundPositions.get(pos)).equals(statePos)) {
            this.logger.warn("{} unpersistent data detected!", (Object)pos.toString());
            this.logger.warn("Old: {}, New: {}", (Object)oldPosition.toString(), (Object)statePos.toString());
        }
        return statePos;
    }

    @Override
    @Nullable
    public synchronized ByteBuffer read(SignalStatePosV2 pos) {
        byte[] array;
        ByteBuffer buffer = super.read(pos);
        if (this.dataCache.containsKey(pos) && !Arrays.equals(array = this.dataCache.get(pos), buffer.array())) {
            this.logger.warn("Data wrong from read!");
            this.logger.warn("Old: {}, New: {}", (Object)Arrays.toString(array), (Object)Arrays.toString(buffer.array()));
        }
        if (buffer.array().length != 256) {
            this.logger.warn("Wrong buffer size for read: {}!", (Object)buffer.array().length);
        }
        return buffer;
    }

    @Override
    public synchronized void write(SignalStatePosV2 pos, ByteBuffer buffer) {
        if (buffer.array().length != 256) {
            this.logger.warn("Wrong buffer size for write: {}!", (Object)buffer.array().length);
        }
        super.write(pos, buffer);
        this.dataCache.put(pos, Arrays.copyOf(buffer.array(), buffer.array().length));
    }

    @Override
    public synchronized SignalStatePosV2 deleteIndex(BlockPos pos) {
        SignalStatePosV2 statePos = super.deleteIndex(pos);
        this.createdPositions.remove(pos);
        this.dataCache.remove(statePos);
        return statePos;
    }
}

