/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIBox;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.render.UIBorder;
import com.troblecodings.guilib.ecs.entitys.render.UIColor;
import com.troblecodings.signals.enums.EnumGuiMode;
import com.troblecodings.signals.guis.UISignalBoxTile;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxNode;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.Rotation;

public class UIMenu
extends UIComponent {
    private double mX;
    private double mY;
    private int selection = 0;
    private int rotation = 0;
    private BiConsumer<Integer, Integer> consumer = (i1, i2) -> {};

    @Override
    public void draw(DrawInfo info) {
    }

    @Override
    public void update() {
    }

    @Override
    public void postDraw(DrawInfo info) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
            UIEntity selection = new UIEntity();
            selection.setX(this.mX);
            selection.setY(this.mY);
            selection.setHeight(20.0);
            selection.setWidth(22 * EnumGuiMode.values().length);
            selection.add(new UIBox(UIBox.HBOX, 2));
            for (EnumGuiMode mode : EnumGuiMode.values()) {
                UIEntity preview = new UIEntity();
                preview.add(new UIColor(-5263441));
                SignalBoxNode node = new SignalBoxNode(new Point(-1, -1));
                node.add(new ModeSet(mode, Rotation.values()[this.rotation]));
                UISignalBoxTile sbt = new UISignalBoxTile(node);
                preview.add(sbt);
                preview.setHeight(20.0);
                preview.setWidth(20.0);
                if (mode.ordinal() == this.selection) {
                    preview.add(new UIBorder(-16711936, 1.0f));
                }
                selection.add(preview);
            }
            selection.updateEvent(this.parent.getLastUpdateEvent());
            selection.draw(info);
            GlStateManager.func_179121_F();
        }
    }

    public int getSelection() {
        return this.selection;
    }

    public void setConsumer(BiConsumer<Integer, Integer> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void mouseEvent(UIEntity.MouseEvent event) {
        switch (event.state) {
            case CLICKED: {
                if (event.key != 1) {
                    return;
                }
                if (!this.isVisible()) {
                    this.mX = event.x;
                    this.mY = event.y;
                }
                this.selection = Math.max(0, Math.min(EnumGuiMode.values().length - 1, (int)((event.x - this.mX) / 22.0)));
                this.consumer.accept(this.selection, this.rotation);
                this.setVisible(true);
                break;
            }
            case RELEASE: {
                this.setVisible(false);
                break;
            }
        }
    }

    @Override
    public void keyEvent(UIEntity.KeyEvent event) {
        super.keyEvent(event);
        if (event.typedChar == 82 || event.typedChar == 114) {
            ++this.rotation;
            if (this.rotation >= Rotation.values().length) {
                this.rotation = 0;
            }
            this.consumer.accept(this.selection, this.rotation);
        }
    }

    public int getRotation() {
        return this.rotation;
    }
}

