/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.TrainNumber;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxGrid;
import com.troblecodings.signals.signalbox.SignalBoxTileEntity;
import com.troblecodings.signals.tileentitys.IChunkLoadable;
import com.troblecodings.signals.tileentitys.TrainNumberTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.util.math.BlockPos;

public class TrainNumberContainer
extends ContainerBase
implements IChunkLoadable {
    private TrainNumberTileEntity tile;
    protected final List<Point> validPoints = new ArrayList<Point>();
    protected Point setPoint;
    protected TrainNumber number = TrainNumber.DEFAULT;
    protected BlockPos linkedPos;

    public TrainNumberContainer(GuiInfo info) {
        super(info);
        if (info.pos != null) {
            this.tile = (TrainNumberTileEntity)info.getTile();
        }
    }

    @Override
    public void sendAllDataToRemote() {
        WriteBuffer buffer = new WriteBuffer();
        BlockPos linkedPos = this.tile.getLinkedSignalBox();
        buffer.putBlockPos(linkedPos == null ? BlockPos.field_177992_a : linkedPos);
        this.tile.getCurrentPoint().writeNetwork(buffer);
        this.tile.getTrainNumber().writeNetwork(buffer);
        AtomicReference<SignalBoxGrid> grid = new AtomicReference<SignalBoxGrid>(SignalBoxHandler.getGrid(new StateInfo(this.info.world, linkedPos)));
        if (grid.get() == null) {
            this.loadChunkAndGetTile(SignalBoxTileEntity.class, this.info.world, linkedPos, (boxTile, _u) -> grid.set(boxTile.getSignalBoxGrid()));
        }
        if (grid.get() == null) {
            return;
        }
        List<Point> validPoints = grid.get().getAllPoints();
        buffer.putInt(validPoints.size());
        for (Point point : validPoints) {
            point.writeNetwork(buffer);
        }
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    @Override
    public void deserializeClient(ReadBuffer buf) {
        this.linkedPos = buf.getBlockPos();
        if (this.linkedPos.equals((Object)BlockPos.field_177992_a)) {
            this.linkedPos = null;
        }
        this.setPoint = Point.of(buf);
        this.number = TrainNumber.of(buf);
        this.validPoints.clear();
        int size = buf.getInt();
        for (int i = 0; i < size; ++i) {
            this.validPoints.add(Point.of(buf));
        }
        this.update();
    }

    @Override
    public void deserializeServer(ReadBuffer buf) {
        TrainNumberNetwork mode = buf.getEnumValue(TrainNumberNetwork.class);
        if (mode.equals((Object)TrainNumberNetwork.SEND_NEW_POINT)) {
            this.tile.setNewPoint(Point.of(buf));
        } else if (mode.equals((Object)TrainNumberNetwork.SET_TRAINNUMBER)) {
            this.tile.updateTrainNumberManually();
        } else if (mode.equals((Object)TrainNumberNetwork.SEND_NEW_TRAINNUMBER)) {
            this.tile.setNewTrainNumber(TrainNumber.of(buf));
        }
    }

    public static enum TrainNumberNetwork {
        SEND_NEW_TRAINNUMBER,
        SEND_NEW_POINT,
        SET_TRAINNUMBER;

    }
}

